/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.xmind.cathy.internal.AutoSaveService;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CathyWorkbenchWindowAdvisor;

public class CathyWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String PERSPECTIVE_ID = "org.xmind.ui.perspective.mindmapping";
    private AutoSaveService autoSaveService = null;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new CathyWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        configurer.setExitOnLastWindowClose(true);
    }

    public boolean preShutdown() {
        boolean readyToShutDown = super.preShutdown();
        if (readyToShutDown && !CathyPlugin.getDefault().getPreferenceStore().getBoolean("restoreLastSession") && !this.closeAllEditors()) {
            return false;
        }
        return readyToShutDown;
    }

    private boolean closeAllEditors() {
        boolean closed = false;
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            closed |= window.getActivePage().closeAllEditors(true);
            ++n2;
        }
        return closed;
    }

    public void postShutdown() {
        if (this.autoSaveService != null) {
            this.autoSaveService.dispose();
            this.autoSaveService = null;
        }
        super.postShutdown();
    }

    public void postStartup() {
        super.postStartup();
        this.autoSaveService = new AutoSaveService(this.getWorkbenchConfigurer().getWorkbench());
    }
}

