/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.actions.NewMenu;
import org.xmind.cathy.internal.actions.ShowKeyAssistAction;
import org.xmind.cathy.internal.actions.UpdateAction;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.OpenWorkbookAction;

public class CathyWorkbenchActionBuilder
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction openAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction updateAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private IContributionItem reopenEditors;
    private IAction keyAssistAction;
    private NewMenu newMenu;

    public CathyWorkbenchActionBuilder(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.newMenu = new NewMenu(window);
        this.register(this.newMenu.getNewWorkbookAction());
        this.register(this.newMenu.getNewFromTemplateAction());
        this.openAction = new OpenWorkbookAction(window);
        this.register((IAction)this.openAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportAction);
        this.importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.renameAction = ActionFactory.RENAME.create(window);
        this.register((IAction)this.renameAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findAction);
        this.reopenEditors = ContributionItemFactory.REOPEN_EDITORS.create(window);
        this.updateAction = new UpdateAction("org.xmind.ui.update", window);
        this.register((IAction)this.updateAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.keyAssistAction = new ShowKeyAssistAction();
        this.register(this.keyAssistAction);
    }

    private static boolean isPro() {
        return Platform.getBundle((String)"org.xmind.meggy") != null;
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.File_menu_text, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        String newText = MindMapMessages.NewWorkbook_text;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId);
        newMenu.setActionDefinitionId("org.eclipse.ui.file.newQuickMenu");
        newMenu.add((IContributionItem)new Separator(newId));
        newMenu.add((IContributionItem)this.newMenu);
        newMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)newMenu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("save.group"));
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.printAction);
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importAction);
        menu.add((IAction)this.exportAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(this.reopenEditors);
        menu.add((IContributionItem)new Separator());
        ActionContributionItem exitItem = new ActionContributionItem((IAction)this.exitAction);
        exitItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)exitItem);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.Edit_menu_text, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        ActionContributionItem openPreferencesItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        openPreferencesItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)openPreferencesItem);
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        return menu;
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(WorkbenchMessages.Help_menu_text, "help");
        menu.add((IContributionItem)new GroupMarker("group.welcome"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("group.intro"));
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        menu.add((IContributionItem)new Separator("group.main"));
        menu.add((IContributionItem)new GroupMarker("group.assist"));
        menu.add(this.keyAssistAction);
        menu.add((IContributionItem)new GroupMarker("group.xmind"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        menu.add((IContributionItem)new Separator("group.tutorials"));
        menu.add((IContributionItem)new Separator("group.tools"));
        menu.add((IContributionItem)new Separator("group.updates"));
        menu.add((IAction)this.updateAction);
        if (!CathyWorkbenchActionBuilder.isPro()) {
            menu.add((IContributionItem)new GroupMarker("group.upgrade"));
        }
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
        aboutItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)aboutItem);
        menu.add((IContributionItem)new GroupMarker("about.ext"));
        return menu;
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        super.fillCoolBar(coolBar);
        IActionBarConfigurer2 actionBarConfigurer = (IActionBarConfigurer2)this.getActionBarConfigurer();
        coolBar.add((IContributionItem)new GroupMarker("org.xmind.ui.group.file"));
        IToolBarManager fileBar = actionBarConfigurer.createToolBarManager();
        fileBar.add((IContributionItem)new GroupMarker("new.group"));
        fileBar.add(this.newMenu.getNewWorkbookAction());
        fileBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileBar.add((IAction)this.openAction);
        fileBar.add((IContributionItem)new GroupMarker("open.ext"));
        fileBar.add((IContributionItem)new GroupMarker("save.group"));
        fileBar.add((IAction)this.saveAction);
        fileBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileBar.add((IAction)this.printAction);
        fileBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(fileBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("org.xmind.ui.group.undo"));
        IToolBarManager undoBar = actionBarConfigurer.createToolBarManager();
        undoBar.add((IAction)this.undoAction);
        undoBar.add((IContributionItem)new GroupMarker("undo.ext"));
        undoBar.add((IAction)this.redoAction);
        undoBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(undoBar, "org.xmind.ui.org.xmind.ui.workbench.undo"));
        coolBar.add((IContributionItem)new GroupMarker("org.xmind.ui.group.edit"));
        IToolBarManager editBar = actionBarConfigurer.createToolBarManager();
        editBar.add((IAction)this.cutAction);
        editBar.add((IAction)this.copyAction);
        editBar.add((IContributionItem)new GroupMarker("cut.ext"));
        editBar.add((IAction)this.pasteAction);
        editBar.add((IAction)this.deleteAction);
        editBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(editBar, "org.xmind.ui.org.xmind.ui.workbench.edit"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new GroupMarker("group.editor"));
    }
}

