/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyPermission;

public class AppPolicy {
    private String _host = null;
    private File _extensionDir = null;
    private static AppPolicy _instance = null;

    public static AppPolicy getInstance() {
        return _instance;
    }

    public static AppPolicy createInstance(String string) {
        if (_instance == null) {
            _instance = new AppPolicy(string);
        }
        return _instance;
    }

    private AppPolicy(String string) {
        this._host = string;
        this._extensionDir = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public void addPermissions(PermissionCollection permissionCollection, CodeSource codeSource, boolean bl) throws ExitException {
        this.addPermissions(JNLPClassLoaderUtil.getInstance(), permissionCollection, codeSource, bl);
    }

    public void addPermissions(JNLPClassLoaderIf jNLPClassLoaderIf, PermissionCollection permissionCollection, CodeSource codeSource, boolean bl) throws ExitException {
        Trace.println((String)("JAVAWS AppPolicy Permission requested for: " + codeSource.getLocation()), (TraceLevel)TraceLevel.SECURITY);
        JARDesc jARDesc = jNLPClassLoaderIf.getJarDescFromURL(codeSource.getLocation());
        if (jARDesc == null) {
            return;
        }
        LaunchDesc launchDesc = null;
        int n = 0;
        if (jARDesc.getParent() != null) {
            launchDesc = jARDesc.getParent().getParent();
            n = launchDesc.getSecurityModel();
        }
        if (bl && n != 0) {
            this.grantUnrestrictedAccess(launchDesc, codeSource);
            if (n == 1) {
                CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
            } else {
                this.addJ2EEApplicationClientPermissionsObject(permissionCollection);
            }
        }
        if (!permissionCollection.implies(new AllPermission())) {
            this.addSandboxPermissionsObject(permissionCollection, launchDesc != null && launchDesc.getLaunchType() == 2);
        }
        if (launchDesc != null && !launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                PropertyPermission propertyPermission = new PropertyPermission(string, "write");
                PermissionCollection permissionCollection2 = Policy.getPolicy().getPermissions(codeSource);
                if (permissionCollection.implies(propertyPermission) || permissionCollection2.implies(propertyPermission)) {
                    System.setProperty(string, string2);
                    continue;
                }
                Trace.ignoredException((Exception)new AccessControlException("access denied " + propertyPermission, propertyPermission));
            }
            launchDesc.setPropsSet(true);
        }
    }

    private void setUnrestrictedProps(LaunchDesc launchDesc) {
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                System.setProperty(string, properties.getProperty(string));
            }
            launchDesc.setPropsSet(true);
        }
    }

    public void grantUnrestrictedAccess(LaunchDesc launchDesc, CodeSource codeSource) throws ExitException {
        Object object;
        AppInfo appInfo = launchDesc.getAppInfo();
        boolean bl = false;
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (localInstallHandler.isLocalInstallSupported() && (object = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome())) != null && !object.getAskedForInstall()) {
            bl = true;
        }
        if (bl) {
            object = launchDesc.getInformation().getShortcut();
            switch (Config.getShortcutValue()) {
                default: {
                    break;
                }
                case 3: {
                    if (object == null) break;
                }
                case 1: 
                case 2: 
                case 4: {
                    if (object != null) {
                        appInfo.setDesktopHint(((ShortcutDesc)object).getDesktop());
                        appInfo.setMenuHint(((ShortcutDesc)object).getMenu());
                        appInfo.setSubmenu(((ShortcutDesc)object).getSubmenu());
                        break;
                    }
                    appInfo.setDesktopHint(true);
                    appInfo.setMenuHint(true);
                }
            }
            if (localInstallHandler.isAssociationSupported() && Config.getAssociationValue() != 0) {
                appInfo.setAssociations(launchDesc.getInformation().getAssociations());
            }
        }
        try {
            if (Globals.isSecureMode() || TrustDecider.isAllPermissionGranted((CodeSource)codeSource, (AppInfo)appInfo)) {
                this.setUnrestrictedProps(launchDesc);
                return;
            }
            Trace.println((String)"We were not granted permission, exiting", (TraceLevel)TraceLevel.SECURITY);
        }
        catch (Exception exception) {
            BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)appInfo, (Exception)exception);
        }
        Main.systemExit(-1);
    }

    private void addJ2EEApplicationClientPermissionsObject(PermissionCollection permissionCollection) {
        Trace.println((String)"Creating J2EE-application-client-permisisons object", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new AWTPermission("accessClipboard"));
        permissionCollection.add(new AWTPermission("accessEventQueue"));
        permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("loadLibrary"));
        permissionCollection.add(new RuntimePermission("queuePrintJob"));
        permissionCollection.add(new SocketPermission("*", "connect"));
        permissionCollection.add(new SocketPermission("localhost:1024-", "accept,listen"));
        permissionCollection.add(new FilePermission("*", "read,write"));
        permissionCollection.add(new PropertyPermission("*", "read"));
    }

    private void addSandboxPermissionsObject(PermissionCollection permissionCollection, boolean bl) {
        Trace.println((String)"Add sandbox permissions", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new PropertyPermission("java.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor.url", "read"));
        permissionCollection.add(new PropertyPermission("java.class.version", "read"));
        permissionCollection.add(new PropertyPermission("os.name", "read"));
        permissionCollection.add(new PropertyPermission("os.arch", "read"));
        permissionCollection.add(new PropertyPermission("os.version", "read"));
        permissionCollection.add(new PropertyPermission("file.separator", "read"));
        permissionCollection.add(new PropertyPermission("path.separator", "read"));
        permissionCollection.add(new PropertyPermission("line.separator", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.name", "read"));
        permissionCollection.add(new PropertyPermission("javawebstart.version", "read"));
        if (JNLPClassLoaderUtil.getInstance() instanceof JNLPClassLoader) {
            permissionCollection.add(new RuntimePermission("exitVM"));
            permissionCollection.add(new RuntimePermission("stopThread"));
        }
        String string = "Java " + (bl ? "Applet" : "Application") + " Window";
        if (Config.getBooleanProperty((String)"deployment.security.sandbox.awtwarningwindow")) {
            System.setProperty("awt.appletWarning", string);
        } else {
            permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        permissionCollection.add(new SocketPermission("localhost:1024-", "listen"));
        Cache.updateHostIPFile((String)this._host);
        permissionCollection.add(new SocketPermission(this._host, "connect, accept"));
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javapi.*", "read,write"));
        String[] stringArray = Config.getSecureProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            permissionCollection.add(new PropertyPermission(stringArray[i], "read,write"));
        }
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 != null && stringArray2.length == 2) {
            if (stringArray2[0].equals("-open")) {
                permissionCollection.add(new FilePermission(stringArray2[1], "read, write"));
            } else if (stringArray2[0].equals("-print")) {
                permissionCollection.add(new FilePermission(stringArray2[1], "read, write"));
                permissionCollection.add(new RuntimePermission("queuePrintJob"));
            }
        }
    }
}

