/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.wizards.RelationshipDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportUtils {
    private static final String SEP_DOT = ".";
    static final List<RelationshipDescription> EMPTY_RELATIONSHIPS = Collections.emptyList();

    private ExportUtils() {
    }

    public static String getNumberingText(ITopic topic, ITopic centralTopic) {
        if (topic == null || topic.equals(centralTopic) || centralTopic == null && topic.isRoot()) {
            return null;
        }
        String number = ExportUtils.getNumber(topic);
        if (number == null) {
            return null;
        }
        ITopic parent = topic.getParent();
        if (parent == null) {
            return String.valueOf(number) + SEP_DOT;
        }
        String parentText = ExportUtils.getNumberingText(parent, centralTopic);
        if (parentText == null) {
            return String.valueOf(number) + SEP_DOT;
        }
        if (parentText.endsWith(SEP_DOT)) {
            return String.valueOf(parentText) + number;
        }
        return String.valueOf(parentText) + SEP_DOT + number;
    }

    private static String getNumber(ITopic topic) {
        if (topic.isRoot()) {
            return null;
        }
        int index = topic.getIndex() + 1;
        String type = topic.getType();
        if ("detached".equals(type)) {
            return NLS.bind((String)WizardMessages.Export_Appendix_format, (Object)index);
        }
        if ("summary".equals(type)) {
            return NLS.bind((String)WizardMessages.Export_Summary_format, (Object)index);
        }
        return String.valueOf(index);
    }

    public static List<RelationshipDescription> getRelationships(ITopic topic, List<IRelationship> relationships) {
        String topicId = topic.getId();
        ArrayList<RelationshipDescription> list = null;
        for (IRelationship r : relationships) {
            IRelationshipEnd otherEnd;
            boolean isEnd1 = topicId.equals(r.getEnd1Id());
            if (!isEnd1 && !topicId.equals(r.getEnd2Id())) continue;
            IRelationshipEnd iRelationshipEnd = otherEnd = isEnd1 ? r.getEnd2() : r.getEnd1();
            if (!(otherEnd instanceof ITopic)) continue;
            String title = ((ITopic)otherEnd).getTitleText();
            if (r.hasTitle()) {
                title = NLS.bind((String)"{0} ({1})", (Object)title, (Object)r.getTitleText());
            }
            if (list == null) {
                list = new ArrayList<RelationshipDescription>();
            }
            list.add(new RelationshipDescription(r, (IRelationshipEnd)topic, otherEnd, title));
        }
        return list == null ? EMPTY_RELATIONSHIPS : list;
    }
}

