/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.commands.AddSheetCommand;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.StreamInterruptedException;
import org.xmind.ui.util.Logger;
import org.xmind.ui.wizards.MindMapImporter;

public abstract class AbstractMindMapImportWizard
extends Wizard
implements IImportWizard {
    protected static final String KEY_IMPORT_TARGET = "IMPORT_TARGET";
    protected static final String TARGET_CURRENT_WORKBOOK = "currentWorkbook";
    protected static final String TARGET_NEW_WORKBOOK = "newWorkbook";
    private IWorkbench workbench;
    private IGraphicalEditor targetEditor;
    private IWorkbook targetWorkbook;
    private String sourcePath;

    public AbstractMindMapImportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        IEditorPart activeEditor = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor) {
            this.targetEditor = (IGraphicalEditor)activeEditor;
            this.targetWorkbook = (IWorkbook)activeEditor.getAdapter(IWorkbook.class);
        } else {
            this.targetEditor = null;
            this.targetWorkbook = null;
        }
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IGraphicalEditor getTargetEditor() {
        return this.targetEditor;
    }

    public IWorkbook getTargetWorkbook() {
        return this.targetWorkbook;
    }

    public boolean hasTargetWorkbook() {
        return this.targetWorkbook != null;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public boolean isToNewWorkbook() {
        if (!this.hasTargetWorkbook() || this.getDialogSettings() == null) {
            return true;
        }
        String target = this.getDialogSettings().get(KEY_IMPORT_TARGET);
        return target == null || TARGET_NEW_WORKBOOK.equals(target);
    }

    public void setToNewWorkbook(boolean newWorkbook) {
        if (this.getDialogSettings() != null) {
            if (newWorkbook) {
                this.getDialogSettings().put(KEY_IMPORT_TARGET, TARGET_NEW_WORKBOOK);
            } else {
                this.getDialogSettings().put(KEY_IMPORT_TARGET, TARGET_CURRENT_WORKBOOK);
            }
        }
    }

    public boolean hasSourcePath() {
        return this.sourcePath != null && !"".equals(this.sourcePath) && new File(this.sourcePath).exists() && new File(this.sourcePath).canRead();
    }

    public boolean performFinish() {
        if (!this.hasSourcePath()) {
            return false;
        }
        return this.doImport();
    }

    protected boolean doImport() {
        IWorkbook target = this.isToNewWorkbook() ? null : this.getTargetWorkbook();
        final MindMapImporter importer = this.createImporter(this.getSourcePath(), target);
        final Display display = this.workbench.getDisplay();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(null, 100);
                    importer.setMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 99));
                    importer.build();
                    if (AbstractMindMapImportWizard.this.isToNewWorkbook()) {
                        monitor.subTask(WizardMessages.Import_OpeningWorkbook);
                        IWorkbook workbook = importer.getTargetWorkbook();
                        if (workbook == null) {
                            return;
                        }
                        final IEditorInput input = MME.createLoadedEditorInput(workbook);
                        final Throwable[] exception = new Throwable[1];
                        display.syncExec(new Runnable(){

                            public void run() {
                                try {
                                    AbstractMindMapImportWizard.this.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
                                }
                                catch (Throwable e) {
                                    exception[0] = e;
                                }
                            }
                        });
                        if (exception[0] != null) {
                            throw new InvocationTargetException(exception[0]);
                        }
                    } else {
                        monitor.subTask(WizardMessages.Import_AppendingSheet);
                        final List<ISheet> targetSheets = importer.getTargetSheets();
                        if (targetSheets.isEmpty()) {
                            return;
                        }
                        final ICommandStack commandStack = AbstractMindMapImportWizard.this.getTargetEditor().getCommandStack();
                        if (commandStack == null) {
                            return;
                        }
                        final Throwable[] exception = new Throwable[1];
                        display.syncExec(new Runnable(){

                            public void run() {
                                try {
                                    ArrayList<AddSheetCommand> commands = new ArrayList<AddSheetCommand>(targetSheets.size());
                                    for (ISheet sheet : targetSheets) {
                                        AddSheetCommand command = new AddSheetCommand(sheet, AbstractMindMapImportWizard.this.getTargetWorkbook());
                                        commands.add(command);
                                    }
                                    String label = NLS.bind((String)WizardMessages.Command_ImportFrom, (Object)new File(AbstractMindMapImportWizard.this.getSourcePath()).getName());
                                    commandStack.execute((Command)new CompoundCommand(label, commands));
                                }
                                catch (Throwable e) {
                                    exception[0] = e;
                                }
                            }
                        });
                        if (exception[0] != null) {
                            throw new InvocationTargetException(exception[0]);
                        }
                    }
                    monitor.done();
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException || e instanceof StreamInterruptedException) {
                return false;
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getCause();
            }
            this.handleExportException(e);
        }
        finally {
            importer.dispose();
        }
        return false;
    }

    protected abstract MindMapImporter createImporter(String var1, IWorkbook var2);

    protected void handleExportException(Throwable e) {
        Logger.log(e, NLS.bind((String)WizardMessages.Import_FailedWhenImport, (Object)this.getApplicationId()));
    }

    protected abstract String getApplicationId();
}

