/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.wizards.WizardMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExportWizard
extends Wizard
implements IExportWizard {
    protected static final String KEY_PATH_HISTORY = "PATH_HISTORY";
    protected static final String FILTER_ALL_FILES = "*.*";
    private String targetPath;
    private boolean overwriteWithoutPrompt = false;
    private List<String> pathHistory = new ArrayList<String>();
    private List<String> temporaryPaths = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.loadDialogSettings();
    }

    protected void loadDialogSettings() {
        if (this.getDialogSettings() != null) {
            this.loadDialogSettings(this.getDialogSettings());
        }
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        String history = settings.get(KEY_PATH_HISTORY);
        if (history != null && !"".equals(history)) {
            String[] paths;
            String[] stringArray = paths = history.split("\\|");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (!"".equals(path)) {
                    this.pathHistory.add(path);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        this.saveDialogSettings();
        super.dispose();
        this.deleteTemporaryPaths();
    }

    protected void saveDialogSettings() {
        if (this.getDialogSettings() != null) {
            this.saveDialogSettings(this.getDialogSettings());
        }
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        if (this.targetPath != null) {
            if (!this.pathHistory.contains(this.targetPath)) {
                this.pathHistory.add(this.targetPath);
            }
            StringBuilder sb = new StringBuilder(this.pathHistory.size() * 20);
            for (String path : this.pathHistory) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(path);
            }
            settings.put(KEY_PATH_HISTORY, sb.toString());
            this.targetPath = null;
        }
    }

    protected abstract boolean hasSource();

    public boolean canFinish() {
        return super.canFinish() && this.hasSource() && this.hasTargetPath();
    }

    protected void launchTargetFile(boolean fileOrDirectory, IProgressMonitor monitor, Display display, Shell parentShell) {
        if (new File(this.getTargetPath()).exists()) {
            monitor.subTask(WizardMessages.ExportPage_Launching);
            Program.launch((String)this.getTargetPath());
        }
    }

    protected String requestTemporaryPath(String applicationName, String fileNameExtension, boolean fileOrDirectory) {
        String tempDir = Core.getWorkspace().getTempDir();
        File mainDir = FileUtils.ensureDirectory((File)new File(tempDir, "export"));
        StringBuilder sb = new StringBuilder(26 + (applicationName == null ? 0 : applicationName.length() + 1) + (fileNameExtension == null ? 4 : fileNameExtension.length() + 1));
        if (applicationName != null) {
            sb.append(applicationName);
            sb.append('_');
        }
        sb.append(Core.getIdFactory().createId());
        if (fileNameExtension == null) {
            sb.append(".tmp");
        } else {
            if (fileNameExtension.charAt(0) != '.') {
                sb.append('.');
            }
            sb.append(fileNameExtension);
        }
        String name = sb.toString();
        File file = new File(mainDir, name);
        if (!fileOrDirectory) {
            FileUtils.ensureDirectory((File)file);
        }
        String result = file.getAbsolutePath();
        if (this.temporaryPaths == null) {
            this.temporaryPaths = new ArrayList<String>(3);
        }
        this.temporaryPaths.add(result);
        return result;
    }

    protected void deleteTemporaryPath(String path) {
        if (FileUtils.delete((File)new File(path)) && this.temporaryPaths != null) {
            this.temporaryPaths.remove(path);
            if (this.temporaryPaths.isEmpty()) {
                this.temporaryPaths = null;
            }
        }
    }

    protected void deleteTemporaryPaths() {
        if (this.temporaryPaths != null) {
            Object[] objectArray = this.temporaryPaths.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.deleteTemporaryPath((String)o);
                ++n2;
            }
        }
    }

    protected String cleanFileName(String name) {
        if (name == null) {
            return "";
        }
        return name.replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public void setTargetPath(String path) {
        this.targetPath = path;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean hasTargetPath() {
        return this.targetPath != null && !"".equals(this.targetPath);
    }

    public List<String> getPathHistory() {
        return this.pathHistory;
    }

    public void setOverwriteWithoutPrompt(boolean overwriteWithoutPrompt) {
        this.overwriteWithoutPrompt = overwriteWithoutPrompt;
    }

    public boolean isOverwriteWithoutPrompt() {
        return this.overwriteWithoutPrompt;
    }
}

