/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private CollectionUtils() {
    }

    public static final <T> Collection<T> filtered(Collection<T> c, IFilter filter) {
        return new FilteredCollection<T>(c, filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FilteredCollection<E>
    extends AbstractCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 359553173125286125L;
        private IFilter filter;
        private Collection<E> c;
        private Collection<E> remainders;

        public FilteredCollection(Collection<E> c, IFilter filter) {
            this.c = c;
            this.filter = filter;
            this.refilter();
        }

        private void refilter() {
            this.remainders = null;
            try {
                Class<?> collectionClass = this.c.getClass();
                this.remainders = (Collection)collectionClass.newInstance();
            }
            catch (Throwable throwable) {}
            if (this.remainders == null) {
                this.remainders = new ArrayList();
            }
            for (E e : this.c) {
                if (this.isFilteredOut(e)) continue;
                this.remainders.add(e);
            }
        }

        private boolean isFilteredOut(Object e) {
            return this.filter != null && !this.filter.select(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.remainders.iterator();
        }

        @Override
        public int size() {
            return this.remainders.size();
        }

        @Override
        public boolean add(E e) {
            boolean added = this.c.add(e);
            if (added) {
                this.refilter();
            }
            return added;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = this.c.remove(o);
            if (removed) {
                this.refilter();
            }
            return removed;
        }

        @Override
        public int hashCode() {
            return this.remainders.hashCode();
        }

        @Override
        public String toString() {
            return this.remainders.toString();
        }

        @Override
        public boolean equals(Object obj) {
            return this.remainders.equals(obj);
        }
    }
}

