/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.style;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class TextStyleData {
    public String name;
    public int height;
    public boolean bold;
    public boolean italic;
    public RGB color;
    public boolean underline;
    public boolean strikeout;
    public int align;

    public TextStyleData() {
        this(JFaceResources.getDefaultFont().getFontData()[0]);
    }

    public TextStyleData(FontData fd) {
        this.name = fd.getName();
        this.height = fd.getHeight();
        this.bold = (fd.getStyle() & 1) != 0;
        this.italic = (fd.getStyle() & 2) != 0;
        this.color = new RGB(0, 0, 0);
        this.underline = false;
        this.strikeout = false;
        this.align = 1;
    }

    public TextStyleData(TextStyleData data) {
        this.name = data.name;
        this.height = data.height;
        this.bold = data.bold;
        this.italic = data.italic;
        this.color = data.color;
        this.underline = data.underline;
        this.strikeout = data.strikeout;
        this.align = data.align;
    }

    public FontData createFontData() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        }
        if (this.italic) {
            style |= 2;
        }
        return new FontData(this.name, this.height, style);
    }

    public Font createFont() {
        return FontUtils.getFont((FontData)this.createFontData());
    }

    public TextStyle createTextStyle() {
        TextStyle textStyle = new TextStyle(this.createFont(), ColorUtils.getColor((RGB)this.color), null);
        textStyle.underline = this.underline;
        textStyle.strikeout = this.strikeout;
        return textStyle;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TextStyleData)) {
            return false;
        }
        TextStyleData that = (TextStyleData)obj;
        return (this.name == that.name || this.name != null && this.name.equals(that.name)) && this.height == that.height && this.bold == that.bold && this.italic == that.italic && (this.color == that.color || this.color != null && this.color.equals((Object)that.color)) && this.underline == that.underline && this.strikeout == that.strikeout && this.align == that.align;
    }

    public int hashCode() {
        int c = this.height;
        if (this.bold) {
            c ^= 1;
        }
        if (this.italic) {
            c ^= 2;
        }
        if (this.underline) {
            c ^= 4;
        }
        if (this.strikeout) {
            c ^= 8;
        }
        if (this.name != null) {
            c ^= this.name.hashCode();
        }
        if (this.color != null) {
            c ^= this.color.hashCode();
        }
        return c ^= this.align;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("{name=");
        sb.append(this.name);
        sb.append(",height=");
        sb.append(this.height);
        sb.append(",color=");
        sb.append(this.color);
        sb.append(",");
        if (this.bold) {
            sb.append("bold");
        }
        if (this.italic) {
            sb.append("italic");
        }
        if (this.underline) {
            sb.append("underline");
        }
        if (this.strikeout) {
            sb.append("strikeout");
        }
        sb.append(",align=");
        sb.append(this.align);
        sb.append("}");
        return sb.toString();
    }
}

