/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.style;

import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.gef.IViewer;
import org.xmind.gef.graphicalpolicy.AbstractStyleSelector;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapStyleSelectorBase
extends AbstractStyleSelector {
    protected static final String FAMILY_UNKNOWN = "unknown";

    public String getAutoValue(IGraphicalPart part, String key, IStyleValueProvider defaultValueProvider) {
        String familyName = this.getFamilyName(part);
        if (familyName == null) {
            return null;
        }
        return this.getAutoValueByFamilyName(part, familyName, key, defaultValueProvider);
    }

    protected String getAutoValueByFamilyName(IGraphicalPart part, String familyName, String key, IStyleValueProvider defaultValueProvider) {
        String value = null;
        if (defaultValueProvider != null && (this.isValidValue(part, key, value = defaultValueProvider.getValue(part, key)) || defaultValueProvider.isKeyInteresting(part, key))) {
            return value;
        }
        value = this.getThemeStyleValue(part, familyName, key);
        if (this.isValidValue(part, key, value)) {
            return value;
        }
        value = this.getDefaultStyleValue(part, familyName, key, defaultValueProvider);
        if (this.isValidValue(part, key, value)) {
            return value;
        }
        return value;
    }

    protected String getDefaultStyleValue(IGraphicalPart part, String familyName, String key, IStyleValueProvider defaultValueProvider) {
        String value;
        IStyle defaultStyle = this.getDefaultStyle(part, familyName);
        if (defaultStyle != null && this.isValidValue(part, key, value = defaultStyle.getProperty(key))) {
            return value;
        }
        return null;
    }

    protected String getThemeStyleValue(IGraphicalPart part, String familyName, String key) {
        String value;
        IStyle themeStyle = this.getThemeStyle(part, familyName);
        if (themeStyle != null && this.isValidValue(part, key, value = themeStyle.getProperty(key))) {
            return value;
        }
        return null;
    }

    protected IStyle getDefaultStyle(IGraphicalPart part, String familyName) {
        return MindMapUI.getResourceManager().getDefaultStyleSheet().findStyle(familyName);
    }

    private IStyle getThemeStyle(IGraphicalPart part, String familyName) {
        IStyle theme;
        ISheet sheet = this.getSheet(part);
        if (sheet != null && (theme = sheet.getTheme()) != null) {
            return theme.getDefaultStyle(familyName);
        }
        return null;
    }

    protected ISheet getSheet(IGraphicalPart part) {
        ISheet sheet = (ISheet)part.getAdapter(ISheet.class);
        if (sheet != null) {
            return sheet;
        }
        Object model = MindMapUtils.getRealModel((IPart)part);
        if (model instanceof ISheet) {
            return sheet;
        }
        ISheetComponent sheetComponent = this.getSheetComponent(part);
        if (sheetComponent != null && (sheet = sheetComponent.getOwnedSheet()) != null) {
            return sheet;
        }
        IViewer viewer = part.getSite().getViewer();
        if (viewer != null) {
            sheet = (ISheet)viewer.getAdapter(ISheet.class);
        }
        return sheet;
    }

    protected ISheetComponent getSheetComponent(IGraphicalPart part) {
        ISheetComponent sc = (ISheetComponent)part.getAdapter(ISheetComponent.class);
        if (sc != null) {
            return sc;
        }
        Object model = MindMapUtils.getRealModel((IPart)part);
        if (model instanceof ISheetComponent) {
            return (ISheetComponent)model;
        }
        return null;
    }

    public String getUserValue(IGraphicalPart part, String key) {
        IStyle style = this.getStyle(part);
        return style == null ? null : style.getProperty(key);
    }

    protected IStyle getStyle(IGraphicalPart part) {
        IStyleSheet ss;
        String styleId;
        IStyled styleOwner = this.getStyleOwner(part);
        if (styleOwner != null && (styleId = styleOwner.getStyleId()) != null && styleOwner instanceof IWorkbookComponent && (ss = ((IWorkbookComponent)styleOwner).getOwnedWorkbook().getStyleSheet()) != null) {
            return ss.findStyle(styleId);
        }
        return null;
    }

    protected IStyled getStyleOwner(IGraphicalPart part) {
        IStyled styleOwner = (IStyled)part.getAdapter(IStyled.class);
        if (styleOwner != null) {
            return styleOwner;
        }
        Object model = MindMapUtils.getRealModel((IPart)part);
        if (model instanceof IStyled) {
            return (IStyled)model;
        }
        return null;
    }

    protected IWorkbook getOwnedWorkbook(IGraphicalPart part, IStyled styleOwner) {
        ISheet sheet;
        IWorkbook workbook;
        if (styleOwner instanceof IWorkbookComponent && (workbook = ((IWorkbookComponent)styleOwner).getOwnedWorkbook()) != null) {
            return workbook;
        }
        workbook = (IWorkbook)part.getAdapter(IWorkbook.class);
        if (workbook != null) {
            return workbook;
        }
        IViewer viewer = part.getSite().getViewer();
        if (viewer != null && (sheet = (ISheet)viewer.getAdapter(ISheet.class)) != null) {
            return sheet.getOwnedWorkbook();
        }
        return null;
    }

    public abstract String getFamilyName(IGraphicalPart var1);
}

