/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.RGB;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.style.IStyled;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;

public abstract class StyledPropertySectionPart
extends MindMapPropertySectionPartBase {
    protected String getStyleValue(String styleKey, String decorationId) {
        String value = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            IStyleValueProvider defaultValueProvider = StyleUtils.getDecorationDefaultValueProvider(decorationId, styleKey);
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IGraphicalPart part = this.getGraphicalPart(o, (IViewer)viewer);
                if (part != null) {
                    IStyleSelector ss = this.getStyleSelector(part);
                    String v = ss.getStyleValue(part, styleKey, defaultValueProvider);
                    if (v == null) {
                        return null;
                    }
                    if (value == null) {
                        value = v;
                    } else if (!value.equals(v)) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return value;
    }

    protected String getAutoValue(String styleKey, String decorationId) {
        String value = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            IStyleValueProvider defaultValueProvider = StyleUtils.getDecorationDefaultValueProvider(decorationId, styleKey);
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IGraphicalPart part = this.getGraphicalPart(o, (IViewer)viewer);
                if (part != null) {
                    IStyleSelector ss = this.getStyleSelector(part);
                    String v = ss.getAutoValue(part, styleKey, defaultValueProvider);
                    if (v == null) {
                        return null;
                    }
                    if (value == null) {
                        value = v;
                    } else if (!value.equals(v)) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return value;
    }

    protected String getUserValue(String styleKey) {
        String value = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IGraphicalPart part = this.getGraphicalPart(o, (IViewer)viewer);
                if (part != null) {
                    IStyleSelector ss = this.getStyleSelector(part);
                    String v = ss.getUserValue(part, styleKey);
                    if (v == null) {
                        return null;
                    }
                    if (value == null) {
                        value = v;
                    } else if (!value.equals(v)) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return value;
    }

    protected void updateColorPicker(ColorPicker picker, String styleKey, String decorationId) {
        int type;
        String autoColor = this.getAutoValue(styleKey, decorationId);
        picker.setAutoColor(StyleUtils.convertRGB(styleKey, autoColor));
        String userColor = this.getUserValue(styleKey);
        if (userColor == null) {
            type = 1;
            userColor = autoColor;
        } else {
            type = 3;
        }
        if (type != 1 && "none".equals(userColor)) {
            type = 2;
        }
        RGB color = StyleUtils.convertRGB("fo:color", userColor);
        picker.setSelection((ISelection)new ColorSelection(type, color));
    }

    protected void changeColor(IColorSelection selection, String styleKey, String commandLabel) {
        String color = selection.isAutomatic() ? null : (selection.isNone() ? "none" : ColorUtils.toString((RGB)selection.getColor()));
        Request request = this.createStyleRequest(commandLabel);
        this.addStyle(request, styleKey, color);
        this.sendRequest(request);
    }

    protected boolean isPropertyModifiable(String propertyKey, String secondaryKey) {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer == null) {
            return false;
        }
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IPart part = viewer.findPart(o);
            if (part == null || !(part instanceof ITopicPart)) {
                return false;
            }
            IBranchPart branch = ((ITopicPart)part).getOwnerBranch();
            if (branch == null) {
                return false;
            }
            if (!branch.getBranchPolicy().isPropertyModifiable(branch, propertyKey, secondaryKey)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void registerEventListener(ICoreEventSource source, ICoreEventRegister register) {
        if (source instanceof IStyled) {
            register.register("style");
        }
    }

    protected Request createStyleRequest(String commandLabel) {
        return this.fillTargets(new Request("modify style")).setParameter("commandLabel", (Object)commandLabel);
    }

    protected Request addStyle(Request request, String styleKey, String value) {
        return request.setParameter("styleProperty." + styleKey, (Object)value);
    }
}

