/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.WorkbookFactory;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.MindMapUI;

public class NewWorkbookWizard
extends Wizard
implements INewWizard {
    private static final String PAGE_NAME = "org.xmind.ui.newWizardPage";
    private static final String SECTION_NAME = "org.xmind.ui.newWizard";
    private static final String LAST_FOLDER = "lastSelectedFolder";
    private NewWizardPage page;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public NewWorkbookWizard() {
        this.setWindowTitle(WizardMessages.NewWizard_windowTitle);
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(SECTION_NAME));
    }

    public void dispose() {
        String path = this.page.getParentPath();
        if (path != null) {
            this.getDialogSettings().put(LAST_FOLDER, path);
        }
        super.dispose();
    }

    public void addPages() {
        IProduct product = Platform.getProduct();
        IStructuredSelection initSelection = this.selection;
        if (product == null || "org.xmind.cathy.application".equals(product.getApplication())) {
            this.page = new NewWorkbookInFileSystemPage();
            this.addPage((IWizardPage)this.page);
            String lastFolder = this.getDialogSettings().get(LAST_FOLDER);
            if (lastFolder != null && !"".equals(lastFolder)) {
                initSelection = new StructuredSelection((Object)new File(lastFolder));
            }
        } else {
            this.page = new NewWorkbookInWorkspacePage();
            this.addPage((IWizardPage)this.page);
        }
        this.page.setWorkbenchSelection(initSelection);
    }

    public boolean performFinish() {
        if (this.workbench == null) {
            return false;
        }
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        final IWorkbenchPage workbenchPage = window.getActivePage();
        if (workbenchPage == null) {
            return false;
        }
        final IEditorPart[] editor = new IEditorPart[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IEditorInput editorInput = NewWorkbookWizard.this.page.createEditorInput();
                if (editorInput == null) {
                    return;
                }
                editor[0] = workbenchPage.openEditor(editorInput, "org.xmind.ui.MindMapEditor");
            }
        });
        return editor[0] != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    private static abstract class NewWizardPage
    extends WizardPage {
        private Text fileNameText;
        private String fileName;

        protected NewWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        protected NewWizardPage(String pageName) {
            super(pageName);
        }

        public abstract void setWorkbenchSelection(IStructuredSelection var1);

        public abstract IEditorInput createEditorInput() throws CoreException;

        public abstract String getParentPath();

        protected void createFileNameControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(WizardMessages.NewPage_FileName_label);
            this.fileNameText = new Text(composite, 2052);
            this.fileNameText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    NewWizardPage.this.fileName = NewWizardPage.this.fileNameText.getText();
                    NewWizardPage.this.validFileName();
                    NewWizardPage.this.updateButtonStates();
                }
            });
            this.fileNameText.setLayoutData((Object)new GridData(4, 4, true, false));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!NewWizardPage.this.fileNameText.isDisposed()) {
                        NewWizardPage.this.fileNameText.setFocus();
                    }
                }
            });
        }

        private void validFileName() {
            String fileName = this.fileNameText.getText();
            if (!fileName.endsWith(".xmind")) {
                this.setMessage(WizardMessages.NewPage_InvalidExtension_message, 2);
            } else {
                this.setMessage(null, 2);
            }
        }

        protected void updateButtonStates() {
            this.setPageComplete(this.isPageCompletable());
        }

        protected boolean isPageCompletable() {
            return this.fileName != null && !"".equals(this.fileName);
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    private static class NewWorkbookInFileSystemPage
    extends NewWizardPage {
        private File selectedFolder;
        private TreeViewer folderViewer;

        public NewWorkbookInFileSystemPage() {
            super(NewWorkbookWizard.PAGE_NAME, WizardMessages.NewPage_title, null);
            this.setDescription(WizardMessages.NewPage2_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            this.setControl((Control)composite);
            this.createFolderViewer(composite);
            this.createFileNameControl(composite);
            this.updateButtonStates();
        }

        private void createFolderViewer(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(WizardMessages.NewPage_SelectParent_label);
            this.folderViewer = new TreeViewer(parent, 2052);
            this.folderViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.folderViewer.setContentProvider((IContentProvider)new FolderContentProvider());
            this.folderViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
            this.folderViewer.setComparator(new ViewerComparator());
            this.folderViewer.setUseHashlookup(true);
            this.folderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    NewWorkbookInFileSystemPage.this.folderSelectionChanged((File)selection.getFirstElement());
                }
            });
            this.folderViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)selection).getFirstElement();
                        if (item == null) {
                            return;
                        }
                        if (NewWorkbookInFileSystemPage.this.folderViewer.getExpandedState(item)) {
                            NewWorkbookInFileSystemPage.this.folderViewer.collapseToLevel(item, 1);
                        } else {
                            NewWorkbookInFileSystemPage.this.folderViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NewWorkbookInFileSystemPage.this.folderViewer.setInput((Object)File.listRoots());
                    File homeDir = new File(System.getProperty("user.home"));
                    NewWorkbookInFileSystemPage.this.folderViewer.setSelection((ISelection)new StructuredSelection((Object)homeDir), true);
                    NewWorkbookInFileSystemPage.this.folderViewer.setExpandedState((Object)homeDir, true);
                    NewWorkbookInFileSystemPage.this.updateButtonStates();
                }
            });
        }

        private void folderSelectionChanged(File folder) {
            this.selectedFolder = folder;
            this.updateButtonStates();
        }

        protected boolean isPageCompletable() {
            return super.isPageCompletable() && this.selectedFolder != null;
        }

        public IEditorInput createEditorInput() throws CoreException {
            if (this.selectedFolder == null) {
                return null;
            }
            String name = this.getFileName();
            if (!name.endsWith(".xmind")) {
                name = String.valueOf(name) + ".xmind";
            }
            File file = new File(this.selectedFolder, name);
            FileUtils.ensureFileParent((File)file);
            IWorkbook workbook = WorkbookFactory.createEmptyWorkbook();
            try {
                workbook.save((OutputStream)new FileOutputStream(file));
            }
            catch (Exception exception) {}
            return MME.createFileEditorInput(file);
        }

        public void setWorkbenchSelection(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element instanceof File) {
                this.folderSelectionChanged((File)element);
            }
        }

        public String getParentPath() {
            return this.selectedFolder == null ? null : this.selectedFolder.getAbsolutePath();
        }

        private static class FolderContentProvider
        implements ITreeContentProvider {
            private Object input;

            private FolderContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof File) {
                    File[] subFiles;
                    File parent = (File)parentElement;
                    if (parent.isDirectory() && (subFiles = parent.listFiles()) != null) {
                        ArrayList<File> list = new ArrayList<File>(subFiles.length);
                        File[] fileArray = subFiles;
                        int n = subFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            if (child.isDirectory() && !child.isHidden() && child.canRead()) {
                                list.add(child);
                            }
                            ++n2;
                        }
                        return list.toArray();
                    }
                } else if (parentElement instanceof File[]) {
                    return (File[])parentElement;
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof File) {
                    File parent = ((File)element).getParentFile();
                    if (parent == null) {
                        return this.input;
                    }
                    return parent;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return true;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.input = newInput;
            }
        }

        private static class FolderLabelProvider
        extends LabelProvider {
            private Image folderImage;

            private FolderLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof File) {
                    File file = (File)element;
                    if (file.getParentFile() == null) {
                        return file.getAbsolutePath();
                    }
                    return file.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (this.folderImage == null) {
                    this.folderImage = MindMapUI.getImages().get("fldr_obj.gif", true).createImage(false);
                }
                return this.folderImage;
            }

            public void dispose() {
                if (this.folderImage != null) {
                    this.folderImage.dispose();
                    this.folderImage = null;
                }
                super.dispose();
            }
        }
    }

    private static class NewWorkbookInWorkspacePage
    extends NewWizardPage {
        private TreeViewer containerViewer;
        private IContainer selectedContainer;

        public NewWorkbookInWorkspacePage() {
            super(NewWorkbookWizard.PAGE_NAME, WizardMessages.NewPage_title, null);
            this.setDescription(WizardMessages.NewPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 5;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            this.setControl((Control)composite);
            this.createContainerViewer(composite);
            this.createFileNameControl(composite);
            this.updateButtonStates();
        }

        private void createContainerViewer(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(WizardMessages.NewPage_SelectParent_label);
            this.containerViewer = new TreeViewer(parent, 2052);
            this.containerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.containerViewer.setContentProvider((IContentProvider)new ContainerContentProvider());
            this.containerViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
            this.containerViewer.setComparator(new ViewerComparator());
            this.containerViewer.setUseHashlookup(true);
            this.containerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    NewWorkbookInWorkspacePage.this.containerSelectionChanged((IContainer)selection.getFirstElement());
                }
            });
            this.containerViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)selection).getFirstElement();
                        if (item == null) {
                            return;
                        }
                        if (NewWorkbookInWorkspacePage.this.containerViewer.getExpandedState(item)) {
                            NewWorkbookInWorkspacePage.this.containerViewer.collapseToLevel(item, 1);
                        } else {
                            NewWorkbookInWorkspacePage.this.containerViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NewWorkbookInWorkspacePage.this.containerViewer.setInput((Object)ResourcesPlugin.getWorkspace());
                    if (NewWorkbookInWorkspacePage.this.selectedContainer != null) {
                        NewWorkbookInWorkspacePage.this.containerViewer.setSelection((ISelection)new StructuredSelection((Object)NewWorkbookInWorkspacePage.this.selectedContainer), true);
                    }
                    NewWorkbookInWorkspacePage.this.updateButtonStates();
                }
            });
        }

        public void containerSelectionChanged(IContainer container) {
            this.selectedContainer = container;
            this.updateButtonStates();
        }

        protected boolean isPageCompletable() {
            return super.isPageCompletable() && this.selectedContainer != null;
        }

        public void setWorkbenchSelection(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element instanceof IContainer) {
                this.containerSelectionChanged((IContainer)element);
            } else if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource instanceof IContainer) {
                    this.containerSelectionChanged((IContainer)resource);
                } else if (resource != null) {
                    this.containerSelectionChanged(resource.getParent());
                }
            }
        }

        public IEditorInput createEditorInput() throws CoreException {
            if (this.selectedContainer != null) {
                String name = this.getFileName();
                if (!name.endsWith(".xmind")) {
                    name = String.valueOf(name) + ".xmind";
                }
                IPath fullPath = this.selectedContainer.getFullPath().append(name);
                IFile file = this.createFile(fullPath);
                return MME.createFileEditorInput(file);
            }
            return null;
        }

        private IFile createFile(IPath fullPath) {
            IFile file = this.selectedContainer.getWorkspace().getRoot().getFile(fullPath);
            try {
                file.create(WorkbookFactory.createEmptyWorkbookStream(), false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            return file;
        }

        public String getParentPath() {
            return null;
        }

        private static class ContainerContentProvider
        implements ITreeContentProvider {
            private ContainerContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                IContainer container;
                if (parentElement instanceof IWorkspace) {
                    Object[] allProjects = ((IWorkspace)parentElement).getRoot().getProjects();
                    return allProjects;
                }
                if (parentElement instanceof IContainer && (container = (IContainer)parentElement).isAccessible()) {
                    try {
                        ArrayList<IResource> children = new ArrayList<IResource>();
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            if (members[i].getType() != 1) {
                                children.add(members[i]);
                            }
                            ++i;
                        }
                        return children.toArray();
                    }
                    catch (CoreException coreException) {}
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

