/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IImage;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMindExporter {
    private static DocumentBuilder documentBuilder;
    private ISheet sheet;
    private String targetPath;
    private IProgressMonitor monitor;
    private Document document;
    private File imageDir = null;
    private Map<ITopic, EdgeData> edgeDataMap = null;
    private Map<String, String> markers = null;

    public FreeMindExporter(ISheet sheet, String targetPath) {
        this.sheet = sheet;
        this.targetPath = targetPath;
    }

    public ISheet getSheet() {
        return this.sheet;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void build() throws InvocationTargetException, InterruptedException {
        this.getMonitor().beginTask(null, 100);
        try {
            this.document = FreeMindExporter.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InvocationTargetException(e);
        }
        this.checkInterrupter();
        this.writeContent();
        try {
            FileOutputStream os = new FileOutputStream(new File(this.targetPath));
            DOMUtils.save((Node)this.document, (OutputStream)os, (boolean)true);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void writeContent() {
        Element mapEle = DOMUtils.createElement((Node)this.document, (String)"map");
        this.writeMap(mapEle);
        if (this.edgeDataMap != null) {
            this.edgeDataMap.clear();
        }
        if (this.markers != null) {
            this.markers.clear();
        }
    }

    private void writeMap(Element mapEle) {
        mapEle.setAttribute("version", "0.8.1");
        ITopic rootTopic = this.getSheet().getRootTopic();
        this.cacheMarkers();
        this.writeTopic(mapEle, rootTopic);
    }

    private void writeTopic(Element element, ITopic topic) {
        Element nodeEle = DOMUtils.createElement((Node)element, (String)"node");
        IStyle style = this.getStyle((IStyled)topic);
        this.writeColor(nodeEle, topic, style);
        this.writeCreateFolderAndId(nodeEle, topic);
        this.writeLink(nodeEle, topic);
        this.writeModify(nodeEle);
        this.writePosition(nodeEle, topic);
        this.writeTopicShapeStyle(nodeEle, style);
        this.writeImageOrText(nodeEle, topic);
        this.WriteVShift(nodeEle, topic);
        this.cacheEdge(topic, style);
        this.writeEdge(nodeEle, topic);
        this.writeArrowLink(nodeEle, topic);
        this.writeFont(nodeEle, style);
        this.writeIcon(nodeEle, topic);
        this.writehookNotes(nodeEle, topic);
        this.writSubTopics(nodeEle, topic);
    }

    private void writehookNotes(Element nodeEle, ITopic topic) {
        INotes notes = topic.getNotes();
        if (notes == null) {
            return;
        }
        INotesContent content = notes.getContent("html");
        if (content != null) {
            Element hookEle = DOMUtils.createElement((Node)nodeEle, (String)"hook");
            hookEle.setAttribute("NAME", "accessories/plugins/NodeNote.properties");
            Element notesEle = DOMUtils.createElement((Node)hookEle, (String)"text");
            IHtmlNotesContent html = (IHtmlNotesContent)content;
            List paragraphs = html.getParagraphs();
            String paraText = null;
            for (IParagraph paragraph : paragraphs) {
                List spans = paragraph.getSpans();
                String spanText = null;
                for (ISpan span : spans) {
                    if (!(span instanceof ITextSpan)) continue;
                    String text = ((ITextSpan)span).getTextContent();
                    spanText = spanText == null ? text : String.valueOf(spanText) + text;
                }
                paraText = paraText == null ? spanText : String.valueOf(paraText) + '\n' + spanText;
            }
            notesEle.setTextContent(paraText);
        }
    }

    private void writeIcon(Element nodeEle, ITopic topic) {
        Set markers = topic.getMarkerRefs();
        if (markers == null) {
            return;
        }
        for (IMarkerRef next : markers) {
            String icon = this.findTransferIcon(next);
            if (icon == null) continue;
            Element iconEle = DOMUtils.createElement((Node)nodeEle, (String)"icon");
            iconEle.setAttribute("BUILTIN", icon);
        }
    }

    private String findTransferIcon(IMarkerRef marker) {
        String markerId = marker.getMarkerId();
        if (markerId == null) {
            return null;
        }
        if (markerId.startsWith("flag")) {
            markerId = "flag";
        } else if (markerId.contains("star")) {
            markerId = "star";
        }
        String icon = this.markers.get(markerId);
        if (icon != null) {
            return icon;
        }
        return null;
    }

    private IStyle getStyle(IStyled styleOwner) {
        if (styleOwner != null) {
            String styleId = styleOwner.getStyleId();
            if (styleId == null) {
                return null;
            }
            IWorkbook workbook = this.getSheet().getOwnedWorkbook();
            IStyleSheet styleSheet = workbook.getStyleSheet();
            return styleSheet.findStyle(styleId);
        }
        return null;
    }

    private void cacheEdge(ITopic topic, IStyle style) {
        if (style == null) {
            return;
        }
        String lineColor = style.getProperty("line-color");
        String lineClass = style.getProperty("line-class");
        String lineWidth = style.getProperty("line-width");
        if (lineColor == null && lineClass == null && lineWidth == null) {
            return;
        }
        String edgeStyle = null;
        if (lineClass != null) {
            if (lineClass.endsWith("curve")) {
                edgeStyle = "bezier";
            } else if (lineClass.endsWith("straight")) {
                edgeStyle = "linear";
            }
        }
        String edgeWidth = null;
        if ("1pt".equals(lineWidth)) {
            edgeWidth = "thin";
        } else if ("2pt".equals(lineWidth)) {
            edgeWidth = "1";
        } else if ("3pt".equals(lineWidth)) {
            edgeWidth = "2";
        } else if ("4pt".equals(lineWidth)) {
            edgeWidth = "4";
        } else if ("5pt".equals(lineWidth)) {
            edgeWidth = "8";
        }
        if (this.edgeDataMap == null) {
            this.edgeDataMap = new HashMap<ITopic, EdgeData>();
        }
        EdgeData edgeData = new EdgeData(lineColor, edgeStyle, edgeWidth);
        this.edgeDataMap.put(topic, edgeData);
    }

    private void writeEdge(Element nodeEle, ITopic topic) {
        String edgeWidth;
        String edgeStyle;
        if (this.edgeDataMap == null) {
            return;
        }
        ITopic parent = topic.getParent();
        if (parent == null) {
            return;
        }
        EdgeData edgeData = this.edgeDataMap.get(parent);
        if (edgeData == null) {
            return;
        }
        Element edgeEle = DOMUtils.createElement((Node)nodeEle, (String)"edge");
        String edgeColor = edgeData.color;
        if (edgeColor != null) {
            edgeEle.setAttribute("COLOR", edgeColor);
        }
        if ((edgeStyle = edgeData.style) != null) {
            edgeEle.setAttribute("STYLE", edgeStyle);
        }
        if ((edgeWidth = edgeData.width) != null) {
            edgeEle.setAttribute("WIDTH", edgeWidth);
        }
    }

    private void writeColor(Element nodeEle, ITopic topic, IStyle style) {
        String color;
        if (style == null) {
            return;
        }
        String backgroundColor = style.getProperty("svg:fill");
        if (backgroundColor != null) {
            nodeEle.setAttribute("BACKGROUND_COLOR", backgroundColor);
        }
        if ((color = style.getProperty("fo:color")) != null) {
            nodeEle.setAttribute("COLOR", color);
        }
    }

    private void writeArrowLink(Element nodeEle, ITopic topic) {
        List<IRelationship> relationships = this.findRelationship(topic);
        if (relationships == null) {
            return;
        }
        for (IRelationship relationship : relationships) {
            Element arrowlinkEle = DOMUtils.createElement((Node)nodeEle, (String)"arrowlink");
            IStyle style = this.getRelationStyle(relationship);
            this.writeArrowLinkColor(arrowlinkEle, style);
            boolean canWriteCP = this.canWriteControlpoint(relationship);
            this.writeEndArrow(arrowlinkEle, relationship, style, canWriteCP);
            String arrowLineId = relationship.getId();
            arrowlinkEle.setAttribute("ID", arrowLineId);
            this.writeStartArrow(arrowlinkEle, relationship, style, canWriteCP);
        }
    }

    private boolean canWriteControlpoint(IRelationship relationship) {
        String end1Id = relationship.getEnd1Id();
        String end2Id = relationship.getEnd2Id();
        IWorkbook workbook = this.getSheet().getOwnedWorkbook();
        ITopic topic1 = workbook.findTopic(end1Id);
        ITopic topic2 = workbook.findTopic(end2Id);
        return topic1.isAttached() && topic2.isAttached();
    }

    private void writeStartArrow(Element arrowlinkEle, IRelationship relationship, IStyle style, boolean canWritePoint) {
        String arrowStart = null;
        String startArrow = null;
        if (style != null) {
            arrowStart = style.getProperty("arrow-begin-class");
        }
        startArrow = arrowStart == null || arrowStart.endsWith("none") ? "None" : "Default";
        arrowlinkEle.setAttribute("STARTARROW", startArrow);
        if (!canWritePoint) {
            return;
        }
        IControlPoint controlPoint = relationship.getControlPoint(0);
        Point p = controlPoint.getPosition();
        if (p != null) {
            String endInc = String.valueOf(String.valueOf(p.x)) + ";" + String.valueOf(p.y);
            arrowlinkEle.setAttribute("STARTINCLINATION", endInc);
        }
    }

    private void writeEndArrow(Element arrowlinkEle, IRelationship relationship, IStyle style, boolean canWritePoint) {
        String endArrowId = relationship.getEnd2Id();
        if (endArrowId != null) {
            arrowlinkEle.setAttribute("DESTINATION", endArrowId);
        }
        String arrowEnd = null;
        String endArrow = null;
        if (style != null) {
            arrowEnd = style.getProperty("arrow-end-class");
        }
        endArrow = arrowEnd != null && arrowEnd.endsWith("none") ? "None" : "Default";
        arrowlinkEle.setAttribute("ENDARROW", endArrow);
        if (!canWritePoint) {
            return;
        }
        IControlPoint controlPoint = relationship.getControlPoint(1);
        Point p = controlPoint.getPosition();
        if (p != null) {
            String endInc = String.valueOf(String.valueOf(p.x)) + ";" + String.valueOf(p.y);
            arrowlinkEle.setAttribute("ENDINCLINATION", endInc);
        }
    }

    private void writeArrowLinkColor(Element arrowlinkEle, IStyle style) {
        if (style == null) {
            return;
        }
        String lineColor = style.getProperty("line-color");
        if (lineColor == null) {
            return;
        }
        arrowlinkEle.setAttribute("COLOR", lineColor);
    }

    private IStyle getRelationStyle(IRelationship relationship) {
        String styleId = relationship.getStyleId();
        IWorkbook workbook = this.getSheet().getOwnedWorkbook();
        IStyleSheet styleSheet = workbook.getStyleSheet();
        return styleSheet.findStyle(styleId);
    }

    private void WriteVShift(Element nodeEle, ITopic topic) {
        if (topic.hasPosition() && topic.isAttached()) {
            Point position = topic.getPosition();
            String value = String.valueOf(position.y);
            nodeEle.setAttribute("VSHIFT", value);
        }
    }

    private void writeImageOrText(Element nodeEle, ITopic topic) {
        IImage image = topic.getImage();
        String source = image.getSource();
        if (source != null) {
            File imageDir = this.getImageDir();
            String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
            IFileEntry fileEntry = this.getSheet().getOwnedWorkbook().getManifest().getFileEntry(entryPath);
            String path = fileEntry.getPath();
            int lastIndex = path.lastIndexOf(47);
            String fileName = path.substring(lastIndex + 1);
            try {
                FileOutputStream os = new FileOutputStream(new File(imageDir, fileName));
                InputStream is = fileEntry.getInputStream();
                FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)false);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String sourcePath = "images/" + fileName;
            String value = "<html><img src=\"" + sourcePath + '\"' + ">";
            nodeEle.setAttribute("TEXT", value);
            return;
        }
        String text = topic.getTitleText();
        nodeEle.setAttribute("TEXT", text);
    }

    private File getImageDir() {
        if (this.imageDir == null) {
            int lastIndex = this.targetPath.lastIndexOf(92);
            String imageSource = this.targetPath.substring(0, lastIndex);
            this.imageDir = FileUtils.ensureDirectory((File)new File(imageSource, "images"));
        }
        return this.imageDir;
    }

    private void writSubTopics(Element topicEle, ITopic topic) {
        List children = topic.getAllChildren();
        if (children != null) {
            for (ITopic subTopic : children) {
                this.writeTopic(topicEle, subTopic);
            }
        }
    }

    private void writeFont(Element nodeEle, IStyle style) {
        if (style == null) {
            return;
        }
        String bold = style.getProperty("fo:font-weight");
        String italic = style.getProperty("fo:font-style");
        String fontSize = style.getProperty("fo:font-size");
        if (bold == null && italic == null && fontSize == null) {
            return;
        }
        Element fontEle = DOMUtils.createElement((Node)nodeEle, (String)"font");
        if (bold != null) {
            String isBold;
            String string = isBold = "bold".equals(bold) ? "true" : null;
            if (isBold != null) {
                fontEle.setAttribute("BOLD", isBold);
            }
        }
        if (italic != null) {
            String isItalic;
            String string = isItalic = "italic".equals(italic) ? "true" : null;
            if (isItalic != null) {
                fontEle.setAttribute("ITALIC", isItalic);
            }
        }
        fontEle.setAttribute("NAME", "SansSerif");
        if (fontSize != null) {
            int index = fontSize.indexOf("pt");
            String size = fontSize.substring(0, index);
            fontEle.setAttribute("SIZE", size);
        } else {
            fontEle.setAttribute("SIZE", "12");
        }
    }

    private void writePosition(Element nodeEle, ITopic topic) {
        ITopic parent = topic.getParent();
        if (parent != null && parent.isRoot()) {
            List topics = parent.getAllChildren();
            int index = topics.indexOf(topic);
            String value = index <= topics.size() / 2 ? "right" : "left";
            nodeEle.setAttribute("POSITION", value);
        }
    }

    private void writeTopicShapeStyle(Element nodeEle, IStyle style) {
        if (style == null) {
            return;
        }
        String shapeStyle = null;
        String shape = style.getProperty("shape-class");
        if (shape == null) {
            shapeStyle = "bubble";
            return;
        }
        shapeStyle = shape.endsWith("noBorder") || shape.endsWith("undeline") ? "fork" : "bubble";
        nodeEle.setAttribute("STYLE", shapeStyle);
    }

    private void writeModify(Element nodeEle) {
        String value = String.valueOf(System.currentTimeMillis());
        nodeEle.setAttribute("MOIFIED", value);
    }

    private void writeLink(Element nodeEle, ITopic topic) {
        String hyperlink = topic.getHyperlink();
        if (hyperlink == null) {
            return;
        }
        if (hyperlink.startsWith("file:/")) {
            String subHyper = hyperlink.substring("file:/".length());
            File file = new File(subHyper);
            if (file.isFile()) {
                if (this.areSameDir(this.targetPath, subHyper)) {
                    nodeEle.setAttribute("LINK", subHyper);
                } else {
                    String value = "../../../../" + subHyper;
                    nodeEle.setAttribute("LINK", value);
                }
            }
        } else if (hyperlink.startsWith("xmind:")) {
            String value = hyperlink.substring("xmind:".length());
            nodeEle.setAttribute("LINK", value);
        }
    }

    private boolean areSameDir(String path1, String path2) {
        int lastIndex2;
        String dir2;
        int lastIndex1;
        File file = new File(path1);
        URI uri = file.toURI();
        String temp = uri.toString().substring("file:/".length());
        String dir1 = temp.substring(0, lastIndex1 = temp.lastIndexOf(47));
        return dir1.equals(dir2 = path2.substring(0, lastIndex2 = path2.lastIndexOf(47)));
    }

    private void writeCreateFolderAndId(Element nodeEle, ITopic topic) {
        long times = System.currentTimeMillis();
        String value = String.valueOf(times);
        nodeEle.setAttribute("CREATED", value);
        if (topic.isFolded()) {
            nodeEle.setAttribute("FOLDER", "true");
        }
        String id = topic.getId();
        nodeEle.setAttribute("ID", id);
    }

    private void cacheMarkers() {
        if (this.markers == null) {
            this.markers = new HashMap<String, String>();
        }
        this.markers.put("priority-1", "full-1");
        this.markers.put("priority-2", "full-2");
        this.markers.put("priority-3", "full-3");
        this.markers.put("priority-4", "full-4");
        this.markers.put("priority-5", "full-5");
        this.markers.put("priority-6", "full-6");
        this.markers.put("smiley-smile", "ksmiletris");
        this.markers.put("flag", "flag");
        this.markers.put("star", "bookmark");
        this.markers.put("other-email", "Mail");
        this.markers.put("other-phone", "kaddressbook");
        this.markers.put("other-question", "help");
        this.markers.put("other-lightbulb", "idea");
        this.markers.put("other-unlock", "password");
        this.markers.put("other-yes", "button_ok");
        this.markers.put("other-no", "button_cancel");
        this.markers.put("other-bomb", "clanbomber");
    }

    private List<IRelationship> findRelationship(ITopic topic) {
        Set relationships = this.getSheet().getRelationships();
        if (relationships == null) {
            return null;
        }
        ArrayList<IRelationship> result = null;
        for (IRelationship next : relationships) {
            IRelationshipEnd end1 = next.getEnd1();
            String id1 = end1.getId();
            if (!id1.equals(topic.getId())) continue;
            if (result == null) {
                result = new ArrayList<IRelationship>();
            }
            result.add(next);
        }
        return result;
    }

    private void checkInterrupter() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", true);
            documentBuilder = factory.newDocumentBuilder();
        }
        return documentBuilder;
    }

    private class EdgeData {
        String color;
        String style;
        String width;

        public EdgeData(String color, String style, String width) {
            this.color = color;
            this.style = style;
            this.width = width;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EdgeData)) {
                return false;
            }
            EdgeData ed = (EdgeData)obj;
            return ed.color.equals(this.color) && ed.style.equals(this.style) && ed.width.equals(this.width);
        }
    }
}

