/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.views.ThemesViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;

public class ThemesView
extends ViewPart
implements IContributedContentsView,
IPartListener,
IPageChangedListener,
ICoreEventListener {
    private static final String KEY_LINK_TO_EDITOR = "LINK_TO_EDITOR";
    private IGraphicalEditor activeEditor;
    private ThemesViewer viewer;
    private IDialogSettings dialogSettings;
    private boolean linkingToEditor;
    private boolean updatingSelection = false;
    private ICoreEventRegister register = null;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public ThemesViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.dialogSettings = MindMapUIPlugin.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings.get(KEY_LINK_TO_EDITOR) == null) {
            this.dialogSettings.put(KEY_LINK_TO_EDITOR, true);
        }
        this.linkingToEditor = this.dialogSettings != null && this.dialogSettings.getBoolean(KEY_LINK_TO_EDITOR);
        this.viewer = new ThemesViewer(parent);
        this.viewer.setInput(this.getViewerInput());
        this.viewer.addOpenListener(new ChangeThemeListener());
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof IGraphicalEditor) {
            this.setActiveEditor((IGraphicalEditor)editor);
        }
        ToggleLinkEditorAction toggleLinkingAction = new ToggleLinkEditorAction();
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)toggleLinkingAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new Separator("additions"));
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)toggleLinkingAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener((IPartListener)this);
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserThemeSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.register = new CoreEventRegister((ICoreEventListener)this);
            this.register.setNextSupport(ces);
            this.register.register("styleAdd");
            this.register.register("styleRemove");
            this.register.register("name");
        }
    }

    public void dispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().setSelectionProvider(null);
        this.setActiveEditor(null);
        super.dispose();
        this.viewer = null;
        this.dialogSettings = null;
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private boolean isLinkingToEditor() {
        return this.linkingToEditor;
    }

    private void setLinkingToEditor(boolean linking) {
        if (linking == this.linkingToEditor) {
            return;
        }
        this.linkingToEditor = linking;
        if (this.dialogSettings != null) {
            this.dialogSettings.put(KEY_LINK_TO_EDITOR, linking);
        }
        if (linking) {
            this.updateSelection();
        }
    }

    private Object getViewerInput() {
        Set systemThemes = MindMapUI.getResourceManager().getSystemThemeSheet().getStyles("master-styles");
        Set userThemes = MindMapUI.getResourceManager().getUserThemeSheet().getStyles("master-styles");
        ArrayList<IStyle> list = new ArrayList<IStyle>(systemThemes.size() + userThemes.size() + 1);
        list.add(MindMapUI.getResourceManager().getDefaultTheme());
        list.addAll(systemThemes);
        list.addAll(userThemes);
        return list;
    }

    private void changeTheme(IStyle theme) {
        if (this.activeEditor == null) {
            return;
        }
        IGraphicalEditorPage page = this.activeEditor.getActivePageInstance();
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return;
        }
        ISheetPart sheetPart = (ISheetPart)viewer.getAdapter(ISheetPart.class);
        if (sheetPart == null) {
            return;
        }
        EditDomain domain = page.getEditDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(new Request("modify theme").setPrimaryTarget((IPart)sheetPart).setParameter("resource", (Object)theme));
        this.updateSelection();
    }

    private void updateSelection() {
        IStyle theme;
        if (!this.isLinkingToEditor()) {
            return;
        }
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        String themeId = this.getCurrentThemeId();
        if (themeId == null) {
            theme = MindMapUI.getResourceManager().getDefaultTheme();
        } else {
            theme = MindMapUI.getResourceManager().getSystemThemeSheet().findStyle(themeId);
            if (theme == null) {
                theme = MindMapUI.getResourceManager().getUserThemeSheet().findStyle(themeId);
            }
        }
        this.updatingSelection = true;
        this.viewer.setSelection((ISelection)(theme == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)theme)));
        this.updatingSelection = false;
    }

    private String getCurrentThemeId() {
        ISheet sheet;
        IGraphicalEditorPage page;
        if (this.activeEditor != null && (page = this.activeEditor.getActivePageInstance()) != null && (sheet = (ISheet)page.getAdapter(ISheet.class)) != null) {
            return sheet.getThemeId();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        this.setActiveEditor((IGraphicalEditor)part);
    }

    private void setActiveEditor(IGraphicalEditor editor) {
        if (editor == this.activeEditor) {
            return;
        }
        if (this.activeEditor != null) {
            this.unhook(this.activeEditor);
        }
        this.activeEditor = editor;
        if (editor != null) {
            this.hook(editor);
        }
        this.updateSelection();
    }

    private void hook(IGraphicalEditor editor) {
        editor.addPageChangedListener((IPageChangedListener)this);
    }

    private void unhook(IGraphicalEditor editor) {
        editor.removePageChangedListener((IPageChangedListener)this);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.activeEditor) {
            this.setActiveEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        this.updateSelection();
    }

    public void handleCoreEvent(CoreEvent event) {
        if ("name".equals(event.getType())) {
            this.viewer.update(new Object[]{event.getSource()});
        } else {
            this.viewer.setInput(this.getViewerInput());
            this.viewer.setSelection((ISelection)new StructuredSelection(event.getSource()), true);
        }
    }

    private class ChangeThemeListener
    implements IOpenListener {
        private ChangeThemeListener() {
        }

        public void open(OpenEvent event) {
            if (ThemesView.this.updatingSelection) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o != null && o instanceof IStyle) {
                ThemesView.this.changeTheme((IStyle)o);
            }
        }
    }

    private class ToggleLinkEditorAction
    extends Action {
        public ToggleLinkEditorAction() {
            super(MindMapMessages.ThemesView_LinkWithEditor_text, 2);
            this.setToolTipText(MindMapMessages.ThemesView_LinkWithEditor_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("synced.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("synced.gif", false));
            this.setChecked(ThemesView.this.isLinkingToEditor());
        }

        public void run() {
            ThemesView.this.setLinkingToEditor(this.isChecked());
        }
    }
}

