/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.CategorizedGalleryViewer;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.views.StyleFigure;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.viewers.ICategorizedContentProvider;

public class StylesViewer
extends CategorizedGalleryViewer
implements ICoreEventListener {
    private ICoreEventRegister register;

    public StylesViewer(Composite parent) {
        this.setContentProvider((IContentProvider)new StyleContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new StyleLabelProvider());
        this.createControl(parent, 0x100000);
    }

    protected void configureNestedViewer(GalleryViewer viewer) {
        super.configureNestedViewer(viewer);
        viewer.setPartFactory((IPartFactory)new StylePartFactory(viewer.getPartFactory()));
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(64, 64));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_TOP);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new StyleSelectTool());
        editDomain.installTool("edit tool", (ITool)new StyleNameEditTool());
        editDomain.setViewer((IViewer)viewer);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (this.register != null) {
            this.register.unregisterAll();
        } else {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        if (input instanceof IStyleSheet) {
            this.hookSheet((IStyleSheet)input);
        } else if (input instanceof IStyleSheet[]) {
            IStyleSheet[] iStyleSheetArray = (IStyleSheet[])input;
            int n = iStyleSheetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStyleSheet sheet = iStyleSheetArray[n2];
                this.hookSheet(sheet);
                ++n2;
            }
        }
    }

    private void hookSheet(IStyleSheet sheet) {
        ICoreEventSupport support = (ICoreEventSupport)sheet.getAdapter(ICoreEventSupport.class);
        if (support != null) {
            this.register.setNextSupport(support);
            this.register.register("styleAdd");
            this.register.register("styleRemove");
            this.register.register("name");
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if ("name".equals(event.getType())) {
            if (event.getSource() instanceof IStyle) {
                this.update(event.getSource(), null);
            }
        } else {
            this.setInput(this.getInput());
        }
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleContentProvider
    implements ICategorizedContentProvider {
        private StyleContentProvider() {
        }

        public Object getCategory(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getType();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (inputElement instanceof IStyleSheet[]) {
                IStyleSheet[] iStyleSheetArray = (IStyleSheet[])inputElement;
                int n = iStyleSheetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStyleSheet sheet = iStyleSheetArray[n2];
                    this.addStyles(sheet, list);
                    ++n2;
                }
            } else if (inputElement instanceof IStyleSheet) {
                this.addStyles((IStyleSheet)inputElement, list);
            }
            return list.toArray();
        }

        private void addStyles(IStyleSheet sheet, List<Object> list) {
            if (sheet == MindMapUI.getResourceManager().getSystemStyleSheet()) {
                list.addAll(sheet.getStyles("automatic-styles"));
            } else {
                list.addAll(sheet.getAllStyles());
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StyleLabelProvider
    extends LabelProvider {
        private StyleLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                return ((IStyle)element).getName();
            }
            if (element instanceof String) {
                String type = (String)element;
                if ("topic".equalsIgnoreCase(type)) {
                    return MindMapMessages.StylesViewer_Topic_label;
                }
                if ("boundary".equalsIgnoreCase(type)) {
                    return MindMapMessages.StylesViewer_Boundary_label;
                }
                if ("relationship".equalsIgnoreCase(type)) {
                    return MindMapMessages.StylesViewer_Relationship_label;
                }
                if ("summary".equalsIgnoreCase(type)) {
                    return MindMapMessages.StylesViewer_Summary_label;
                }
                if ("map".equalsIgnoreCase(type)) {
                    return MindMapMessages.StylesViewer_Map_label;
                }
            }
            return super.getText(element);
        }
    }

    private static class StyleNameEditTool
    extends GalleryEditTool {
        private StyleNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserStyleSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(70);
        }
    }

    private static class StylePart
    extends GraphicalEditPart {
        public StylePart(Object model) {
            this.setModel(model);
        }

        public IStyle getStyle() {
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            return new StyleFigure();
        }

        protected void updateView() {
            super.updateView();
            ((StyleFigure)this.getFigure()).setStyle(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }
    }

    private static class StylePartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public StylePartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof FramePart && model instanceof IStyle) {
                return new StylePart(model);
            }
            return this.factory.createPart(context, model);
        }
    }

    private static class StyleSelectTool
    extends GallerySelectTool {
        private StyleSelectTool() {
        }

        public boolean isTitleEditable(IPart p) {
            return super.isTitleEditable(p) && ((IStyle)p.getModel()).getOwnedStyleSheet() != MindMapUI.getResourceManager().getSystemStyleSheet();
        }
    }
}

