/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.views.StylesViewer;
import org.xmind.ui.mindmap.MindMapUI;

public class StylesView
extends ViewPart
implements IContributedContentsView {
    private StylesViewer viewer;

    public void createPartControl(Composite parent) {
        StackLayout layout = new StackLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new StylesViewer(parent);
        this.viewer.setInput(new IStyleSheet[]{MindMapUI.getResourceManager().getSystemStyleSheet(), MindMapUI.getResourceManager().getUserStyleSheet()});
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IStyle) {
                    StylesView.this.changeStyle((IStyle)element);
                }
            }
        });
        layout.topControl = this.viewer.getControl();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public StylesViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
    }

    public IWorkbenchPart getContributingPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void changeStyle(IStyle style) {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (!(activeEditor instanceof IGraphicalEditor)) {
            return;
        }
        IGraphicalEditor editor = (IGraphicalEditor)activeEditor;
        IGraphicalEditorPage page = editor.getActivePageInstance();
        if (page == null) {
            return;
        }
        EditDomain editDomain = page.getEditDomain();
        if (editDomain == null) {
            return;
        }
        editDomain.handleRequest(new Request("modify style").setParameter("resource", (Object)style));
    }
}

