/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;

public class NotesHyperlinkDialog
extends Dialog {
    private String href;
    private String displayText;

    protected NotesHyperlinkDialog(Shell parentShell, String oldHyperlink, String oldText) {
        super(parentShell);
        this.displayText = oldText == null ? "" : oldText;
        this.href = oldHyperlink == null ? "" : oldHyperlink;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MindMapMessages.NotesHyperlinkDialog_title);
    }

    protected Point getInitialSize() {
        return new Point(330, 220);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createHrefInputArea(composite);
        this.createDisplayTextInputArea(composite);
        return composite;
    }

    private void createDisplayTextInputArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        area.setLayout((Layout)gridLayout);
        Label label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText(MindMapMessages.NotesHyperlinkDialog_display_text);
        Text displayTextInput = new Text(area, 18436);
        displayTextInput.setLayoutData((Object)new GridData(4, 4, true, false));
        displayTextInput.setText(this.displayText);
        displayTextInput.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NotesHyperlinkDialog.this.displayText = ((Text)event.widget).getText();
                NotesHyperlinkDialog.this.updateButtons();
            }
        });
        displayTextInput.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                ((Text)event.widget).selectAll();
            }
        });
    }

    private void createHrefInputArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        area.setLayout((Layout)gridLayout);
        Label label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText(MindMapMessages.NotesHyperlinkDialog_hyperlinkReference_text);
        Text text = new Text(area, 18436);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.setText(this.href);
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NotesHyperlinkDialog.this.href = ((Text)event.widget).getText();
                NotesHyperlinkDialog.this.updateButtons();
            }
        });
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                ((Text)event.widget).selectAll();
            }
        });
        text.setFocus();
        text.setSelection(text.getCharCount());
    }

    private void updateButtons() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!"".equals(this.href));
        }
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getHref() {
        return this.href;
    }
}

