/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.util.MindMapUtils;

public class MarkerMoveTool
extends DummyMoveTool {
    private ITopicPart targetParent;
    private IFeedbackService feedbackService;

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof IMarkerPart));
        super.setSource(source);
    }

    protected IFigure createDummy() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            SizeableImageFigure dummy = new SizeableImageFigure(((IMarkerPart)this.getSource()).getImage());
            dummy.setStretched(true);
            dummy.setConstrained(true);
            dummy.setBounds(this.getSource().getFigure().getBounds());
            layer.add((IFigure)dummy);
            return dummy;
        }
        return null;
    }

    protected void start() {
        super.start();
        this.feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class);
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        ITopicPart newParent = this.findTopicPart(me.target);
        if (newParent != this.targetParent && this.feedbackService != null) {
            if (this.targetParent != null) {
                this.feedbackService.removeSelection(this.targetParent.getFigure());
            }
            if (newParent != null) {
                SelectionFigure selection = this.feedbackService.addSelection(newParent.getFigure());
                selection.setPreselectionColor(ColorUtils.getColor((String)"#f00000"));
                selection.setPreselectionFillAlpha(0);
                selection.setPreselectionFillColor(null);
                selection.setPreselected(true);
            }
        }
        this.targetParent = newParent;
    }

    protected void end() {
        if (this.feedbackService != null) {
            if (this.targetParent != null) {
                this.feedbackService.removeSelection(this.targetParent.getFigure());
            }
            this.feedbackService = null;
        }
        this.targetParent = null;
        super.end();
    }

    private ITopicPart findTopicPart(IPart p) {
        return MindMapUtils.findTopicPart(p);
    }

    private boolean isCopyMove() {
        if (GEF.IS_CARBON) {
            return this.getStatus().isStatus(2);
        }
        return this.getStatus().isStatus(4);
    }

    protected Request createRequest() {
        boolean copy = this.isCopyMove();
        Request request = new Request(copy ? "copy to" : "move to");
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)this.getSource());
        request.setParameter("parent", (Object)this.targetParent);
        return request;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.isCopyMove()) {
            return MindMapUI.getImages().getCursor(IMindMapImages.CURSOR_ADD);
        }
        return super.getCurrentCursor(pos, host);
    }
}

