/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tools.ToolHelperBase;

public class ImageMoveToolHelper
extends ToolHelperBase {
    private static final int LINE_WIDTH = 2;
    private static final int NORMAL_ALPHA = 128;
    private static final int SELECTION_ALPHA = 255;
    private static final String BORDER_COLOR = "#00a000";
    private static final String FILL_COLOR = "#50d050";
    private static final String SELECTION_COLOR = "#b0d040";
    private IFigure layer;
    private IFeedbackService feedbackService;
    private ITopicPart currentParent;
    private IFigure area;
    private AlphaRectangle top;
    private AlphaRectangle bottom;
    private AlphaRectangle left;
    private AlphaRectangle right;

    public void activate(EditDomain domain, IViewer viewer) {
        super.activate(domain, viewer);
        this.layer = ((IGraphicalViewer)viewer).getLayer(GEF.LAYER_PRESENTATION);
        this.feedbackService = (IFeedbackService)viewer.getService(IFeedbackService.class);
        this.removeArea();
    }

    public void deactivate(EditDomain domain, IViewer viewer) {
        this.removeArea();
        this.layer = null;
        if (this.feedbackService != null) {
            if (this.currentParent != null) {
                this.feedbackService.removeSelection(this.currentParent.getFigure());
            }
            this.feedbackService = null;
        }
        this.currentParent = null;
        super.deactivate(domain, viewer);
    }

    public void update(ITopicPart parent, IFigure feedback, Point cursorPos) {
        ITopicPart oldParent = this.currentParent;
        this.currentParent = parent;
        this.update(oldParent, parent, feedback, cursorPos);
    }

    private void update(ITopicPart oldParent, ITopicPart newParent, IFigure feedback, Point cursorPos) {
        if (oldParent != newParent) {
            if (this.feedbackService != null) {
                if (oldParent != null) {
                    this.feedbackService.removeSelection(oldParent.getFigure());
                }
                if (newParent != null) {
                    SelectionFigure selection = this.feedbackService.addSelection(newParent.getFigure());
                    selection.setPreselectionColor(ColorUtils.getColor((String)"#f00000"));
                    selection.setPreselectionFillAlpha(0);
                    selection.setPreselectionFillColor(null);
                    selection.setPreselected(true);
                }
            }
            this.removeArea();
            this.createArea(newParent, feedback);
        }
        this.updateArea(cursorPos);
    }

    private void updateArea(Point cursorPos) {
        IFigure targetDistrict = this.getTargetDistrict(cursorPos);
        this.updateColor(this.top, targetDistrict);
        this.updateColor(this.bottom, targetDistrict);
        this.updateColor(this.left, targetDistrict);
        this.updateColor(this.right, targetDistrict);
    }

    private IFigure getTargetDistrict(Point cursorPos) {
        if (this.top != null && this.top.containsPoint(cursorPos)) {
            return this.top;
        }
        if (this.bottom != null && this.bottom.containsPoint(cursorPos)) {
            return this.bottom;
        }
        if (this.left != null && this.left.containsPoint(cursorPos)) {
            return this.left;
        }
        if (this.right != null && this.right.containsPoint(cursorPos)) {
            return this.right;
        }
        return null;
    }

    private void updateColor(AlphaRectangle fig, IFigure district) {
        if (fig == null) {
            return;
        }
        if (fig == district) {
            fig.setBackgroundColor(ColorUtils.getColor((String)SELECTION_COLOR));
            fig.setAlpha(255);
        } else {
            fig.setBackgroundColor(ColorUtils.getColor((String)FILL_COLOR));
            fig.setAlpha(128);
        }
    }

    private void createArea(ITopicPart parent, IFigure feedback) {
        if (this.layer == null || parent == null) {
            return;
        }
        this.area = new Layer();
        int feedbackIndex = this.layer.getChildren().indexOf(feedback);
        this.layer.add(this.area, feedbackIndex);
        this.top = this.createDistrict();
        this.bottom = this.createDistrict();
        this.left = this.createDistrict();
        this.right = this.createDistrict();
        this.area.add((IFigure)this.top);
        this.area.add((IFigure)this.bottom);
        this.area.add((IFigure)this.left);
        this.area.add((IFigure)this.right);
        IFigure parentFigure = parent.getFigure();
        Rectangle bounds = parentFigure.getBounds();
        this.area.setBounds(bounds);
        this.layoutDistricts(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private void layoutDistricts(int x, int y, int width, int height) {
        int halfLine1 = 1;
        int halfLine2 = 2 - halfLine1;
        int w = width / 4;
        this.left.setBounds(new Rectangle(x, y, w + halfLine2 + 1, height));
        this.right.setBounds(new Rectangle(x + width - w - halfLine1 - 1, y, w + halfLine1 + 1, height));
        int h = height / 2;
        this.top.setBounds(new Rectangle(x += w + halfLine2, y, width -= w * 2 + 2, h + halfLine2));
        this.bottom.setBounds(new Rectangle(x, y + h - halfLine1, width, h + halfLine1));
    }

    private AlphaRectangle createDistrict() {
        AlphaRectangle fig = new AlphaRectangle();
        fig.setFill(true);
        fig.setOutline(true);
        fig.setBackgroundColor(ColorUtils.getColor((String)FILL_COLOR));
        fig.setForegroundColor(ColorUtils.getColor((String)BORDER_COLOR));
        fig.setLineWidth(2);
        return fig;
    }

    private void removeArea() {
        if (this.area != null) {
            if (this.area.getParent() != null) {
                this.area.getParent().remove(this.area);
            }
            this.area = null;
        }
        this.top = null;
        this.bottom = null;
        this.left = null;
        this.right = null;
    }

    public void decorateMoveRequest(Request request, Point cursorPos) {
        String alignment = this.getAlignment(cursorPos);
        if (alignment != null) {
            request.setParameter("property.imageAlignment", (Object)alignment);
        }
    }

    private String getAlignment(Point cursorPos) {
        if (this.top != null && this.top.containsPoint(cursorPos)) {
            return "top";
        }
        if (this.bottom != null && this.bottom.containsPoint(cursorPos)) {
            return "bottom";
        }
        if (this.left != null && this.left.containsPoint(cursorPos)) {
            return "left";
        }
        if (this.right != null && this.right.containsPoint(cursorPos)) {
            return "right";
        }
        return null;
    }

    private static class AlphaRectangle
    extends RectangleFigure {
        private int alpha;

        private AlphaRectangle() {
        }

        public void setAlpha(int alpha) {
            if (alpha == this.alpha) {
                return;
            }
            this.alpha = alpha;
            this.repaint();
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void paintFigure(Graphics graphics) {
            graphics.setAlpha(this.getAlpha());
            super.paintFigure(graphics);
        }
    }
}

