/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.xmind.core.IFileEntry;
import org.xmind.core.INamed;
import org.xmind.core.ITitled;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class AttachmentProtocol
implements IProtocol {
    private Map<IWorkbook, Map<String, IAction>> actions = null;

    public IAction createOpenHyperlinkAction(Object context, String uri) {
        IAction action;
        Map<String, IAction> wbActions;
        if (uri == null) {
            return null;
        }
        String path = HyperlinkUtils.toAttachmentPath((String)uri);
        if (path == null) {
            return null;
        }
        IWorkbook workbook = MindMapUtils.findWorkbook(context);
        if (workbook == null) {
            return null;
        }
        if (this.actions == null) {
            this.actions = new HashMap<IWorkbook, Map<String, IAction>>();
        }
        if ((wbActions = this.actions.get(workbook)) == null) {
            wbActions = new HashMap<String, IAction>();
            this.actions.put(workbook, wbActions);
        }
        if ((action = wbActions.get(uri)) == null) {
            action = this.createOpenAttachmentAction(AttachmentProtocol.getWindow(context), workbook, path, AttachmentProtocol.getFileName(context));
            wbActions.put(uri, action);
        }
        return action;
    }

    private IAction createOpenAttachmentAction(IWorkbenchWindow window, IWorkbook workbook, String path, String fileName) {
        AttachmentAction action = new AttachmentAction(window, workbook, path, fileName);
        action.setText(MindMapMessages.OpenAttachment_text);
        action.setToolTipText(fileName);
        ImageDescriptor image = MindMapUI.getImages().getFileIcon(path, true);
        if (image == null) {
            IFileEntry e = workbook.getManifest().getFileEntry(path);
            image = e != null && e.isDirectory() ? MindMapUI.getImages().get("fldr_obj.gif", true) : MindMapUI.getImages().get("unknownfile.gif", true);
        }
        action.setImageDescriptor(image);
        return action;
    }

    private static String getFileName(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(ITitled.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(INamed.class);
            }
            if (adapter != null) {
                context = adapter;
            }
        }
        if (context instanceof ITitled) {
            return ((ITitled)context).getTitleText();
        }
        if (context instanceof INamed) {
            return ((INamed)context).getName();
        }
        return null;
    }

    private static IWorkbenchWindow getWindow(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(IWorkbenchWindow.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(IEditorPart.class);
                if (adapter == null) {
                    adapter = ((IAdaptable)context).getAdapter(IWorkbenchPart.class);
                }
                if (adapter instanceof IWorkbenchPart) {
                    adapter = ((IWorkbenchPart)adapter).getSite().getWorkbenchWindow();
                }
            }
            if (adapter instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)adapter;
            }
        }
        if (context instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)context;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public String getProtocolName() {
        return HyperlinkUtils.getAttachmentProtocolName();
    }

    public boolean isHyperlinkModifiable(Object source, String uri) {
        return false;
    }

    private static class AttachmentAction
    extends Action {
        private IWorkbenchWindow window;
        private IWorkbook workbook;
        private String path;
        private String fileName;

        public AttachmentAction(IWorkbenchWindow window, IWorkbook workbook, String path, String fileName) {
            this.window = window;
            this.workbook = workbook;
            this.path = path;
            this.fileName = fileName;
        }

        public void run() {
            String hiberLoc = this.workbook.getTempLocation();
            if (hiberLoc == null) {
                return;
            }
            File hiberDir = new File(hiberLoc);
            if (!hiberDir.isDirectory()) {
                return;
            }
            File attFile = new File(hiberDir, this.path);
            if (!attFile.exists()) {
                return;
            }
            this.open(attFile.getAbsolutePath());
            if (this.workbook instanceof ICoreEventSource2) {
                ((ICoreEventSource2)this.workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
            }
        }

        private void open(String path) {
            String extension = FileUtils.getExtension((String)path);
            if (".xmt".equalsIgnoreCase(extension) ? this.window != null && this.openTemplate(this.window, path, this.fileName) : (".xmind".equalsIgnoreCase(extension) ? this.window != null && this.openMindMap(this.window, path, this.fileName) : ".xmp".equalsIgnoreCase(extension) && this.importMarkers(path))) {
                return;
            }
            Program.launch((String)path);
        }

        private boolean openTemplate(IWorkbenchWindow window, String path, String fileName) {
            return this.openMindMap(window, path, fileName);
        }

        private boolean openMindMap(final IWorkbenchWindow window, final String path, String fileName) {
            String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)path);
            final boolean[] ret = new boolean[1];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

                public void run() throws Exception {
                    window.getActivePage().openEditor(MME.createFileEditorInput(path), "org.xmind.ui.MindMapEditor");
                    ret[0] = true;
                }
            });
            return ret[0];
        }

        private boolean importMarkers(String path) {
            try {
                MarkerImpExpUtils.importMarkerPackage(path);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.MarkersPrefPage", null, null).open();
                    }
                });
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

