/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.core.INumbering;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.INumberFormatDescriptor;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.MComboViewer;

public class NumberingPropertySectionPart
extends MindMapPropertySectionPartBase {
    private MComboViewer formatViewer;
    private IAction prependingAction;
    private Text prefixInput;
    private Text suffixInput;
    private Text numberLabel;
    private Composite line2;

    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.horizontalSpacing = 3;
        layout1.verticalSpacing = 3;
        line1.setLayout((Layout)layout1);
        this.createLineContent1(line1);
        this.line2 = new Composite(parent, 0);
        this.line2.setLayoutData((Object)new GridData(4, 4, true, false));
        BalanceLayout layout2 = new BalanceLayout();
        this.line2.setLayout((Layout)layout2);
        this.createLineContent2(this.line2);
        layout2.left = this.prefixInput;
        layout2.center = this.numberLabel;
        layout2.right = this.suffixInput;
    }

    private void createLineContent1(Composite parent) {
        this.formatViewer = new MComboViewer(parent, 0);
        this.formatViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.formatViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.formatViewer.setLabelProvider((IBaseLabelProvider)new NumberFormatLabelProvider());
        List<INumberFormatDescriptor> descriptors = MindMapUI.getNumberFormatManager().getDescriptors();
        ArrayList<Object> list = new ArrayList<Object>(descriptors.size() + 1);
        Object separator = new Object();
        INumberFormatDescriptor defaultDescriptor = MindMapUI.getNumberFormatManager().getDescriptor("org.xmind.numbering.none");
        for (INumberFormatDescriptor desc : descriptors) {
            if (desc == null || defaultDescriptor == null || desc == defaultDescriptor) continue;
            list.add(desc);
        }
        if (defaultDescriptor != null) {
            list.add(separator);
            list.add(defaultDescriptor);
        }
        this.formatViewer.setSeparatorImitation(separator);
        this.formatViewer.setInput(list);
        this.formatViewer.addSelectionChangedListener((ISelectionChangedListener)new NumberFormatSelectionChangedListener());
        this.prependingAction = new PrependingAction();
        ToolBarManager bar = new ToolBarManager(0x800000);
        bar.add(this.prependingAction);
        ToolBar barControl = bar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private void createLineContent2(Composite parent) {
        this.prefixInput = new Text(parent, 16779268);
        this.prefixInput.setLayoutData((Object)new GridData(4, 2, true, false));
        this.prefixInput.setToolTipText(PropertyMessages.Prefix_toolTip);
        Listener eventHandler = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 15) {
                    if (event.widget == NumberingPropertySectionPart.this.prefixInput) {
                        NumberingPropertySectionPart.this.prefixInput.selectAll();
                    } else {
                        NumberingPropertySectionPart.this.suffixInput.selectAll();
                    }
                } else if (event.widget == NumberingPropertySectionPart.this.prefixInput) {
                    NumberingPropertySectionPart.this.changePrefix(NumberingPropertySectionPart.this.prefixInput.getText());
                } else {
                    NumberingPropertySectionPart.this.changeSuffix(NumberingPropertySectionPart.this.suffixInput.getText());
                }
            }
        };
        this.prefixInput.addListener(14, eventHandler);
        this.prefixInput.addListener(16, eventHandler);
        this.prefixInput.addListener(15, eventHandler);
        this.numberLabel = new Text(parent, 16779276);
        this.numberLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.numberLabel.setEditable(false);
        this.numberLabel.setBackground(this.numberLabel.getDisplay().getSystemColor(25));
        this.suffixInput = new Text(parent, 16779268);
        this.suffixInput.setLayoutData((Object)new GridData(4, 2, true, false));
        this.suffixInput.setToolTipText(PropertyMessages.Suffix_toolTip);
        this.suffixInput.addListener(14, eventHandler);
        this.suffixInput.addListener(16, eventHandler);
        this.suffixInput.addListener(15, eventHandler);
    }

    public void setFocus() {
        if (this.formatViewer != null && !this.formatViewer.getControl().isDisposed()) {
            this.formatViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.formatViewer = null;
        this.prependingAction = null;
        this.prefixInput = null;
        this.numberLabel = null;
        this.suffixInput = null;
        this.line2 = null;
    }

    protected void doRefresh() {
        Object o = ((IStructuredSelection)this.getCurrentSelection()).getFirstElement();
        if (o instanceof ITopic) {
            ITopic topic = (ITopic)o;
            ITopic parent = topic.getParent();
            if (parent == null) {
                parent = topic;
            }
            INumbering numbering = "attached".equals(topic.getType()) ? parent.getNumbering() : null;
            boolean hasFormat = false;
            if (this.formatViewer != null && !this.formatViewer.getControl().isDisposed()) {
                String format;
                String string = format = numbering == null ? null : numbering.getComputedFormat();
                if (format == null) {
                    format = "org.xmind.numbering.none";
                } else {
                    hasFormat = !"org.xmind.numbering.none".equals(format);
                }
                INumberFormatDescriptor descriptor = MindMapUI.getNumberFormatManager().getDescriptor(format);
                this.formatViewer.setSelection((ISelection)(descriptor == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)descriptor)));
            }
            if (this.prependingAction != null) {
                this.prependingAction.setChecked(numbering != null && numbering.prependsParentNumbers());
            }
            if (this.prefixInput != null && !this.prefixInput.isDisposed()) {
                String prefix = numbering == null ? null : numbering.getPrefix();
                this.prefixInput.setText(prefix == null ? "" : prefix);
            }
            if (this.suffixInput != null && !this.suffixInput.isDisposed()) {
                String suffix = numbering == null ? null : numbering.getSuffix();
                this.suffixInput.setText(suffix == null ? "" : suffix);
            }
            if (this.numberLabel != null && !this.numberLabel.isDisposed()) {
                String number = MindMapUtils.getNumberingText(topic, hasFormat ? null : "org.xmind.numbering.arabic");
                if (number == null || "".equals(number)) {
                    this.numberLabel.setText(" ");
                } else {
                    number = GraphicsUtils.getNormal().constrain(number, 100, JFaceResources.getDefaultFont(), 1);
                    this.numberLabel.setText(number);
                }
                if (hasFormat) {
                    this.numberLabel.setForeground(this.numberLabel.getDisplay().getSystemColor(24));
                } else {
                    this.numberLabel.setForeground(this.numberLabel.getDisplay().getSystemColor(16));
                }
            }
            if (this.line2 != null && !this.line2.isDisposed()) {
                this.line2.layout();
            }
        }
    }

    protected void registerEventListener(ICoreEventSource source, ICoreEventRegister register) {
        if (source instanceof ITopic) {
            INumbering numbering;
            ITopic parent = ((ITopic)source).getParent();
            if (parent == null) {
                parent = (ITopic)source;
            }
            if (parent instanceof ICoreEventSource) {
                register.setNextSource((ICoreEventSource)parent);
                register.register("topicAdd");
                register.register("topicRemove");
            }
            if ((numbering = parent.getNumbering()) instanceof ICoreEventSource) {
                register.setNextSource((ICoreEventSource)numbering);
                register.register("numberingFormat");
                register.register("numberingPrefix");
                register.register("numberingSuffix");
                register.register("parentNumberingPrepending");
            }
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if (("topicAdd".equals(type) || "topicRemove".equals(type)) && !"attached".equals(event.getData())) {
            return;
        }
        super.handleCoreEvent(event);
    }

    private void changeNumberFormat(String formatId) {
        Object o;
        if (formatId != null && (o = ((IStructuredSelection)this.getCurrentSelection()).getFirstElement()) instanceof ITopic) {
            ITopic topic = ((ITopic)o).getParent();
            if (topic == null) {
                topic = (ITopic)o;
            }
            if (formatId.equals(topic.getNumbering().getParentFormat())) {
                formatId = null;
            }
        }
        this.sendRequest(this.fillTargets(new Request("modify numbering")).setParameter("numbering.format", (Object)formatId));
    }

    private void changePrepending(boolean prepend) {
        this.sendRequest(this.fillTargets(new Request("modify numbering")).setParameter("numbering.prepending", (Object)prepend));
    }

    private void changePrefix(String newPrefix) {
        this.sendRequest(this.fillTargets(new Request("modify numbering").setParameter("numbering.prefix", (Object)newPrefix)));
    }

    private void changeSuffix(String newSuffix) {
        this.sendRequest(this.fillTargets(new Request("modify numbering").setParameter("numbering.suffix", (Object)newSuffix)));
    }

    private static class BalanceLayout
    extends Layout {
        public Control left;
        public Control center;
        public Control right;
        public int spacing = 3;

        private BalanceLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = new Point(0, 0);
            if (wHint >= 0) {
                size.x = wHint;
            }
            if (hHint >= 0) {
                size.y = hHint;
            }
            if (wHint < 0 || hHint < 0) {
                Point rightSize;
                Point leftSize;
                Point centerSize = this.center == null ? null : this.center.computeSize(-1, hHint, flushCache);
                if (this.left != null || this.right != null) {
                    leftSize = this.left == null ? null : this.left.computeSize(-1, hHint, flushCache);
                    rightSize = this.right == null ? null : this.right.computeSize(-1, hHint, flushCache);
                } else {
                    leftSize = null;
                    rightSize = null;
                }
                if (hHint < 0) {
                    if (centerSize != null) {
                        size.y = Math.max(size.y, centerSize.y);
                    }
                    if (leftSize != null) {
                        size.y = Math.max(size.y, leftSize.y);
                    }
                    if (rightSize != null) {
                        size.y = Math.max(size.y, rightSize.y);
                    }
                }
                if (wHint < 0) {
                    int width = 0;
                    if (leftSize != null) {
                        width = Math.max(width, leftSize.x);
                    }
                    if (rightSize != null) {
                        width = Math.max(width, rightSize.x);
                    }
                    if (centerSize != null) {
                        width += centerSize.x;
                    }
                    size.x = Math.max(size.x, width);
                }
            }
            size.x = Math.max(1, size.x);
            size.y = Math.max(1, size.y);
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            if (this.center != null) {
                if (this.left != null || this.right != null) {
                    Point centerSize = this.center.computeSize(-1, area.height, flushCache);
                    int maxCenterWidth = area.width - this.spacing * 2 - 20;
                    int centerWidth = Math.min(centerSize.x, maxCenterWidth);
                    this.center.setBounds(area.x + (area.width - centerWidth) / 2, area.y, centerWidth, area.height);
                    int sideWidth = (area.width - this.spacing * 2 - centerSize.x) / 2;
                    if (this.left != null) {
                        this.left.setBounds(area.x, area.y, sideWidth, area.height);
                    }
                    if (this.right != null) {
                        this.right.setBounds(area.x + area.width - sideWidth, area.y, sideWidth, area.height);
                    }
                } else {
                    this.center.setBounds(area);
                }
            } else if (this.left != null) {
                int sideWidth = Math.max(0, area.width - (this.right == null ? 0 : this.spacing)) / 2;
                this.left.setBounds(area.x, area.y, sideWidth, area.height);
                if (this.right != null) {
                    this.right.setBounds(area.x + area.width - sideWidth, area.y, sideWidth, area.height);
                }
            } else if (this.right != null) {
                int rightWidth = Math.max(0, area.width / 2);
                this.right.setBounds(area.x + area.width - rightWidth, area.y, rightWidth, area.height);
            }
        }
    }

    private class NumberFormatLabelProvider
    extends LabelProvider {
        private NumberFormatLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INumberFormatDescriptor) {
                INumberFormatDescriptor desc = (INumberFormatDescriptor)element;
                String name = desc.getName();
                String description = desc.getDescription();
                if (description == null || "".equals(description)) {
                    return name;
                }
                return NLS.bind((String)"{0} ({1})", (Object)name, (Object)description);
            }
            return super.getText(element);
        }
    }

    private class NumberFormatSelectionChangedListener
    implements ISelectionChangedListener {
        private NumberFormatSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (NumberingPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof INumberFormatDescriptor) {
                NumberingPropertySectionPart.this.changeNumberFormat(((INumberFormatDescriptor)o).getId());
            }
        }
    }

    private class PrependingAction
    extends Action {
        public PrependingAction() {
            super(null, 2);
            this.setImageDescriptor(MindMapUI.getImages().get("inherited.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("inherited.gif", false));
            this.setToolTipText(PropertyMessages.PrependNumbering_toolTip);
            this.setChecked(true);
        }

        public void run() {
            NumberingPropertySectionPart.this.changePrepending(this.isChecked());
        }
    }
}

