/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.gef.Request;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.properties.LineWidth;
import org.xmind.ui.internal.properties.LineWidthLabelProvider;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.MComboViewer;

public class LinePropertySectionPartBase
extends StyledPropertySectionPart {
    private ColorPicker lineColorPicker;
    private MComboViewer lineWidthViewer;

    protected void doRefresh() {
        String lineShapeId = this.getLineShapeId();
        this.refreshWithShapeId(lineShapeId);
    }

    protected String getLineShapeId() {
        return this.getStyleValue("line-class", null);
    }

    protected void refreshWithShapeId(String lineShapeId) {
        if (this.lineWidthViewer != null && !this.lineWidthViewer.getControl().isDisposed()) {
            String lineWidth = this.getStyleValue("line-width", lineShapeId);
            LineWidth element = LineWidth.findByValue(lineWidth);
            if (element == null) {
                element = LineWidth.Thinnest;
            }
            this.lineWidthViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
        if (this.lineColorPicker != null) {
            this.updateColorPicker(this.lineColorPicker, "line-color", lineShapeId);
        }
    }

    protected void createContent(Composite parent) {
        Composite line = new Composite(parent, 0);
        line.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line.setLayout((Layout)layout);
        this.createLineContent(line);
    }

    private void createLineContent(Composite parent) {
        this.lineWidthViewer = new MComboViewer(parent, 0);
        this.lineWidthViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.lineWidthViewer.getControl().setToolTipText(PropertyMessages.LineWidth_toolTip);
        this.lineWidthViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lineWidthViewer.setLabelProvider((IBaseLabelProvider)new LineWidthLabelProvider());
        this.lineWidthViewer.setInput((Object)LineWidth.values());
        this.lineWidthViewer.addSelectionChangedListener((ISelectionChangedListener)new LineWidthSelectionChangedListener());
        this.lineColorPicker = new ColorPicker(7, PaletteContents.getDefault());
        this.lineColorPicker.getAction().setToolTipText(PropertyMessages.LineColor_toolTip);
        this.lineColorPicker.addOpenListener((IOpenListener)new LineColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.lineColorPicker);
        ToolBar barControl = colorBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    public void setFocus() {
        if (this.lineWidthViewer != null && !this.lineWidthViewer.getControl().isDisposed()) {
            this.lineWidthViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.lineWidthViewer = null;
        this.lineColorPicker = null;
    }

    protected void changeLineColor(IColorSelection selection) {
        this.changeColor(selection, "line-color", CommandMessages.Command_ModifyLineColor);
    }

    protected void changeLineWidth(LineWidth lineWidth) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyLineShape);
        String value = lineWidth == null ? null : lineWidth.getValue();
        this.addStyle(request, "line-width", value);
        this.sendRequest(request);
    }

    private class LineColorOpenListener
    implements IOpenListener {
        private LineColorOpenListener() {
        }

        public void open(OpenEvent event) {
            LinePropertySectionPartBase.this.changeLineColor((IColorSelection)event.getSelection());
        }
    }

    private class LineWidthSelectionChangedListener
    implements ISelectionChangedListener {
        private LineWidthSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (LinePropertySectionPartBase.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof LineWidth) {
                LinePropertySectionPartBase.this.changeLineWidth((LineWidth)((Object)o));
            }
        }
    }
}

