/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.IImage;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;
import org.xmind.ui.viewers.MButton;
import org.xmind.ui.viewers.SWTUtils;

public class ImageSizePropertySectionPart
extends MindMapPropertySectionPartBase {
    private MButton widthInput;
    private MButton heightInput;
    private Hyperlink resetSizeButton;

    protected void createContent(Composite parent) {
        this.createWidthHeightInput(parent);
        this.createResetSizeButton(parent);
    }

    protected GridLayout createLayout(Composite parent) {
        GridLayout layout = super.createLayout(parent);
        layout.verticalSpacing = 10;
        return layout;
    }

    private void createWidthHeightInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        this.createWidthInput(composite);
        this.createHeightInput(composite);
    }

    private void createWidthInput(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(PropertyMessages.ImageWidth_label);
        this.widthInput = new MButton(parent, 2);
        this.widthInput.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.widthInput.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ImageSizePropertySectionPart.this.showSizeInput(ImageSizePropertySectionPart.this.widthInput.getControl());
            }
        });
    }

    private void createHeightInput(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(PropertyMessages.ImageHeight_label);
        this.heightInput = new MButton(parent, 2);
        this.heightInput.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.heightInput.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ImageSizePropertySectionPart.this.showSizeInput(ImageSizePropertySectionPart.this.heightInput.getControl());
            }
        });
    }

    private void showSizeInput(Control hostControl) {
        new InplaceSizeInput(hostControl).open();
    }

    private void createResetSizeButton(Composite parent) {
        this.resetSizeButton = new Hyperlink(parent, 0);
        this.resetSizeButton.setHref((Object)this);
        this.resetSizeButton.setText(PropertyMessages.ResetImageSize_text);
        this.resetSizeButton.setForeground(parent.getDisplay().getSystemColor(9));
        this.resetSizeButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ImageSizePropertySectionPart.this.resetImageSize();
            }

            public void linkEntered(HyperlinkEvent e) {
                ImageSizePropertySectionPart.this.resetSizeButton.setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent e) {
                ImageSizePropertySectionPart.this.resetSizeButton.setUnderlined(false);
            }
        });
    }

    protected void doRefresh() {
        IImage image = this.getImageModel();
        IImagePart part = this.getPart(image);
        boolean defaultWidth = false;
        boolean defaultHeight = false;
        if (this.widthInput != null && !this.widthInput.getControl().isDisposed()) {
            int width = image.getWidth();
            if (width == -1) {
                defaultWidth = true;
                if (part != null) {
                    width = part.getFigure().getBounds().width;
                }
            }
            if (width == -1) {
                width = 0;
            }
            this.widthInput.setText(String.valueOf(width));
        }
        if (this.heightInput != null && !this.heightInput.getControl().isDisposed()) {
            int height = image.getHeight();
            if (height == -1) {
                defaultHeight = true;
                if (part != null) {
                    height = part.getFigure().getBounds().height;
                }
            }
            if (height == -1) {
                height = 0;
            }
            this.heightInput.setText(String.valueOf(height));
        }
        this.resetSizeButton.setEnabled(!defaultWidth || !defaultHeight);
    }

    private IImagePart getPart(IImage model) {
        IPart p;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null && (p = viewer.findPart((Object)model)) instanceof IImagePart) {
            return (IImagePart)p;
        }
        return null;
    }

    private IImage getImageModel() {
        Object[] elements = this.getSelectedElements();
        if (elements.length > 0 && elements[0] instanceof IImage) {
            return (IImage)elements[0];
        }
        return null;
    }

    protected void registerEventListener(ICoreEventSource source, ICoreEventRegister register) {
        register.register("imageWidth");
        register.register("imageHeight");
    }

    public void setFocus() {
        if (this.widthInput != null && !this.widthInput.getControl().isDisposed()) {
            this.widthInput.getControl().setFocus();
        }
    }

    private void resetImageSize() {
        this.getActiveDomain().handleRequest(new Request("resize").setParameter("size", null));
    }

    private void modifySize(int width, int height) {
        this.getActiveDomain().handleRequest(new Request("resize").setParameter("size", (Object)new Dimension(width, height)));
    }

    private class InplaceSizeInput {
        private Control hostControl;
        private Spinner inputWidget;

        public InplaceSizeInput(Control hostControl) {
            this.hostControl = hostControl;
        }

        private void createInputWidget(Composite parent) {
            this.inputWidget = new Spinner(parent, 2048);
            this.inputWidget.setMinimum(2);
            this.inputWidget.setMaximum(9999);
            this.inputWidget.setIncrement(5);
            Listener sizeListener = new Listener(){

                public void handleEvent(Event event) {
                    int value = InplaceSizeInput.this.inputWidget.getSelection();
                    if (InplaceSizeInput.this.hostControl == ImageSizePropertySectionPart.this.widthInput.getControl()) {
                        ImageSizePropertySectionPart.this.modifySize(value, Integer.parseInt(ImageSizePropertySectionPart.this.heightInput.getText()));
                    } else {
                        ImageSizePropertySectionPart.this.modifySize(Integer.parseInt(ImageSizePropertySectionPart.this.widthInput.getText()), value);
                    }
                    InplaceSizeInput.this.close();
                }
            };
            this.inputWidget.addListener(14, sizeListener);
            this.inputWidget.addListener(16, sizeListener);
            this.inputWidget.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (SWTUtils.matchKey((int)0, (int)27, (int)event.stateMask, (int)event.keyCode)) {
                        InplaceSizeInput.this.close();
                    }
                }
            });
            this.inputWidget.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2) {
                        InplaceSizeInput.this.close();
                    }
                }
            });
            if (this.hostControl == ImageSizePropertySectionPart.this.widthInput.getControl()) {
                this.inputWidget.setSelection(Integer.parseInt(ImageSizePropertySectionPart.this.widthInput.getText()));
            } else {
                this.inputWidget.setSelection(Integer.parseInt(ImageSizePropertySectionPart.this.heightInput.getText()));
            }
        }

        public void open() {
            if (this.hostControl instanceof Composite) {
                this.createInputWidget((Composite)this.hostControl);
                this.inputWidget.setLocation(0, 0);
                Point size = this.hostControl.getSize();
                this.inputWidget.setSize(size);
                this.inputWidget.setFocus();
            }
        }

        public void close() {
            this.inputWidget.dispose();
        }

        protected Point getInitialLocation(Point initialSize) {
            return this.hostControl.toDisplay(0, 0);
        }

        protected Point getInitialSize() {
            return this.hostControl.getSize();
        }
    }
}

