/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.graphics.Rotate90Graphics;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportContentProvider;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.UnitConvertor;

public class PrintClient {
    private static final int VIEWER_MARGIN = 15;
    private static final int TEXT_MARGIN = 5;
    private String jobName;
    private PrinterData printerData;
    private IDialogSettings settings;
    private Shell parentShell;
    private Printer printer;
    private Rectangle pageBounds;
    private Rectangle pageClientArea;
    private Insets pageMargins;
    private Point dpi;
    private boolean needRotate = false;
    private boolean jobStarted = false;
    private List<MindMapExportContentProvider> providers = null;

    public PrintClient(String jobName, Shell parentShell, PrinterData printerData, IDialogSettings settings) {
        this.jobName = jobName;
        this.parentShell = parentShell;
        this.printerData = printerData;
        this.settings = settings;
    }

    public PrintClient print(IMindMap source) {
        String footerText;
        String headerText;
        if (!this.jobStarted) {
            if (!this.getPrinter().startJob(this.jobName)) {
                return this;
            }
            this.jobStarted = true;
        }
        if (!this.getPrinter().startPage()) {
            return this;
        }
        GC gc = new GC((Drawable)this.getPrinter());
        gc.setClipping(this.pageClientArea.x, this.pageClientArea.y - 1, this.pageClientArea.width, this.pageClientArea.height + 1);
        this.drawSourceContent(gc, source);
        gc.setClipping(null);
        if (!this.settings.getBoolean("noBorder")) {
            this.drawBorder(gc);
        }
        if ((headerText = this.settings.get("headerText")) != null && !"".equals(headerText)) {
            this.drawHeader(gc, headerText);
        }
        if ((footerText = this.settings.get("footerText")) != null && !"".equals(footerText)) {
            this.drawFooter(gc, footerText);
        }
        gc.dispose();
        this.getPrinter().endPage();
        return this;
    }

    private void drawHeader(GC gc, String text) {
        Font font = this.getFont("headerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("headerAlign", 2), true);
        }
        finally {
            font.dispose();
        }
    }

    private void drawFooter(GC gc, String text) {
        Font font = this.getFont("footerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("footerAlign", 4), false);
        }
        finally {
            font.dispose();
        }
    }

    private int getAlign(String alignKey, int defaultAlign) {
        return PrintConstants.toDraw2DAlignment(this.settings.get(alignKey), defaultAlign);
    }

    private Font getFont(String fontKey) {
        FontData[] fontData;
        Font font = null;
        String fontValue = this.settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * this.dpi.y / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private void drawText(GC gc, String text, Font font, int alignment, boolean top) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        int width = this.needRotate ? this.pageClientArea.height : this.pageClientArea.width;
        int height = this.needRotate ? this.pageClientArea.width : this.pageClientArea.height;
        int marginWidth = 5 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        int marginHeight = 5 * this.dpi.y / UnitConvertor.getScreenDpi().y;
        if (this.needRotate) {
            int temp = marginWidth;
            marginWidth = marginHeight;
            marginHeight = temp;
        }
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        int y = top ? -height / 2 : (height -= marginHeight * 2) / 2 - size.height;
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(this.pageClientArea.x + this.pageClientArea.width / 2, this.pageClientArea.y + this.pageClientArea.height / 2);
        SWTGraphics graphics = baseGraphics;
        Rotate90Graphics rotatedGraphics = null;
        if (this.needRotate) {
            rotatedGraphics = new Rotate90Graphics((Graphics)graphics);
            graphics = rotatedGraphics;
        }
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log(e, "Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private void drawBorder(GC gc) {
        gc.setForeground(this.parentShell.getDisplay().getSystemColor(2));
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.drawRectangle(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width, this.pageClientArea.height);
    }

    private void drawSourceContent(GC gc, IMindMap source) {
        MindMapExportContentProvider provider = new MindMapExportContentProvider((Composite)this.parentShell, source);
        if (this.providers == null) {
            this.providers = new ArrayList<MindMapExportContentProvider>();
        }
        this.providers.add(provider);
        provider.setMargin(15 * this.dpi.x / UnitConvertor.getScreenDpi().x);
        provider.setProperty("gradient", Boolean.FALSE);
        provider.setResizeStrategy(1, this.needRotate ? this.pageClientArea.height : this.pageClientArea.width, this.needRotate ? this.pageClientArea.width : this.pageClientArea.height);
        try {
            Layer layer;
            Rectangle exportArea = provider.getExportArea();
            double scale = provider.getScale();
            IFigure contents = provider.getContents();
            if (this.settings.getBoolean("noBackground") && (layer = provider.getViewer().getLayer(GEF.LAYER_BACKGROUND)) != null) {
                layer.setOpaque(false);
            }
            SWTGraphics baseGraphcis = new SWTGraphics(gc);
            baseGraphcis.translate(this.pageClientArea.x - (this.needRotate ? -exportArea.y - exportArea.height : exportArea.x), this.pageClientArea.y - (this.needRotate ? exportArea.x : exportArea.y));
            SWTGraphics graphics = baseGraphcis;
            ScaledGraphics scaledGraphics = null;
            Rotate90Graphics rotatedGraphics = null;
            if (scale > 0.0) {
                scaledGraphics = new ScaledGraphics((Graphics)graphics);
                scaledGraphics.scale(scale);
                graphics = scaledGraphics;
            }
            if (this.needRotate) {
                rotatedGraphics = new Rotate90Graphics((Graphics)graphics);
                graphics = rotatedGraphics;
            }
            try {
                try {
                    contents.paint((Graphics)graphics);
                }
                catch (Throwable e) {
                    Logger.log(e, "Error occurred while painting mind map: " + source.getCentralTopic().getTitleText());
                    if (rotatedGraphics != null) {
                        rotatedGraphics.dispose();
                    }
                    if (scaledGraphics != null) {
                        scaledGraphics.dispose();
                    }
                    baseGraphcis.dispose();
                }
            }
            finally {
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                if (scaledGraphics != null) {
                    scaledGraphics.dispose();
                }
                baseGraphcis.dispose();
            }
        }
        catch (Throwable e) {
            Logger.log(e, "Error occurred while painting mind map: " + source.getCentralTopic().getTitleText());
        }
    }

    protected Printer getPrinter() {
        if (this.printer == null) {
            this.printer = this.createPrinter();
            this.getPrinterInfos();
        }
        return this.printer;
    }

    private void getPrinterInfos() {
        this.dpi = new Point(this.printer.getDPI());
        this.pageBounds = new Rectangle(this.printer.getBounds());
        Rectangle trim = new Rectangle(this.printer.computeTrim(0, 0, 0, 0));
        this.pageMargins = new Insets(-trim.y, -trim.x, trim.right(), trim.bottom());
        this.pageClientArea = new Rectangle(this.printer.getClientArea());
        this.pageClientArea.x = this.pageBounds.x + (this.pageBounds.width - this.pageClientArea.width) / 2;
        this.pageClientArea.y = this.pageBounds.y + (this.pageBounds.height - this.pageClientArea.height) / 2;
        int leftMargin = this.getUserMargin("leftMargin");
        int rightMargin = this.getUserMargin("rightMargin");
        int topMargin = this.getUserMargin("topMargin");
        int bottomMargin = this.getUserMargin("bottomMargin");
        this.pageClientArea.expand(this.pageMargins);
        this.pageClientArea.x += leftMargin;
        this.pageClientArea.y += topMargin;
        this.pageClientArea.width -= leftMargin + rightMargin;
        this.pageClientArea.height -= topMargin + bottomMargin;
        this.needRotate = this.pageBounds.height > this.pageBounds.width;
    }

    private int getUserMargin(String key) {
        double margin;
        try {
            margin = this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            margin = 0.2;
        }
        double dpi = "leftMargin".equals(key) || "rightMargin".equals(key) ? (double)this.dpi.x : (double)this.dpi.y;
        return (int)(margin * dpi);
    }

    private Printer createPrinter() {
        return new Printer(this.printerData);
    }

    public void dispose() {
        if (this.printer != null) {
            if (!this.printer.isDisposed()) {
                this.printer.endJob();
            }
            this.printer.dispose();
            this.printer = null;
        }
        this.jobStarted = false;
        if (this.providers != null) {
            Object[] objectArray = this.providers.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((MindMapExportContentProvider)o).dispose();
                ++n2;
            }
            this.providers = null;
        }
    }
}

