/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.actions.DelegatingAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.notes.NotesPopup;
import org.xmind.ui.mindmap.AbstractIconTipContributor;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;

public class NotesIconTipContributor
extends AbstractIconTipContributor {
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        INotesContent content;
        INotes notes = topic.getNotes();
        if (notes.isEmpty()) {
            return null;
        }
        Object action = null;
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry != null && (action = actionRegistry.getAction(MindMapActionFactory.EDIT_NOTES.getId())) != null) {
            action = new DelegatingAction((IAction)action);
        }
        if (action == null) {
            action = new ShowNotesAction(topicPart);
        }
        if ((content = notes.getContent("plain")) instanceof IPlainNotesContent) {
            String text = ((IPlainNotesContent)content).getTextContent();
            if (text.length() > 500) {
                text = String.valueOf(text.substring(0, 500)) + "...\n...";
            }
            action.setToolTipText(text);
        }
        return action;
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("topicNotes");
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        topicPart.refresh();
    }

    private static class ShowNotesAction
    extends Action {
        private ITopicPart topicPart;

        public ShowNotesAction(ITopicPart topicPart) {
            super(MindMapMessages.EditNotes_text, MindMapUI.getImages().get("notes.gif", true));
            this.setId(MindMapActionFactory.EDIT_NOTES.getId());
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("notes.gif", false));
            this.topicPart = topicPart;
        }

        public void run() {
            if (!this.topicPart.getStatus().isActive()) {
                return;
            }
            IViewer viewer = this.topicPart.getSite().getViewer();
            if (viewer == null || viewer.getControl().isDisposed()) {
                return;
            }
            NotesPopup popup = new NotesPopup(viewer.getControl().getShell(), this.topicPart, false);
            popup.open();
        }
    }
}

