/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.graphics.Point;
import org.xmind.ui.internal.findreplace.AbstractFindReplaceOperationProvider;
import org.xmind.ui.internal.notes.NotesViewer;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichTextEditViewer;

public class NotesFindReplaceOperationProvider
extends AbstractFindReplaceOperationProvider {
    private static int parameter = 20;
    private NotesViewer viewer = null;
    private TextViewer textViewer = null;
    private IRichDocument document;
    private String text = null;
    private int offset = 0;

    public NotesFindReplaceOperationProvider(NotesViewer viewer) {
        this.viewer = viewer;
    }

    protected boolean findAll(String toFind) {
        int lastIndex;
        this.refreshText(this.viewer);
        if (!this.isCaseSensitive()) {
            this.text = this.text.toLowerCase();
            toFind.toLowerCase();
        }
        if ((lastIndex = this.text.lastIndexOf(toFind)) == -1) {
            return false;
        }
        this.selectText(lastIndex, toFind.length());
        return true;
    }

    protected boolean findNext(String toFind) {
        this.refreshText(this.viewer);
        this.offset = this.getCurrentOffset();
        if (this.offset < 0) {
            return false;
        }
        this.findNextSubText(toFind);
        if (this.offset < 0) {
            return false;
        }
        this.selectText(this.offset, toFind.length());
        return true;
    }

    private void findNextSubText(String toFind) {
        int firstIndex;
        int offset1 = this.isForward() ? 0 : this.text.length();
        int index = this.indexOf(this.text, toFind, this.offset);
        this.offset = index == -1 ? (firstIndex = this.indexOf(this.text, toFind, offset1)) : index;
    }

    private int getCurrentOffset() {
        Point range = this.textViewer.getSelectedRange();
        if (range.y > 0) {
            return this.isForward() ? range.x + range.y : range.x;
        }
        return this.text == null ? -1 : this.getNewOffset(this.text);
    }

    protected boolean replaceAll(String toFind, String toReplaceWith) {
        if (toReplaceWith == null || "".equals(toReplaceWith)) {
            return false;
        }
        this.refreshText(this.viewer);
        int index = this.getOffsetInText(toFind);
        boolean found = index != -1;
        while (found) {
            index = this.getOffsetInText(toFind);
            if (index == -1) break;
            try {
                this.document.replace(index, toFind.length(), toReplaceWith);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        int lastIndex = this.text.lastIndexOf(toReplaceWith);
        this.selectText(lastIndex, toReplaceWith.length());
        return found;
    }

    private int getOffsetInText(String toFind) {
        String str = this.document.get();
        if (!this.isCaseSensitive()) {
            str = str.toLowerCase();
            toFind = toFind.toLowerCase();
        }
        return str.indexOf(toFind);
    }

    protected boolean replaceNext(String toFind, String toReplaceWith) {
        int length;
        int start;
        block4: {
            Point range = this.textViewer.getSelectedRange();
            start = range.x;
            length = range.y;
            if (length == 0) {
                return false;
            }
            String str = this.document.get(start, length);
            if (toFind.equals(str)) break block4;
            return false;
        }
        try {
            this.document.replace(start, length, toReplaceWith);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.textViewer.setSelectedRange(start, toReplaceWith.length());
        return this.findNext(toFind);
    }

    public boolean canFind(String toFind) {
        return toFind != null;
    }

    public boolean canReplace(String toFind, String toReplaceWith) {
        return this.canFind(toFind);
    }

    public int getParameter() {
        return parameter;
    }

    public void setParameter(int op, boolean value) {
        parameter &= ~op;
        if (value) {
            parameter |= op;
        }
    }

    protected void selectText(int offset, int length) {
        if (this.textViewer != null) {
            this.textViewer.setSelectedRange(offset, length);
        }
    }

    private void refreshText(NotesViewer viewer) {
        IRichTextEditViewer imple = viewer.getImplementation();
        this.textViewer = imple.getTextViewer();
        this.document = imple.getDocument();
        this.text = this.document.get();
    }
}

