/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImageSpan;
import org.xmind.core.IParagraph;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.notes.NotesConstants;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlNotesContentBuilder {
    private static final Map<String, String> EMPTY_CONTENTS = Collections.emptyMap();
    private RichDocumentNotesAdapter adapter;
    private IStyleSheet styleSheet;
    private IRichDocument document;
    private Iterator<StyleRange> textStyles;
    private Iterator<LineStyle> lineStyles;
    private Iterator<Hyperlink> hyperlinks;
    private StyleRange textStyle;
    private LineStyle lineStyle;
    private Hyperlink hyperlink;
    private IHtmlNotesContent result;
    private IParagraph p;
    private IHyperlinkSpan h = null;
    private int totalLines;
    private int offset = 0;
    private int lineEnd = 0;
    private Map<String, Map<String, String>> contentsCache = new HashMap<String, Map<String, String>>();

    public HtmlNotesContentBuilder(RichDocumentNotesAdapter adapter) {
        this.adapter = adapter;
    }

    public void build(IRichDocument document) {
        this.document = document;
        if ("".equals(document.get())) {
            this.result = null;
            return;
        }
        this.textStyles = Arrays.asList(document.getTextStyles()).iterator();
        this.lineStyles = Arrays.asList(document.getLineStyles()).iterator();
        this.hyperlinks = Arrays.asList(document.getHyperlinks()).iterator();
        this.textStyle = this.textStyles.hasNext() ? this.textStyles.next() : null;
        this.lineStyle = this.lineStyles.hasNext() ? this.lineStyles.next() : null;
        this.hyperlink = this.hyperlinks.hasNext() ? this.hyperlinks.next() : null;
        this.totalLines = document.getNumberOfLines();
        this.styleSheet = this.adapter.getWorkbook().getStyleSheet();
        this.result = (IHtmlNotesContent)this.adapter.getWorkbook().createNotesContent("html");
        int lineIndex = 0;
        while (lineIndex < this.totalLines) {
            this.buildParagraph(lineIndex);
            ++lineIndex;
        }
    }

    private void buildParagraph(int lineIndex) {
        IRegion lineRange;
        this.p = this.result.createParagraph();
        this.result.addParagraph(this.p);
        if (this.lineStyle != null && this.lineStyle.lineIndex == lineIndex) {
            this.applyStyleToParagraph(this.p, this.lineStyle);
            this.lineStyle = this.lineStyles.hasNext() ? this.lineStyles.next() : null;
        }
        try {
            lineRange = this.document.getLineInformation(lineIndex);
        }
        catch (BadLocationException e) {
            Logger.log(e, "Failed to obtain line information");
            return;
        }
        int lineStart = lineRange.getOffset();
        int lineLength = lineRange.getLength();
        if (lineIndex < this.totalLines - 1) {
            lineLength += NotesConstants.LENGTH_DELIMITER;
        }
        this.lineEnd = lineStart + lineLength;
        while (this.offset < this.lineEnd) {
            this.buildLineContent();
        }
    }

    private void buildLineContent() {
        StyleRange appliedStyle = null;
        int next = this.isInHyperlink() ? Math.min(this.lineEnd, this.getNextHyperlinkEnd()) : Math.min(this.lineEnd, this.getNextHyperlinkStart());
        if (this.isInStyle()) {
            next = Math.min(next, Math.min(this.lineEnd, this.getNextStyleEnd()));
            appliedStyle = this.textStyle;
        } else {
            next = Math.min(next, Math.min(this.lineEnd, this.getNextStyleStart()));
        }
        if (this.isInHyperlink() && this.isHyperlinkStarting()) {
            this.startBuildingHyperlink();
        }
        ISpan span = this.createSpan(next, appliedStyle);
        this.addSpan(span);
        if (this.isInHyperlink() && this.isHyperlinkEnding(next)) {
            this.finishCurrentHyperlink();
        }
        if (this.isInStyle() && this.isStyleEnding(next)) {
            this.finishCurrentStyle();
        }
        this.offset = next;
    }

    private void finishCurrentStyle() {
        this.textStyle = this.textStyles.hasNext() ? this.textStyles.next() : null;
    }

    private boolean isStyleEnding(int next) {
        return this.textStyle != null && next == this.textStyle.start + this.textStyle.length;
    }

    private void finishCurrentHyperlink() {
        this.hyperlink = this.hyperlinks.hasNext() ? this.hyperlinks.next() : null;
        this.h = null;
    }

    private boolean isHyperlinkEnding(int next) {
        return this.hyperlink != null && next == this.hyperlink.end();
    }

    private void addSpan(ISpan span) {
        if (this.h != null) {
            this.h.addSpan(span);
        } else {
            this.p.addSpan(span);
        }
    }

    private ISpan createSpan(int next, StyleRange style) {
        String content = this.getTrimmedContent(next - this.offset);
        if (content != null) {
            if (style != null && style.metrics != null) {
                return this.createImage(style);
            }
            return this.createText(content, style);
        }
        return null;
    }

    private void startBuildingHyperlink() {
        this.h = this.result.createHyperlinkSpan(this.hyperlink.href);
        this.p.addSpan((ISpan)this.h);
    }

    private boolean isHyperlinkStarting() {
        return this.hyperlink != null && this.offset == this.hyperlink.start;
    }

    private int getNextStyleStart() {
        return this.textStyle == null ? Integer.MAX_VALUE : this.textStyle.start;
    }

    private int getNextStyleEnd() {
        StyleRange style = this.textStyle;
        int endOfStyle = style.start + style.length;
        return style == null ? Integer.MAX_VALUE : endOfStyle;
    }

    private int getNextHyperlinkStart() {
        return this.hyperlink == null ? Integer.MAX_VALUE : this.hyperlink.start;
    }

    private int getNextHyperlinkEnd() {
        return this.hyperlink == null ? Integer.MAX_VALUE : this.hyperlink.end();
    }

    private boolean isInStyle() {
        if (this.textStyle != null) {
            int endOfStyle = this.textStyle.start + this.textStyle.length;
            return this.offset >= this.textStyle.start && this.offset < endOfStyle;
        }
        return false;
    }

    private boolean isInHyperlink() {
        return this.hyperlink != null && this.offset >= this.hyperlink.start && this.offset < this.hyperlink.end();
    }

    private ITextSpan createText(String content, StyleRange style) {
        ITextSpan text = this.result.createTextSpan(content);
        this.applyStyleToSpan((ISpan)text, style);
        return text;
    }

    private IImageSpan createImage(StyleRange style) {
        String url;
        Image image = this.document.findImage(style.start);
        if (image != null && (url = this.adapter.getImageUrl(image)) != null) {
            IImageSpan img = this.result.createImageSpan(url);
            return img;
        }
        return null;
    }

    private String getTrimmedContent(int textLength) {
        String content;
        try {
            content = this.document.get(this.offset, textLength);
        }
        catch (BadLocationException e) {
            Logger.log(e, "Failed to obtain text contet");
            return null;
        }
        return this.trimContent(content);
    }

    public String trimContent(String content) {
        return content.replaceAll("\ufffc|\\r\\n|\\r|\\n", "");
    }

    private void applyStyleToParagraph(IParagraph p, LineStyle lineStyle) {
        if (lineStyle == null) {
            return;
        }
        String align = HtmlNotesContentBuilder.toModelAlign(lineStyle.alignment);
        if (align == null) {
            return;
        }
        HashMap<String, String> contents = new HashMap<String, String>();
        contents.put("fo:text-align", align);
        String styleId = this.getNewStyleId(contents, "paragraph");
        if (styleId == null) {
            return;
        }
        p.setStyleId(styleId);
    }

    private void applyStyleToSpan(ISpan span, StyleRange style) {
        String styleId;
        String background;
        int size;
        String fontName;
        if (style == null) {
            return;
        }
        if (style.font != null) {
            FontData fontData = style.font.getFontData()[0];
            fontName = fontData.getName();
            if (RichTextUtils.DEFAULT_FONT_DATA.getName().equals(fontName)) {
                fontName = null;
            }
            size = fontData.getHeight();
            if (RichTextUtils.DEFAULT_FONT_DATA.getHeight() == size) {
                size = -1;
            }
        } else {
            fontName = null;
            size = -1;
        }
        boolean bold = RichTextUtils.isBold((StyleRange)style);
        boolean italic = RichTextUtils.isItalic((StyleRange)style);
        boolean underline = style.underline;
        boolean strikeout = style.strikeout;
        String foreground = style.foreground == null ? null : ColorUtils.toString((Color)style.foreground);
        String string = background = style.background == null ? null : ColorUtils.toString((Color)style.background);
        if (!(fontName != null || size >= 0 || bold || italic || underline || strikeout || foreground != null || background != null)) {
            return;
        }
        HashMap<String, String> contents = new HashMap<String, String>();
        if (fontName != null) {
            contents.put("fo:font-family", fontName);
        }
        if (size > 0) {
            contents.put("fo:font-size", StyleUtils.addUnitPoint(size));
        }
        if (bold) {
            contents.put("fo:font-weight", "bold");
        }
        if (italic) {
            contents.put("fo:font-style", "italic");
        }
        if (underline || strikeout) {
            if (!underline) {
                contents.put("fo:text-decoration", "line-through");
            } else if (!strikeout) {
                contents.put("fo:text-decoration", "underline");
            } else {
                contents.put("fo:text-decoration", "underline line-through");
            }
        }
        if (foreground != null) {
            contents.put("fo:color", foreground);
        }
        if (background != null) {
            contents.put("fo:background-color", background);
        }
        if ((styleId = this.getNewStyleId(contents, "text")) == null) {
            return;
        }
        span.setStyleId(styleId);
    }

    private String getNewStyleId(Map<String, String> sourceContents, String styleType) {
        if (sourceContents.isEmpty()) {
            return null;
        }
        IStyle similar = this.findSimilarStyle(sourceContents);
        if (similar != null) {
            return similar.getId();
        }
        IStyle newStyle = this.createStyle(styleType, sourceContents);
        if (newStyle != null) {
            return newStyle.getId();
        }
        return null;
    }

    private Map<String, String> getContents(IStyle style) {
        if (style == null) {
            return EMPTY_CONTENTS;
        }
        String id = style.getId();
        Map<String, String> map = this.contentsCache.get(id);
        if (map != null) {
            return map;
        }
        map = new HashMap<String, String>();
        this.contentsCache.put(id, map);
        Iterator it = style.properties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            map.put(p.key, p.value);
        }
        return map;
    }

    private IStyle findSimilarStyle(Map<String, String> sourceCotents) {
        Set styles = this.styleSheet.getStyles("normal-styles");
        for (IStyle style : styles) {
            Map<String, String> contents = this.getContents(style);
            if (!contents.equals(sourceCotents)) continue;
            return style;
        }
        return null;
    }

    private IStyle createStyle(String styleType, Map<String, String> contents) {
        IStyle newStyle = this.styleSheet.createStyle(styleType);
        for (Map.Entry<String, String> en : contents.entrySet()) {
            newStyle.setProperty(en.getKey(), en.getValue());
        }
        this.styleSheet.addStyle(newStyle, "normal-styles");
        return newStyle;
    }

    private static String toModelAlign(int alignment) {
        if (alignment == 0x1000000) {
            return "center";
        }
        if (alignment == 131072) {
            return "right";
        }
        return null;
    }

    public IHtmlNotesContent getResult() {
        return this.result;
    }
}

