/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.xmind.gef.IViewer;
import org.xmind.gef.acc.AbstractGraphicalAccessible;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetAccessible
extends AbstractGraphicalAccessible {
    public SheetAccessible(ISheetPart host) {
        super((IGraphicalPart)host);
    }

    public ISheetPart getHost() {
        return (ISheetPart)super.getHost();
    }

    public String getName() {
        return this.getHost().getSheet().getTitleText();
    }

    public Rectangle getLocation() {
        IViewer viewer = this.getHost().getSite().getViewer();
        Rectangle r = new Rectangle(viewer.getControl().getBounds());
        Point p = viewer.getControl().toDisplay(r.x, r.y);
        r.x = p.x;
        r.y = p.y;
        return r;
    }

    protected List<? extends IPart> getChildrenParts() {
        IBranchPart central = this.getHost().getCentralBranch();
        List<IBranchPart> floatingBranches = this.getHost().getFloatingBranches();
        ArrayList<ITopicPart> topics = new ArrayList<ITopicPart>(floatingBranches.size() + (central == null ? 0 : 1));
        if (central != null) {
            topics.add(central.getTopicPart());
        }
        for (IBranchPart branch : floatingBranches) {
            topics.add(branch.getTopicPart());
        }
        return topics;
    }

    public int getRole() {
        return 35;
    }
}

