/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.graphicalpolicy.NullGraphicalPolicy;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IAnimationService;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IShadowService;
import org.xmind.ui.internal.mindmap.CacheManager;
import org.xmind.ui.mindmap.IAnimatablePart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapPartBase
extends GraphicalEditPart
implements IAnimatablePart,
ICoreEventListener {
    private ICoreEventRegister eventRegister = null;
    private ISelectionFeedbackHelper selectionFeedbackHelper = null;
    private IFeedback feedback = null;
    private IGraphicalPolicy graphicalPolicy = null;
    private boolean graphicalPolicyActivated = false;
    private ICacheManager cacheManager = null;

    protected MindMapPartBase() {
    }

    public IGraphicalPolicy getGraphicalPolicy() {
        if (this.graphicalPolicy == null) {
            return NullGraphicalPolicy.getInstance();
        }
        return this.graphicalPolicy;
    }

    public void setGraphicalPolicy(IGraphicalPolicy graphicalPolicy) {
        if (this.graphicalPolicy != null && this.graphicalPolicyActivated) {
            this.graphicalPolicy.deactivate((IGraphicalPart)this);
            this.graphicalPolicyActivated = false;
        }
        this.graphicalPolicy = graphicalPolicy;
        if (this.hasFigure() && graphicalPolicy != null && !this.graphicalPolicyActivated) {
            graphicalPolicy.activate((IGraphicalPart)this);
            this.graphicalPolicyActivated = true;
        }
    }

    public Object getRealModel() {
        return MindMapUtils.toRealModel(super.getModel());
    }

    protected void installModelListeners() {
        super.installModelListeners();
        Object m = this.getRealModel();
        if (m instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)m;
            this.eventRegister = new CoreEventRegister(source, (ICoreEventListener)this);
            this.registerCoreEvents(source, this.eventRegister);
        }
    }

    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
    }

    public void handleCoreEvent(CoreEvent event) {
    }

    protected void uninstallModelListeners() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListeners();
    }

    protected boolean isFigureAnimatable() {
        return false;
    }

    public IFigure getAnimatableFigure() {
        return this.getFigure();
    }

    public boolean isFigureAnimating() {
        IAnimationService anim = this.getAnimationService();
        if (anim != null) {
            return anim.isAnimating(this.getAnimatableFigure());
        }
        return false;
    }

    protected IAnimationService getAnimationService() {
        return (IAnimationService)this.getSite().getViewer().getService(IAnimationService.class);
    }

    protected IFeedbackService getFeedbackService() {
        return (IFeedbackService)this.getSite().getViewer().getService(IFeedbackService.class);
    }

    protected IShadowService getShadowService() {
        return (IShadowService)this.getSite().getViewer().getService(IShadowService.class);
    }

    protected void onActivated() {
        super.onActivated();
        this.registerAnimatableFigure();
        this.addShadow();
        this.feedback = this.createFeedback();
        this.selectionFeedbackHelper = this.createSelectionFeedbackHelper();
        if (this.selectionFeedbackHelper != null) {
            this.selectionFeedbackHelper.setHost((IGraphicalEditPart)this);
            this.selectionFeedbackHelper.setFeedbackService(this.getFeedbackService());
        }
    }

    protected void initFigure(IFigure figure) {
        super.initFigure(figure);
        if (this.graphicalPolicy != null && !this.graphicalPolicyActivated) {
            this.graphicalPolicy.activate((IGraphicalPart)this);
            this.graphicalPolicyActivated = true;
        }
    }

    protected void onDeactivated() {
        if (this.graphicalPolicy != null && this.graphicalPolicyActivated) {
            this.graphicalPolicy.deactivate((IGraphicalPart)this);
            this.graphicalPolicyActivated = false;
        }
        this.feedback = null;
        if (this.selectionFeedbackHelper != null) {
            this.selectionFeedbackHelper.setFeedbackService(null);
            this.selectionFeedbackHelper.setHost(null);
            this.selectionFeedbackHelper = null;
        }
        this.removeShadow();
        this.unregisterAnimatableFigure();
        super.onDeactivated();
    }

    protected void registerAnimatableFigure() {
        IAnimationService anim;
        if (this.isFigureAnimatable() && (anim = this.getAnimationService()) != null) {
            anim.registerFigure(this.getAnimatableFigure(), (IGraphicalPart)this);
        }
    }

    protected void unregisterAnimatableFigure() {
        IAnimationService anim;
        if (this.isFigureAnimatable() && (anim = this.getAnimationService()) != null) {
            anim.unregisterFigure(this.getAnimatableFigure());
        }
    }

    protected void addShadow() {
        IShadowService service;
        IFigure source = this.getShadowSource();
        if (source != null && (service = this.getShadowService()) != null) {
            service.addShadow(source);
        }
    }

    protected void removeShadow() {
        IShadowService service;
        IFigure source = this.getShadowSource();
        if (source != null && (service = this.getShadowService()) != null) {
            service.removeShadow(source);
        }
    }

    protected IFigure getShadowSource() {
        return null;
    }

    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return null;
    }

    protected IFeedback createFeedback() {
        return null;
    }

    public ISelectionFeedbackHelper getSelectionFeedbackHelper() {
        return this.selectionFeedbackHelper;
    }

    public IFeedback getFeedback() {
        return this.feedback;
    }

    protected void updateView() {
        super.updateView();
        this.updateFeedback();
    }

    protected void updateFeedback() {
        if (this.selectionFeedbackHelper != null) {
            this.selectionFeedbackHelper.updateFeedback(true);
        }
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ICacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager((IPart)this);
        }
        return this.cacheManager;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IGraphicalPolicy.class) {
            return this.getGraphicalPolicy();
        }
        if (adapter == IStyleSelector.class) {
            return this.getGraphicalPolicy().getStyleSelector((IGraphicalPart)this);
        }
        if (adapter == IStructure.class) {
            return this.getGraphicalPolicy().getStructure((IGraphicalPart)this);
        }
        if (adapter == ISelectionFeedbackHelper.class) {
            return this.getSelectionFeedbackHelper();
        }
        if (adapter == IFeedback.class) {
            return this.getFeedback();
        }
        if (adapter == ICacheManager.class) {
            return this.getCacheManager();
        }
        return super.getAdapter(adapter);
    }
}

