/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ILegend;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.gef.IDecorator;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.ui.internal.decorators.LegendDecorator;
import org.xmind.ui.internal.figures.LegendFigure;
import org.xmind.ui.internal.layouts.LegendLayout;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.LegendItem;
import org.xmind.ui.internal.mindmap.LegendSeparatorPart;
import org.xmind.ui.internal.mindmap.LegendTitleTextPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SheetPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendPart
extends MindMapPartBase
implements ILegendPart {
    private ITitleTextPart title = null;
    private List<ILegendItemPart> items = null;
    private LegendSeparatorPart separator = null;
    private ChildSorter sorter = new ChildSorter((IPart)this);
    private Point prefPosition = null;

    public LegendPart() {
        this.setDecorator((IDecorator)LegendDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new LegendFigure();
    }

    @Override
    public ILegend getLegend() {
        return (ILegend)super.getRealModel();
    }

    @Override
    public ISheetPart getOwnedSheet() {
        if (this.getParent() instanceof ISheetPart) {
            return (ISheetPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        SheetPart sheet;
        if (this.getParent() instanceof SheetPart && (sheet = (SheetPart)this.getParent()).getLegend() == this) {
            sheet.setLegend(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof SheetPart) {
            sheet = (SheetPart)this.getParent();
            sheet.setLegend(this);
        }
    }

    @Override
    public ITitleTextPart getTitle() {
        return this.title;
    }

    public void setTitle(ITitleTextPart title) {
        this.title = title;
    }

    @Override
    public List<ILegendItemPart> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ILegendItemPart>();
        }
        return this.items;
    }

    public void addItem(ILegendItemPart item) {
        this.getItems().add(item);
        this.sorter.sort(this.getItems());
    }

    public void removeItem(ILegendItemPart item) {
        this.getItems().remove(item);
        this.sorter.sort(this.getItems());
    }

    public LegendSeparatorPart getSeparator() {
        return this.separator;
    }

    public void setSeparator(LegendSeparatorPart separator) {
        this.separator = separator;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ILegend.class)) {
            return this.getLegend();
        }
        if (adapter == LegendSeparatorPart.class) {
            return this.separator;
        }
        if (adapter == ITitleTextPart.class || adapter == LegendTitleTextPart.class) {
            return this.title;
        }
        return super.getAdapter(adapter);
    }

    protected LayoutManager createLayoutManager() {
        return new LegendLayout(this);
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
        ILegend legend = this.getLegend();
        list.add(new ViewerModel(LegendTitleTextPart.class, legend));
        list.add(new ViewerModel(LegendSeparatorPart.class, legend));
        Collection<String> markerIds = this.getAllMarkers(legend);
        if (markerIds != null && !markerIds.isEmpty()) {
            TreeSet<LegendItem> items = new TreeSet<LegendItem>();
            for (String markerId : markerIds) {
                items.add(new LegendItem(legend, markerId));
            }
            list.addAll(items);
        }
        return list.toArray();
    }

    private Collection<String> getAllMarkers(ILegend legend) {
        IMarkerRefCounter counter = (IMarkerRefCounter)legend.getOwnedSheet().getAdapter(IMarkerRefCounter.class);
        if (counter != null) {
            return counter.getCountedRefs();
        }
        return null;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.legendMovable");
    }

    @Override
    protected void registerCoreEvents(ICoreEventSource source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("position");
        register.register("markerDescription");
        Object counter = this.getLegend().getOwnedSheet().getAdapter(IMarkerRefCounter.class);
        if (counter instanceof ICoreEventSource) {
            register.setNextSource((ICoreEventSource)counter);
            register.register("resourceRefs");
        }
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("position".equals(type)) {
            this.setPreferredPosition(MindMapUtils.toGraphicalPosition(this.getLegend().getPosition()));
        } else if ("markerDescription".equals(type)) {
            ILegendItemPart item;
            String markerId = (String)event.getTarget();
            if (markerId != null && (item = this.findItem(markerId)) != null) {
                item.refresh();
            }
        } else if ("resourceRefs".equals(type)) {
            this.refresh();
        } else {
            super.handleCoreEvent(event);
        }
    }

    private ILegendItemPart findItem(String markerId) {
        for (ILegendItemPart item : this.getItems()) {
            if (!markerId.equals(item.getMarkerId())) continue;
            return item;
        }
        return null;
    }

    protected void updateChildren() {
        super.updateChildren();
        for (ILegendItemPart item : this.getItems()) {
            item.update();
        }
    }

    @Override
    public Point getPreferredPosition() {
        return this.prefPosition;
    }

    public void setPreferredPosition(Point point) {
        this.prefPosition = point;
        this.getFigure().revalidate();
    }

    public IPart findAt(Point position) {
        IPart ret = super.findAt(position);
        if (ret != null && (ret == this.title || ret == this.separator)) {
            return this;
        }
        return ret;
    }

    public Cursor getCursor(Point pos) {
        return Cursors.HAND;
    }
}

