/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.Core;
import org.xmind.core.IPositioned;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.internal.editpolicies.TopicAlignmentSolver;
import org.xmind.ui.internal.editpolicies.TopicMoveCommandBuilder;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicMovablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "move to".equals(requestType) || "copy to".equals(requestType) || "align".equals(requestType) || "move up".equals(requestType) || "move down".equals(requestType) || "move left".equals(requestType) || "move right".equals(requestType);
    }

    public void handle(Request request) {
        String requestType = request.getType();
        if ("move to".equals(requestType) || "copy to".equals(requestType)) {
            this.moveOrCopyTopics(request);
        } else if ("align".equals(requestType)) {
            this.alignTopics(request);
        } else if ("move up".equals(requestType) || "move down".equals(requestType) || "move left".equals(requestType) || "move right".equals(requestType)) {
            this.quickMove(request, requestType);
        }
    }

    private void quickMove(Request request, String direction) {
        int dir = this.getDirection(direction);
        if (dir < 0) {
            return;
        }
        IBranchPart parent = null;
        ArrayList<IBranchPart> branches = new ArrayList<IBranchPart>();
        for (IPart p : request.getTargets()) {
            IBranchPart branch = MindMapUtils.findBranch(p);
            if (branch == null) continue;
            if (!branch.getTopic().isAttached()) {
                return;
            }
            if (parent != null && parent != branch.getParentBranch()) {
                return;
            }
            if (parent == null) {
                parent = branch.getParentBranch();
            }
            if (parent == null) {
                return;
            }
            branches.add(branch);
        }
        if (parent == null) {
            return;
        }
        IStructure structure = parent.getBranchPolicy().getStructure(parent);
        if (!(structure instanceof IBranchStructureExtension)) {
            return;
        }
        Collections.sort(branches, new Comparator<IBranchPart>(){

            @Override
            public int compare(IBranchPart o1, IBranchPart o2) {
                return o1.getBranchIndex() - o2.getBranchIndex();
            }
        });
        IBranchStructureExtension bse = (IBranchStructureExtension)structure;
        ArrayList<SourceCommand> commands = new ArrayList<SourceCommand>();
        int total = parent.getTopic().getChildren("attached").size();
        int i = 0;
        while (i < branches.size()) {
            ITopic topic;
            int index;
            int newIndex;
            IBranchPart child = (IBranchPart)branches.get(i);
            int offset = bse.getQuickMoveOffset(parent, child, dir);
            if (offset > 0) {
                int j = child.getBranchIndex() + 1;
                while (j < parent.getSubBranches().size()) {
                    IBranchPart b = parent.getSubBranches().get(j);
                    if (!branches.contains(b)) break;
                    ++offset;
                    ++j;
                }
            }
            if ((newIndex = (index = (topic = child.getTopic()).getIndex()) + offset) < 0 || newIndex >= total) {
                return;
            }
            DeleteTopicCommand c1 = new DeleteTopicCommand(topic);
            AddTopicCommand c2 = new AddTopicCommand(topic, parent.getTopic(), newIndex, "attached");
            commands.add(c1);
            commands.add(c2);
            ++i;
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(commands);
        command.setLabel(CommandMessages.Command_MoveTopic);
        this.saveAndRun((Command)command, request.getTargetDomain());
    }

    private int getDirection(String direction) {
        if ("move up".equals(direction)) {
            return 1;
        }
        if ("move down".equals(direction)) {
            return 4;
        }
        if ("move left".equals(direction)) {
            return 8;
        }
        if ("move right".equals(direction)) {
            return 16;
        }
        return -1;
    }

    private void alignTopics(Request request) {
        List<ITopic> topics = MindMapUtils.filterOutDescendents(MindMapUtils.getTopics(request.getTargets()), null);
        if (topics.isEmpty()) {
            return;
        }
        Object param = request.getParameter("alignment");
        if (param == null || !(param instanceof Integer)) {
            return;
        }
        int alignment = (Integer)param;
        IViewer viewer = request.getTargetViewer();
        ArrayList<ITopicPart> topicParts = new ArrayList<ITopicPart>(topics.size());
        for (ITopic topic : topics) {
            IPart p = viewer.findPart((Object)topic);
            if (!(p instanceof ITopicPart)) continue;
            topicParts.add((ITopicPart)p);
        }
        if (topicParts.isEmpty()) {
            return;
        }
        TopicAlignmentSolver solver = new TopicAlignmentSolver(alignment);
        solver.recordInitPositions(topicParts);
        solver.solve();
        ArrayList<ModifyPositionCommand> commands = new ArrayList<ModifyPositionCommand>(topicParts.size());
        for (Object key : solver.getKeys("free")) {
            if (!(key instanceof ITopicPart)) continue;
            ITopicPart topicPart = (ITopicPart)key;
            Point pos = solver.getSolvedPosition(key);
            pos = this.getNewPosition(topicPart, pos);
            ITopic topic = topicPart.getTopic();
            commands.add(new ModifyPositionCommand((IPositioned)topic, MindMapUtils.toModelPosition(pos)));
        }
        if (commands.isEmpty()) {
            return;
        }
        String commandLabel = this.getAlignCommandLabel(alignment);
        CompoundCommand cmd = new CompoundCommand(commands);
        cmd.setLabel(commandLabel);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private String getAlignCommandLabel(int alignment) {
        switch (alignment) {
            case 1: {
                return CommandMessages.Command_AlignLeft;
            }
            case 2: {
                return CommandMessages.Command_AlignCenter;
            }
            case 4: {
                return CommandMessages.Command_AlignRight;
            }
            case 8: {
                return CommandMessages.Command_AlignTop;
            }
            case 16: {
                return CommandMessages.Command_AlignMiddle;
            }
            case 32: {
                return CommandMessages.Command_AlignBottom;
            }
        }
        return CommandMessages.Command_Align;
    }

    private Point getNewPosition(ITopicPart topicPart, Point pos) {
        IBranchPart parent;
        IBranchPart branch = topicPart.getOwnerBranch();
        if (branch != null && (parent = branch.getParentBranch()) != null) {
            Point parentPos = ((IReferencedFigure)parent.getFigure()).getReference();
            pos = new Point(pos.x - parentPos.x, pos.y - parentPos.y);
        }
        return pos;
    }

    private void moveOrCopyTopics(Request request) {
        String targetType;
        ITopic targetParent;
        List<ITopic> topics = MindMapUtils.filterOutDescendents(MindMapUtils.getTopics(request.getTargets()), null);
        if (topics.isEmpty()) {
            return;
        }
        Collections.sort(topics, Core.getTopicComparator());
        Point targetPosition = (Point)request.getParameter("position");
        ITopicPart parentPart = this.getTargetParent(request);
        boolean copy = Boolean.TRUE.equals(request.getParameter("copy"));
        if (targetPosition == null && parentPart == null && !copy) {
            return;
        }
        boolean relative = Boolean.TRUE.equals(request.getParameter("positionRelative"));
        int targetIndex = request.getIntParameter("index", -1);
        IViewer viewer = request.getTargetViewer();
        if (parentPart != null) {
            targetParent = parentPart.getTopic();
            targetType = "attached";
        } else {
            targetParent = (ITopic)viewer.getAdapter(ITopic.class);
            targetType = "detached";
        }
        if (targetParent == null || !copy && !this.isValidMoveToNewParent(targetParent, topics)) {
            return;
        }
        TopicMoveCommandBuilder builder = new TopicMoveCommandBuilder(viewer, request.getTargetCommandStack(), targetParent, targetIndex, targetType, targetPosition, relative);
        PropertyCommandBuilder builder2 = new PropertyCommandBuilder(viewer, builder, request);
        if (!builder.canStart()) {
            return;
        }
        builder.setLabel(copy ? CommandMessages.Command_CopyTopic : CommandMessages.Command_MoveTopic);
        builder.start();
        builder2.start();
        for (ITopic topic : topics) {
            if (copy) {
                builder.copyTopic(topic);
            } else {
                builder.moveTopic(topic);
            }
            builder2.addSource(topic, true);
        }
        builder2.end();
        builder.end();
        CompoundCommand cmd = builder.getCommand();
        if (cmd instanceof ISourceProvider) {
            this.select(((ISourceProvider)cmd).getSources(), viewer);
        }
    }

    private ITopicPart getTargetParent(Request request) {
        Object param = request.getParameter("parent");
        if (param instanceof ITopicPart) {
            return (ITopicPart)param;
        }
        return null;
    }

    private boolean isValidMoveToNewParent(ITopic newParent, List<ITopic> topics) {
        if (MindMapUtils.isAncestorInList(newParent, topics)) {
            return false;
        }
        Set<ITopicRange> ranges = MindMapUtils.findContainedRanges(topics, true, false);
        if (!ranges.isEmpty()) {
            for (ITopicRange range : ranges) {
                ITopic summaryTopic = ((ISummary)range).getTopic();
                if (summaryTopic == null || !summaryTopic.equals(newParent) && !MindMapUtils.isDescendentOf(newParent, summaryTopic)) continue;
                return false;
            }
        }
        return true;
    }
}

