/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.IFileEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IAnimationService;
import org.xmind.ui.branch.ICreatableBranchStructureExtension;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.AddSummaryCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.CreateBoundaryCommand;
import org.xmind.ui.commands.CreateSummaryCommand;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.ModifyBoundaryMasterCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.commands.ModifySummaryTopicCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editpolicies.CreateTopicCommandBuilder;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.internal.editpolicies.Range;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicCreatablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "create".equals(requestType) || "create before".equals(requestType) || "create child".equals(requestType) || "create parent".equals(requestType) || "add attachment".equals(requestType) || "add marker".equals(requestType) || "create boundary".equals(requestType) || "create summary".equals(requestType) || "add image".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("create".equals(reqType) || "create child".equals(reqType) || "create before".equals(reqType) || "create parent".equals(reqType)) {
            this.createTopic(request);
        } else if ("add attachment".equals(reqType)) {
            this.addAttachments(request);
        } else if ("add marker".equals(reqType)) {
            this.addMarker(request);
        } else if ("create boundary".equals(reqType)) {
            this.createBoundary(request);
        } else if ("create summary".equals(reqType)) {
            this.createSummary(request);
        } else if ("add image".equals(reqType)) {
            this.addImage(request);
        }
    }

    private void createSummary(Request request) {
        List targets = request.getTargets();
        Command cmd = this.createCreateSummaryCommand(request, targets);
        if (cmd != null) {
            cmd.setLabel(CommandMessages.Command_CreateSummary);
            this.saveAndRun(cmd, request.getTargetDomain());
            if (cmd instanceof ISourceProvider) {
                this.select(((ISourceProvider)cmd).getSources(), request.getTargetViewer());
            }
        }
    }

    private Command createCreateSummaryCommand(Request request, List<IPart> targets) {
        List<ITopic> topics = MindMapUtils.getTopics(targets);
        if (topics.isEmpty()) {
            return null;
        }
        Map<ITopic, Collection<ITopic>> map = this.categorize(topics, true);
        ArrayList<Command> cmds = new ArrayList<Command>(map.size() * 3);
        for (ITopic parent : map.keySet()) {
            Command cmd = this.createCreateSummariesCommand(parent, map.get(parent));
            if (cmd == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createCreateSummariesCommand(ITopic parent, Collection<ITopic> topics) {
        if (topics.isEmpty()) {
            return null;
        }
        List<Range> ranges = this.getRanges(topics);
        ArrayList<Command> cmds = new ArrayList<Command>(ranges.size());
        for (Range range : ranges) {
            Command cmd;
            if (this.hasSameSummary(parent, range) || (cmd = this.createCreateSummaryCommand(parent, range)) == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createCreateSummaryCommand(ITopic parent, Range range) {
        IWorkbook workbook = parent.getOwnedWorkbook();
        CreateSummaryCommand createSummary = new CreateSummaryCommand(workbook);
        ModifyRangeCommand modifyStart = new ModifyRangeCommand((ISourceProvider)createSummary, range.start, true);
        ModifyRangeCommand modifyEnd = new ModifyRangeCommand((ISourceProvider)createSummary, range.end, false);
        CreateTopicCommand createSummaryTopic = new CreateTopicCommand(workbook);
        ModifyTitleTextCommand modifyTitle = new ModifyTitleTextCommand((ISourceProvider)createSummaryTopic, MindMapMessages.TitleText_SummaryTopic);
        ModifySummaryTopicCommand modifySummaryTopic = new ModifySummaryTopicCommand((ISourceProvider)createSummary, (ISourceProvider)createSummaryTopic);
        AddSummaryCommand addSummary = new AddSummaryCommand((ISourceProvider)createSummary, parent);
        AddTopicCommand addSummaryTopic = new AddTopicCommand((ISourceProvider)createSummaryTopic, parent, -1, "summary");
        createSummary.setSourceCollectable(false);
        modifyStart.setSourceCollectable(false);
        modifyEnd.setSourceCollectable(false);
        modifySummaryTopic.setSourceCollectable(false);
        addSummary.setSourceCollectable(false);
        return new CompoundCommand(new Command[]{createSummary, modifyStart, modifyEnd, createSummaryTopic, modifyTitle, modifySummaryTopic, addSummary, addSummaryTopic});
    }

    private boolean hasSameSummary(ITopic parent, Range range) {
        for (ISummary b : parent.getSummaries()) {
            int s = b.getStartIndex();
            int e = b.getEndIndex();
            if (s != range.start || e != range.end) continue;
            return true;
        }
        return false;
    }

    private void createBoundary(Request request) {
        List sources = request.getTargets();
        Command cmd = this.createCreateBoundariesCommand(request, sources);
        if (cmd != null) {
            cmd.setLabel(CommandMessages.Command_CreateBoundary);
            this.saveAndRun(cmd, request.getTargetDomain());
            if (cmd instanceof ISourceProvider) {
                this.select(((ISourceProvider)cmd).getSources(), request.getTargetViewer());
            }
        }
    }

    private Command createCreateBoundariesCommand(Request request, List<IPart> sources) {
        List<ITopic> topics = MindMapUtils.getTopics(sources);
        if (topics.isEmpty()) {
            return null;
        }
        Map<ITopic, Collection<ITopic>> map = this.categorize(topics, false);
        ArrayList<Command> cmds = new ArrayList<Command>(map.size() * 2);
        for (ITopic parent : map.keySet()) {
            Command cmd = this.createCreateBoundariesCommand(parent, map.get(parent));
            if (cmd == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createCreateBoundariesCommand(ITopic parent, Collection<ITopic> topics) {
        if (topics.isEmpty()) {
            return null;
        }
        List<Range> ranges = this.getRanges(topics);
        ArrayList<Command> cmds = new ArrayList<Command>(ranges.size());
        for (Range range : ranges) {
            Command cmd;
            if (this.hasSameBoundary(parent, range) || (cmd = this.createCreateBoundaryCommand(parent, range)) == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private boolean hasSameBoundary(ITopic parent, Range range) {
        if (range.overTopic != null) {
            for (IBoundary b : range.overTopic.getBoundaries()) {
                if (!b.isMasterBoundary()) continue;
                return true;
            }
        }
        for (IBoundary b : parent.getBoundaries()) {
            int s = b.getStartIndex();
            int e = b.getEndIndex();
            if (s != range.start || e != range.end) continue;
            return true;
        }
        return false;
    }

    private List<Range> getRanges(Collection<ITopic> topics) {
        ITopic[] ts = topics.toArray(new ITopic[topics.size()]);
        Arrays.sort(ts, Core.getTopicComparator());
        ArrayList<Range> ranges = new ArrayList<Range>(ts.length);
        Range r = null;
        ITopic[] iTopicArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic t = iTopicArray[n2];
            String topicType = t.getType();
            if ("detached".equals(topicType) || "summary".equals(topicType)) {
                if (r != null) {
                    ranges.add(r);
                }
                r = null;
                ranges.add(new Range(t));
            } else {
                int i = t.getIndex();
                if (i >= 0) {
                    if (r == null) {
                        r = new Range(i);
                    } else if (i == r.end + 1) {
                        r.end = i;
                    } else if (i > r.end + 1) {
                        ranges.add(r);
                        r = new Range(i);
                    }
                }
            }
            ++n2;
        }
        if (r != null) {
            ranges.add(r);
        }
        return ranges;
    }

    private Command createCreateBoundaryCommand(ITopic parent, Range range) {
        if (range.overTopic != null) {
            CreateBoundaryCommand create = new CreateBoundaryCommand(range.overTopic.getOwnedWorkbook());
            ModifyBoundaryMasterCommand modify = new ModifyBoundaryMasterCommand((ISourceProvider)create, true);
            AddBoundaryCommand add = new AddBoundaryCommand((ISourceProvider)create, range.overTopic);
            return new CompoundCommand(new Command[]{create, modify, add});
        }
        CreateBoundaryCommand create = new CreateBoundaryCommand(parent.getOwnedWorkbook());
        ModifyRangeCommand modify1 = new ModifyRangeCommand((ISourceProvider)create, range.start, true);
        ModifyRangeCommand modify2 = new ModifyRangeCommand((ISourceProvider)create, range.end, false);
        AddBoundaryCommand add = new AddBoundaryCommand((ISourceProvider)create, parent);
        return new CompoundCommand(new Command[]{create, modify1, modify2, add});
    }

    private Map<ITopic, Collection<ITopic>> categorize(List<ITopic> topics, boolean onlyAttachedTopics) {
        HashMap<ITopic, Collection<ITopic>> map = new HashMap<ITopic, Collection<ITopic>>();
        for (ITopic t : topics) {
            ITopic p = t.getParent();
            if (p == null || onlyAttachedTopics && !t.isAttached() || this.isAncestorInCollection(p, topics)) continue;
            HashSet<ITopic> c = (HashSet<ITopic>)map.get(p);
            if (c == null) {
                c = new HashSet<ITopic>();
                map.put(p, c);
            }
            c.add(t);
        }
        return map;
    }

    private boolean isAncestorInCollection(ITopic parent, Collection<ITopic> topics) {
        if (parent == null) {
            return false;
        }
        if (topics.contains(parent)) {
            return true;
        }
        return this.isAncestorInCollection(parent.getParent(), topics);
    }

    private void addMarker(Request request) {
        List targets = request.getTargets();
        Command cmd = this.createAddMarkerCommand(request, targets);
        if (cmd != null) {
            cmd.setLabel(CommandMessages.Command_AddMarker);
            this.saveAndRun(cmd, request.getTargetDomain());
            if (cmd instanceof ISourceProvider) {
                this.select(((ISourceProvider)cmd).getSources(), request.getTargetViewer());
            }
        }
    }

    private Command createAddMarkerCommand(Request request, List<IPart> targets) {
        String[] markerIds = this.getMarkerIds(request);
        if (markerIds == null || markerIds.length == 0) {
            return null;
        }
        ArrayList<Command> cmds = new ArrayList<Command>(targets.size());
        this.createAddMarkerCommand(targets, cmds, markerIds);
        if (!cmds.isEmpty()) {
            return new CompoundCommand(cmds);
        }
        return null;
    }

    private String[] getMarkerIds(Request request) {
        Object param = request.getParameter("markerId");
        if (param instanceof String) {
            return new String[]{(String)param};
        }
        if (param instanceof String[]) {
            return (String[])param;
        }
        return null;
    }

    private void createAddMarkerCommand(List<IPart> targets, List<Command> cmds, String ... markerIds) {
        for (IPart source : targets) {
            Object m = MindMapUtils.getRealModel(source);
            if (!(m instanceof ITopic)) continue;
            ITopic t = (ITopic)m;
            String[] stringArray = markerIds;
            int n = markerIds.length;
            int n2 = 0;
            while (n2 < n) {
                String markerId = stringArray[n2];
                this.createAddMarkerCommand(t, markerId, cmds);
                ++n2;
            }
        }
    }

    private void createAddMarkerCommand(ITopic topic, String newMarkerId, List<Command> cmds) {
        if (topic.hasMarker(newMarkerId)) {
            return;
        }
        IMarker marker = this.findMarker(topic, newMarkerId);
        if (marker != null) {
            ICloneData cloneData;
            Object cloned;
            IMarkerSheet markerSheet;
            IMarker existingMarker;
            IMarkerGroup group = marker.getParent();
            IMarkerSheet sheet = marker.getOwnedSheet();
            if (!(sheet.isPermanent() || (existingMarker = (markerSheet = topic.getOwnedWorkbook().getMarkerSheet()).findMarker(marker.getId())) != null && markerSheet.equals(existingMarker.getOwnedSheet()) || !((cloned = (cloneData = topic.getOwnedWorkbook().clone((Collection)Arrays.asList(marker))).get((Object)marker)) instanceof IMarker))) {
                marker = (IMarker)cloned;
                group = marker.getParent();
                newMarkerId = marker.getId();
            }
            if (group != null && group.isSingleton()) {
                this.removeSingletonMarkers(topic, newMarkerId, group, cmds);
            }
            cmds.add((Command)new AddMarkerCommand(topic, newMarkerId));
        }
    }

    private IMarker findMarker(ITopic topic, String markerId) {
        IMarkerSheet markerSheet;
        IWorkbook workbook = topic.getOwnedWorkbook();
        if (workbook != null && (markerSheet = workbook.getMarkerSheet()) != null) {
            return markerSheet.findMarker(markerId);
        }
        return null;
    }

    private void removeSingletonMarkers(ITopic topic, String newMarkerId, IMarkerGroup group, List<Command> cmds) {
        for (IMarker m : group.getMarkers()) {
            String markerId = m.getId();
            if (newMarkerId.equals(markerId) || !topic.hasMarker(markerId)) continue;
            cmds.add((Command)new DeleteMarkerCommand(topic, markerId));
        }
    }

    private void addImage(Request request) {
        List<ITopic> topics = MindMapUtils.getTopics(request.getTargets());
        if (topics.isEmpty()) {
            return;
        }
        Command command = this.createAddImageCommand(request, topics);
        if (command != null) {
            command.setLabel(CommandMessages.Command_InsertImage);
            this.saveAndRun(command, request.getTargetDomain());
            if (command instanceof ISourceProvider) {
                this.select(((ISourceProvider)command).getSources(), request.getTargetViewer());
            }
        }
    }

    private Command createAddImageCommand(Request request, final List<ITopic> topics) {
        String[] paths = this.getPaths(request);
        if (paths == null || paths.length == 0) {
            return null;
        }
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return null;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return null;
        }
        final IWorkbook workbook = sheet.getOwnedWorkbook();
        final String path = paths[0];
        final ArrayList cmds = new ArrayList(paths.length);
        String errMsg = NLS.bind((String)"Failed to copy file into this workbook: {0}", (Object)path);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMsg){

            public void run() throws Exception {
                Command cmd = TopicCreatablePolicy.this.createAddImageCommand(workbook, path, topics);
                if (cmd != null) {
                    cmds.add(cmd);
                }
            }
        });
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createAddImageCommand(IWorkbook workbook, String path, List<ITopic> topics) throws Exception {
        Dimension size = this.getImageSize(path);
        ImageFormat format = ImageFormat.findByExtension((String)FileUtils.getExtension((String)path), (ImageFormat)ImageFormat.PNG);
        IFileEntry e = workbook.getManifest().createAttachmentFromFilePath(path, format.getMediaType());
        if (e == null) {
            return null;
        }
        String hyperlink = HyperlinkUtils.toAttachmentURL((String)e.getPath());
        ArrayList<Command> cmds = new ArrayList<Command>(topics.size());
        for (ITopic t : topics) {
            Command cmd = this.createAddImageCommand(t, hyperlink, size);
            if (cmd == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Dimension getImageSize(String path) {
        try {
            Image tempImage = new Image((Device)Display.getCurrent(), path);
            Rectangle size = tempImage.getBounds();
            tempImage.dispose();
            return Geometry.getScaledConstrainedSize((int)size.width, (int)size.height, (int)400, (int)400);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Command createAddImageCommand(ITopic t, String hyperlink, Dimension size) {
        ModifyImageSourceCommand modifyImageSource = new ModifyImageSourceCommand(t, hyperlink);
        if (size != null) {
            ModifyImageSizeCommand modifySize = new ModifyImageSizeCommand(t, size.width, size.height);
            return new CompoundCommand(new Command[]{modifyImageSource, modifySize});
        }
        return new CompoundCommand(new Command[]{modifyImageSource});
    }

    private void addAttachments(Request request) {
        String[] paths = this.getPaths(request);
        if (paths == null || paths.length == 0) {
            return;
        }
        List<ITopic> topics = MindMapUtils.getTopics(request.getTargets());
        if (topics.isEmpty()) {
            return;
        }
        Command cmd = this.createAddAttachmentCommand(request, topics, paths);
        if (cmd != null) {
            cmd.setLabel(CommandMessages.Command_InsertAttachment);
            this.saveAndRun(cmd, request.getTargetDomain());
            if (cmd instanceof ISourceProvider) {
                this.select(((ISourceProvider)cmd).getSources(), request.getTargetViewer());
            }
        }
    }

    private Command createAddAttachmentCommand(Request request, final List<ITopic> topics, String[] paths) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return null;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return null;
        }
        final IWorkbook workbook = sheet.getOwnedWorkbook();
        final ArrayList cmds = new ArrayList(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            final String path = stringArray[n2];
            String errMsg = NLS.bind((String)"Failed to copy file into this workbook: {0}", (Object)path);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(errMsg){

                public void run() throws Exception {
                    Command cmd = TopicCreatablePolicy.this.createAddAttachmentCommand(workbook, path, topics);
                    if (cmd != null) {
                        cmds.add(cmd);
                    }
                }
            });
            ++n2;
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createAddAttachmentCommand(IWorkbook workbook, String path, List<ITopic> topics) throws IOException {
        IFileEntry e = workbook.getManifest().createAttachmentFromFilePath(path);
        if (e == null) {
            return null;
        }
        String hyperlink = HyperlinkUtils.toAttachmentURL((String)e.getPath());
        String title = new File(path).getName();
        ArrayList<Command> cmds = new ArrayList<Command>(topics.size());
        for (ITopic t : topics) {
            Command cmd = this.createAddAttachmentCommand(t, title, hyperlink);
            if (cmd == null) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        return new CompoundCommand(cmds);
    }

    private Command createAddAttachmentCommand(ITopic parent, String title, String hyperlink) {
        CreateTopicCommand create = new CreateTopicCommand(parent.getOwnedWorkbook());
        AddTopicCommand insert = new AddTopicCommand((ISourceProvider)create, parent, -1, "attached");
        ModifyTitleTextCommand setTitle = new ModifyTitleTextCommand((ISourceProvider)create, title);
        ModifyTopicHyperlinkCommand setHyperlink = new ModifyTopicHyperlinkCommand((ISourceProvider)create, hyperlink);
        return new CompoundCommand(new Command[]{create, insert, setTitle, setHyperlink});
    }

    private String[] getPaths(Request request) {
        Object param = request.getParameter("paths");
        if (param instanceof String) {
            return new String[]{(String)param};
        }
        if (param instanceof String[]) {
            return (String[])param;
        }
        return null;
    }

    private void createTopic(Request request) {
        Object creation;
        IBranchPart parentBranch;
        IPart parentPart;
        IViewer viewer;
        CreateTopicCommandBuilder builder;
        IPart source = request.getPrimaryTarget();
        IBranchPart sourceBranch = MindMapUtils.findBranch(source);
        if (sourceBranch == null) {
            return;
        }
        ITopic sourceTopic = sourceBranch.getTopic();
        String reqType = request.getType();
        if ("create".equals(reqType)) {
            if ("summary".equals(sourceTopic.getType())) {
                return;
            }
            if (sourceBranch.isCentral()) {
                reqType = "create child";
            }
        } else if ("create before".equals(reqType) ? "summary".equals(sourceTopic.getType()) : "create parent".equals(reqType) && sourceBranch.isCentral()) {
            return;
        }
        if (!(builder = new CreateTopicCommandBuilder(viewer = request.getTargetViewer(), request.getTargetCommandStack(), sourceTopic, reqType)).canStart()) {
            return;
        }
        if ("attached".equals(builder.getTargetType()) && (parentPart = viewer.findPart((Object)builder.getTargetParent())) instanceof ITopicPart && (parentBranch = ((ITopicPart)parentPart).getOwnerBranch()) != null) {
            IBranchPart sourceChild = parentBranch.getSubBranches().contains(sourceBranch) ? sourceBranch : null;
            IStructure structure = parentBranch.getBranchPolicy().getStructure(parentBranch);
            if (structure instanceof ICreatableBranchStructureExtension) {
                ((ICreatableBranchStructureExtension)structure).decorateCreateRequest(parentBranch, sourceChild, request);
            }
        }
        PropertyCommandBuilder builder2 = new PropertyCommandBuilder(viewer, builder, request);
        builder.setLabel(CommandMessages.Command_CreateTopic);
        builder.start();
        builder2.start();
        builder.createTopic();
        if (builder.getCreatedTopic() != null) {
            builder2.addSource(builder.getCreatedTopic(), true);
        }
        builder2.end();
        builder.end();
        CompoundCommand command = builder.getCommand();
        if (command instanceof ISourceProvider && (creation = ((ISourceProvider)command).getSource()) != null) {
            this.select(creation, request.getTargetViewer());
            if (this.isAnimationRequired(request)) {
                this.animateCommand((Command)command, request.getTargetViewer());
            }
        }
    }

    @Override
    protected void doAnimateCommand(Command cmd, IAnimationService anim, IViewer viewer) {
        IMinimizable min;
        Object source = ((ISourceProvider)cmd).getSource();
        if (source != null && (min = this.getMinimizable(source, viewer)) != null) {
            min.setMinimized(true);
            ((IGraphicalViewer)viewer).getCanvas().getLightweightSystem().getUpdateManager().performValidation();
        }
        super.doAnimateCommand(cmd, anim, viewer);
    }

    @Override
    protected void createAnimation(Command cmd, IViewer viewer) {
        Object source = ((ISourceProvider)cmd).getSource();
        IMinimizable min = this.getMinimizable(source, viewer);
        if (min != null) {
            min.setMinimized(false);
        }
    }

    private IMinimizable getMinimizable(Object o, IViewer viewer) {
        IFigure figure;
        IPart part = viewer.findPart(o);
        if (part instanceof IGraphicalPart && (figure = ((IGraphicalPart)part).getFigure()) instanceof IMinimizable) {
            return (IMinimizable)figure;
        }
        return null;
    }
}

