/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.AlignmentSolver;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.IBoundsProvider;
import org.xmind.gef.draw2d.geometry.IPositionSolver;
import org.xmind.gef.draw2d.geometry.SplitIntersectionSolver;
import org.xmind.gef.policy.GraphicalPartBoundsProvider;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicAlignmentSolver
extends AlignmentSolver {
    private IPositionSolver intersectionSolver = null;
    private Collection<Object> refKeys = null;

    public TopicAlignmentSolver(int alignmentHint) {
        super(alignmentHint);
        this.setDefaultBoundsProvider((IBoundsProvider)GraphicalPartBoundsProvider.getDefault());
    }

    public void recordInitPositions(List<ITopicPart> topics) {
        HashSet<Object> steadyTopics = null;
        HashSet<Object> freeTopics = null;
        HashSet<Object> floatingTopics = null;
        for (ITopicPart topic : topics) {
            String category;
            boolean floating;
            IBranchPart branch = topic.getOwnerBranch();
            boolean bl = floating = branch.getParentBranch() == null && !branch.isCentral();
            if (floating || MindMapUtils.isBranchFree(branch)) {
                category = "free";
                if (floating) {
                    if (steadyTopics == null && freeTopics == null) {
                        if (floatingTopics == null) {
                            floatingTopics = new HashSet<Object>();
                        }
                        floatingTopics.add(topic);
                    }
                } else if (steadyTopics == null) {
                    if (freeTopics == null) {
                        freeTopics = new HashSet<Object>();
                        floatingTopics = null;
                    }
                    freeTopics.add(topic);
                }
            } else {
                category = "steady";
                if (steadyTopics == null) {
                    steadyTopics = new HashSet<Object>();
                    floatingTopics = null;
                    freeTopics = null;
                }
                steadyTopics.add(topic);
            }
            this.refKeys = steadyTopics != null ? steadyTopics : (freeTopics != null ? freeTopics : (floatingTopics != null ? floatingTopics : null));
            this.recordInitPosition(topic, ((IReferencedFigure)topic.getFigure()).getReference(), category, false);
        }
    }

    public void setAlignmentHint(int alignmentHint) {
        super.setAlignmentHint(alignmentHint);
        if (this.intersectionSolver instanceof SplitIntersectionSolver) {
            ((SplitIntersectionSolver)this.intersectionSolver).setHorizontal(!this.isHorizontal());
        }
    }

    public void clear() {
        super.clear();
        this.refKeys = null;
    }

    public void solve() {
        super.solve();
        if (!MindMapUI.isOverlapsAllowed()) {
            if (this.intersectionSolver == null) {
                this.intersectionSolver = new SplitIntersectionSolver(!this.isHorizontal());
                this.intersectionSolver.setDefaultBoundsProvider((IBoundsProvider)GraphicalPartBoundsProvider.getDefault());
            }
            this.intersectionSolver.setOrigin(this.calcIntersectionOrigin());
            for (String category : this.getCategories()) {
                for (Object key : this.getKeys(category)) {
                    ITopicPart topicPart = (ITopicPart)key;
                    IBranchPart branch = topicPart.getOwnerBranch();
                    this.intersectionSolver.recordInitPosition((Object)branch, this.getSolvedPosition(key), category, true);
                }
            }
            this.intersectionSolver.solve();
            this.intersectionSolver.clear();
        }
    }

    private Point calcIntersectionOrigin() {
        Rectangle r = null;
        for (Object key : this.getKeys()) {
            r = Geometry.union(r, (Rectangle)this.getSolvedBounds(key));
        }
        if (r != null) {
            return r.getCenter();
        }
        return this.getOrigin();
    }

    protected Collection<Object> getReferenceKeys() {
        if (this.refKeys != null) {
            return this.refKeys;
        }
        return super.getReferenceKeys();
    }
}

