/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.IBranchPart;

public class PositionSearcher {
    private IBranchPart sourceBranch;
    private boolean upLeft;
    private boolean horizontal;
    private Rectangle sourceBounds = null;
    private Point sourceCenter = null;
    private Dimension minDiff = null;
    private IPart result = null;

    public PositionSearcher(IBranchPart sourceBranch, String navType) {
        this.sourceBranch = sourceBranch;
        this.upLeft = "navigate up".equals(navType) || "navigate left".equals(navType);
        this.horizontal = "navigate left".equals(navType) || "navigate right".equals(navType);
    }

    public IPart search() {
        this.minDiff = null;
        this.result = null;
        this.sourceBounds = null;
        this.sourceCenter = null;
        this.search((IPart)this.sourceBranch.getSite().getRoot());
        return this.result;
    }

    private void search(IPart context) {
        if (context instanceof IBranchPart) {
            this.searchBranch((IBranchPart)context);
            return;
        }
        for (IPart child : context.getChildren()) {
            this.search(child);
        }
    }

    private void searchBranch(IBranchPart branch) {
        this.checkBranch(branch);
        if (branch.canSearchChild()) {
            for (IBranchPart sub : branch.getSubBranches()) {
                this.searchBranch(sub);
            }
            for (IBranchPart sum : branch.getSummaryBranches()) {
                this.searchBranch(sum);
            }
        }
    }

    private void checkBranch(IBranchPart branch) {
        int dx;
        int dy;
        if (this.sourceBounds == null) {
            this.sourceBounds = this.getBounds(this.sourceBranch);
        }
        if (this.sourceCenter == null) {
            this.sourceCenter = this.sourceBounds.getCenter();
        }
        Rectangle bounds = this.getBounds(branch);
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        if (this.horizontal) {
            if (this.upLeft && x >= this.sourceBounds.x || !this.upLeft && x <= this.sourceBounds.right()) {
                return;
            }
            dy = Math.abs(this.sourceCenter.y - y);
            dx = Math.abs(this.sourceBounds.x - x);
        } else {
            if (this.upLeft && y >= this.sourceBounds.y || !this.upLeft && y <= this.sourceBounds.bottom()) {
                return;
            }
            dx = Math.abs(this.sourceCenter.x - x);
            dy = Math.abs(this.sourceBounds.y - y);
        }
        if (this.minDiff == null) {
            this.minDiff = new Dimension(dx, dy);
            this.result = branch.getTopicPart();
            return;
        }
        if (this.horizontal) {
            if (dy > this.minDiff.height) {
                return;
            }
            if (dy == this.minDiff.height ? dx >= this.minDiff.width : dx >= this.minDiff.width && dx - this.minDiff.width >= this.minDiff.height - dy) {
                return;
            }
        } else {
            if (dx > this.minDiff.width) {
                return;
            }
            if (dx == this.minDiff.width ? dy >= this.minDiff.height : dy >= this.minDiff.height && dy - this.minDiff.height >= this.minDiff.width - dx) {
                return;
            }
        }
        this.minDiff.width = dx;
        this.minDiff.height = dy;
        this.result = branch.getTopicPart();
    }

    private Rectangle getBounds(IBranchPart branch) {
        return branch.getTopicPart().getFigure().getBounds();
    }
}

