/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.core.ITopic;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyFoldedCommand;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "extend".equals(requestType) || "extend all".equals(requestType) || "collapse".equals(requestType) || "collapse all".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("extend".equals(type) || "extend all".equals(type) || "collapse".equals(type) || "collapse all".equals(type)) {
            this.performExtendOrCollapse(request);
        }
    }

    private void performExtendOrCollapse(Request req) {
        String type = req.getType();
        Command cmd = null;
        if ("extend".equals(type)) {
            cmd = this.createModifyFoldedCommand(req, false, false);
        } else if ("collapse".equals(type)) {
            cmd = this.createModifyFoldedCommand(req, true, false);
        } else if ("extend all".equals(type)) {
            cmd = this.createModifyFoldedCommand(req, false, true);
        } else if ("collapse all".equals(type)) {
            cmd = this.createModifyFoldedCommand(req, true, true);
        }
        if (cmd != null) {
            boolean animated;
            boolean bl = animated = this.isAnimationRequired(req) && this.animateCommand(cmd, req.getTargetViewer());
            if (!animated) {
                this.saveAndRun(cmd, req.getTargetDomain());
            }
        }
    }

    private Command createModifyFoldedCommand(Request req, boolean newFolded, boolean deeply) {
        List<IPart> parts = this.getAllFoldableParts(req.getTargetViewer(), req.getTargets(), deeply);
        List<ITopic> topics = MindMapUtils.getTopics(parts);
        ModifyFoldedCommand command = new ModifyFoldedCommand(topics, newFolded);
        command.setLabel(this.getFoldCommandLabel(newFolded, deeply));
        return command;
    }

    private String getFoldCommandLabel(boolean newFolded, boolean deeply) {
        if (newFolded) {
            return deeply ? CommandMessages.Command_CollapseAll : CommandMessages.Command_Collapse;
        }
        return deeply ? CommandMessages.Command_ExtendAll : CommandMessages.Command_Extend;
    }

    protected List<IPart> getAllFoldableParts(IViewer viewer, List<? extends IPart> parts, boolean deeply) {
        ArrayList<IPart> results = new ArrayList<IPart>(parts.size() * (deeply ? 2 : 1));
        for (IPart iPart : parts) {
            IBranchPart branch = MindMapUtils.findBranch(iPart);
            if (branch == null) continue;
            if (branch.isPropertyModifiable("topicFolded")) {
                results.add((IPart)branch);
            }
            if (!deeply) continue;
            results.addAll(this.getAllFoldableParts(viewer, branch.getSubBranches(), deeply));
            results.addAll(this.getAllFoldableParts(viewer, branch.getSummaryBranches(), deeply));
        }
        return results;
    }

    @Override
    protected void createAnimation(Command cmd, IViewer viewer) {
        super.createAnimation(cmd, viewer);
        if (cmd instanceof ISourceProvider) {
            List sources = ((ISourceProvider)cmd).getSources();
            List<IPart> parts = MindMapUtils.getParts(sources, viewer);
            for (IPart p : parts) {
                IBranchPart branch = MindMapUtils.findBranch(p);
                if (branch == null) continue;
                this.showSubBranches(branch);
            }
        }
    }

    private void showSubBranches(IBranchPart branch) {
        IBranchConnections connections = branch.getConnections();
        if (connections != null) {
            connections.setVisible(branch.getFigure(), true);
        }
        for (IBranchPart subBranch : branch.getSubBranches()) {
            this.showSubBranch(subBranch);
        }
        for (IBranchPart summaryBranch : branch.getSummaryBranches()) {
            this.showSubBranch(summaryBranch);
        }
    }

    private void showSubBranch(IBranchPart subBranch) {
        IFigure figure = subBranch.getFigure();
        figure.setVisible(true);
        if (!subBranch.isFolded()) {
            this.showSubBranches(subBranch);
        }
    }

    @Override
    protected Runnable createAfterEffect(final Command cmd, final IViewer viewer) {
        return new Runnable(){

            public void run() {
                List sources = ((ISourceProvider)cmd).getSources();
                List<IPart> parts = MindMapUtils.getParts(sources, viewer);
                for (IPart p : parts) {
                    IBranchPart branch = MindMapUtils.findBranch(p);
                    if (branch == null) continue;
                    branch.treeUpdate(true);
                }
            }
        };
    }
}

