/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.Collection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.IBoundary;
import org.xmind.core.IPositioned;
import org.xmind.core.IRange;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.DeleteBoundaryCommand;
import org.xmind.ui.commands.DeleteTopicCommand;
import org.xmind.ui.commands.ModifyFoldedCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTopicCommandBuilder
extends CommandBuilder {
    private ITopic sourceTopic;
    private String createType;
    private ITopic targetParent;
    private String targetType;
    private int targetIndex;
    private int sourceIndex;
    private ITopic createdTopic = null;

    public CreateTopicCommandBuilder(IViewer viewer, CommandBuilder delegate, ITopic sourceTopic, String createType) {
        super(viewer, delegate);
        this.init(sourceTopic, createType);
    }

    public CreateTopicCommandBuilder(IViewer viewer, ICommandStack commandStack, ITopic sourceTopic, String createType) {
        super(viewer, commandStack);
        this.init(sourceTopic, createType);
    }

    private void init(ITopic sourceTopic, String createType) {
        this.sourceTopic = sourceTopic;
        this.createType = createType;
        this.sourceIndex = sourceTopic.getIndex();
        if ("create child".equals(createType)) {
            this.targetParent = sourceTopic;
            this.targetType = "attached";
            this.targetIndex = this.targetParent.getChildren(this.targetType).size();
        } else {
            this.targetParent = sourceTopic.getParent();
            if (this.targetParent != null) {
                if ("create".equals(createType)) {
                    this.targetIndex = sourceTopic.getIndex() + 1;
                    this.targetType = sourceTopic.getType();
                } else if ("create before".equals(createType) || "create parent".equals(createType)) {
                    this.targetIndex = sourceTopic.getIndex();
                    this.targetType = sourceTopic.getType();
                } else {
                    this.targetIndex = -1;
                    this.targetType = null;
                }
            } else {
                this.targetIndex = -1;
                this.targetType = null;
            }
        }
    }

    public ITopic getCreatedTopic() {
        return this.createdTopic;
    }

    public String getCreateType() {
        return this.createType;
    }

    public ITopic getSourceTopic() {
        return this.sourceTopic;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public ITopic getTargetParent() {
        return this.targetParent;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void createTopic() {
        if (!this.canStart()) {
            return;
        }
        CreateTopicCommand create = new CreateTopicCommand(this.sourceTopic.getOwnedWorkbook());
        this.add((Command)create, true);
        this.createdTopic = (ITopic)create.getSource();
        if (this.createdTopic == null) {
            return;
        }
        this.preAdd();
        this.add((Command)new AddTopicCommand(this.createdTopic, this.targetParent, this.targetIndex, this.targetType), true);
        this.postAdded();
    }

    @Override
    public boolean canStart() {
        return super.canStart() && this.targetParent != null && this.targetType != null;
    }

    private void preAdd() {
        this.ensureParentUnfolded();
        this.setNewTitle();
    }

    private void postAdded() {
        if ("create parent".equals(this.createType)) {
            if ("detached".equals(this.targetType)) {
                this.add((Command)new ModifyPositionCommand((IPositioned)this.createdTopic, this.sourceTopic.getPosition()), false);
                this.add((Command)new ModifyPositionCommand((IPositioned)this.sourceTopic, null), false);
            }
            this.add((Command)new DeleteTopicCommand(this.sourceTopic), false);
            this.add((Command)new AddTopicCommand(this.sourceTopic, this.createdTopic), false);
            this.moveOverallBoundaries(this.sourceTopic, this.createdTopic);
        } else if ("attached".equals(this.targetType) && ("create".equals(this.createType) || "create before".equals(this.createType)) && this.sourceIndex >= 0) {
            this.modifyRanges();
        }
    }

    private void moveOverallBoundaries(ITopic fromTopic, ITopic toTopic) {
        IBoundary overallBoundary = null;
        Object[] objectArray = fromTopic.getBoundaries().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IBoundary boundary = (IBoundary)o;
            if (boundary.isMasterBoundary() && overallBoundary == null) {
                overallBoundary = boundary;
            }
            this.add((Command)new DeleteBoundaryCommand(boundary), false);
            ++n2;
        }
        if (overallBoundary != null && !this.hasOverallBoundaries(toTopic)) {
            this.add((Command)new AddBoundaryCommand(overallBoundary, toTopic), false);
        }
    }

    private boolean hasOverallBoundaries(ITopic topic) {
        for (IBoundary boundary : topic.getBoundaries()) {
            if (!boundary.isMasterBoundary()) continue;
            return true;
        }
        return false;
    }

    private void modifyRanges() {
        this.modifyRanges(this.targetParent.getBoundaries());
        this.modifyRanges(this.targetParent.getSummaries());
    }

    private void modifyRanges(Collection<? extends ITopicRange> ranges) {
        for (ITopicRange iTopicRange : ranges) {
            int startIndex = iTopicRange.getStartIndex();
            int endIndex = iTopicRange.getEndIndex();
            if (startIndex < 0 || endIndex < 0) continue;
            if (startIndex > this.sourceIndex) {
                this.add((Command)new ModifyRangeCommand((IRange)iTopicRange, startIndex + 1, true), false);
            }
            if (endIndex < this.sourceIndex) continue;
            this.add((Command)new ModifyRangeCommand((IRange)iTopicRange, endIndex + 1, false), false);
        }
    }

    private void setNewTitle() {
        this.add((Command)new ModifyTitleTextCommand((ITitled)this.createdTopic, this.getNewTitle()), false);
    }

    private String getNewTitle() {
        if ("detached".equals(this.targetType)) {
            return MindMapMessages.TitleText_FloatingTopic;
        }
        int size = this.targetParent.getChildren(this.targetType).size();
        int newNumber = size + 1;
        if (this.targetParent.isRoot()) {
            return NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)newNumber);
        }
        return NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)newNumber);
    }

    private void ensureParentUnfolded() {
        if (this.targetParent.isFolded()) {
            this.add((Command)new ModifyFoldedCommand(this.targetParent, false), false);
        }
    }

    @Override
    protected void handlePendingCommands() {
        super.handlePendingCommands();
        if ("detached".equals(this.targetType)) {
            if ("create".equals(this.createType)) {
                this.setNewPosition(true);
            } else if ("create before".equals(this.createType)) {
                this.setNewPosition(false);
            }
        }
    }

    private void setNewPosition(boolean lowerOrUpper) {
        Point newPosition = this.calcNewPosition(lowerOrUpper);
        this.add((Command)new ModifyPositionCommand((IPositioned)this.createdTopic, MindMapUtils.toModelPosition(newPosition)), false);
    }

    private Point calcNewPosition(boolean lowerOrUpper) {
        IBranchPart targetBranch;
        IPart targetPart;
        IBranchPart sourceBranch;
        IPart sourcePart = this.getViewer().findPart((Object)this.sourceTopic);
        if (sourcePart != null && sourcePart instanceof ITopicPart && (sourceBranch = ((ITopicPart)sourcePart).getOwnerBranch()) != null && (targetPart = this.getViewer().findPart((Object)this.createdTopic)) != null && targetPart instanceof ITopicPart && (targetBranch = ((ITopicPart)targetPart).getOwnerBranch()) != null) {
            IReferencedFigure sourceFigure = (IReferencedFigure)sourceBranch.getFigure();
            Point sourcePosition = sourceFigure.getReference();
            Insets sourceIns = sourceFigure.getReferenceDescription();
            IReferencedFigure targetFigure = (IReferencedFigure)targetBranch.getFigure();
            Insets targetIns = targetFigure.getReferenceDescription();
            return new Point(sourcePosition.x, sourcePosition.y + sourceIns.bottom + targetIns.top + 10);
        }
        org.xmind.core.util.Point sourcePosition = this.sourceTopic.getPosition();
        if (sourcePosition != null) {
            return new Point(sourcePosition.x, sourcePosition.y + 60);
        }
        return null;
    }
}

