/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.browser.IBrowserViewer;
import org.xmind.ui.browser.IBrowserViewerContribution;
import org.xmind.ui.browser.IBrowserViewerContribution2;
import org.xmind.ui.browser.IPropertyChangingListener;
import org.xmind.ui.browser.PropertyChangingEvent;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.util.Logger;

public class XMindFileBrowserContribution
implements IBrowserViewerContribution,
IBrowserViewerContribution2 {
    private Map<IBrowserViewer, XMindFileListener> map = new HashMap<IBrowserViewer, XMindFileListener>();

    public void fillToolBar(IBrowserViewer viewer, IContributionManager toolBar) {
    }

    public void installBrowserListeners(IBrowserViewer viewer) {
        XMindFileListener listener = new XMindFileListener(viewer);
        this.map.put(viewer, listener);
    }

    public void uninstallBrowserListeners(IBrowserViewer viewer) {
        XMindFileListener listener = this.map.remove(viewer);
        if (listener != null) {
            listener.dispose();
        }
    }

    private static class XMindFileListener
    implements PropertyChangeListener,
    IPropertyChangingListener {
        private IBrowserViewer viewer;

        public XMindFileListener(IBrowserViewer viewer) {
            this.viewer = viewer;
            viewer.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public IBrowserViewer getViewer() {
            return this.viewer;
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }

        public void propertyChanging(PropertyChangingEvent event) {
            if (!"location".equals(event.getPropertyName())) {
                return;
            }
            String location = (String)event.getNewValue();
            if (location == null || "about:blank".equals(location)) {
                return;
            }
            try {
                URI uri = new URI(location);
                String uriPath = uri.getPath();
                if (uriPath != null && uriPath.endsWith(".xmind")) {
                    this.downloadAndOpen(location, FileUtils.getFileName((String)uriPath));
                    event.doit = false;
                }
            }
            catch (Throwable e) {
                Logger.log(e);
            }
        }

        private void downloadAndOpen(String location, String suggestedName) {
            FileDialog dialog = new FileDialog(this.viewer.getControl().getShell(), 8196);
            String ext = "*.xmind";
            dialog.setFilterExtensions(new String[]{ext});
            dialog.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)DialogMessages.WorkbookFilterName, (Object)ext)});
            dialog.setOverwrite(true);
            dialog.setText(DialogMessages.Save_title);
            dialog.setFileName(suggestedName);
            final String path = dialog.open();
            if (path == null) {
                return;
            }
            FileUtils.delete((File)new File(path));
            File file = new File(path);
            file.getParentFile().mkdirs();
            final String tempPath = String.valueOf(path) + ".downloading";
            DownloadJob job = new DownloadJob(file.getName(), location, tempPath);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().getCode() == 0 && XMindFileListener.this.rename(tempPath, path)) {
                        XMindFileListener.this.openFile(path);
                    }
                }
            });
            job.schedule();
        }

        private boolean rename(String tempPath, String path) {
            File tempFile = new File(tempPath);
            if (!tempFile.exists() || !tempFile.canRead()) {
                return false;
            }
            return new File(tempPath).renameTo(new File(path));
        }

        private void openFile(String path) {
            Display display;
            final File file = new File(path);
            if (!file.exists() || !file.canRead()) {
                return;
            }
            final IEditorInput[] input = new IEditorInput[1];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    input[0] = MME.createFileEditorInput(file);
                }
            });
            if (input[0] == null) {
                return;
            }
            final IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (display = workbench.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                            public void run() throws Exception {
                                XMindFileListener.this.openEditor(input[0], workbench);
                            }
                        });
                    }
                });
            }
        }

        private void openEditor(IEditorInput input, IWorkbench workbench) throws Exception {
            IWorkbenchPage page;
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                page.openEditor(input, "org.xmind.ui.MindMapEditor");
            }
        }

        public void dispose() {
            this.viewer.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

