/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.internal.editor.TempWorkbookLoader;
import org.xmind.ui.internal.editor.WorkbookEditorInput;
import org.xmind.ui.internal.editor.WorkbookRef;
import org.xmind.ui.internal.editor.WorkbookRefInitializer;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefManager;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookRefManager
implements IWorkbookRefManager {
    private static final String TAG_OPENED_EDITORS = "editors";
    private static final String TAG_OPENED_EDITOR = "editor";
    private static final String TAG_OPENED_INPUT = "input";
    private static final String ATTR_OPENED_ID = "factoryID";
    private static final String TAG_OPENED_TEMPLOCATION = "tempLocation";
    private static final String ATTR_OPENED_FILE = "path";
    private static final String ATTR_OPENED_TITLE = "title";
    private Map<Object, WorkbookRef> registry = new HashMap<Object, WorkbookRef>();
    private Map<IEditorInput, String> lastSession = null;
    private static WorkbookRefManager instance;
    private Thread autoHibernateThread = null;
    private long autoHibernateIntervals = 60000L;
    private File location = null;

    private WorkbookRefManager() {
    }

    public WorkbookRef addReferrer(Object source, IEditorPart referrer) throws CoreException {
        WorkbookRef ref = this.registry.get(source);
        if (ref != null) {
            ref.addReferrer(referrer);
            return ref;
        }
        ref = this.createWorkbookRef(source, referrer);
        ref.addReferrer(referrer);
        this.ensureAutoHibernateStarted();
        return ref;
    }

    private WorkbookRef createWorkbookRef(Object source, IEditorPart referrer) throws CoreException {
        String tempLocation;
        WorkbookRef ref = new WorkbookRef();
        WorkbookRefInitializer.getInstance().initialize(ref, source, referrer);
        if (!ref.isReady()) {
            Status status = new Status(4, "org.xmind.ui.mindmap", "Failed to create a workbook reference with valid source.");
            throw new CoreException((IStatus)status);
        }
        this.initializeRef(ref, source);
        if (this.lastSession != null && (tempLocation = this.lastSession.get(source)) != null) {
            ref.setWorkbookLoader(new TempWorkbookLoader(ref, tempLocation));
        }
        this.registry.put(source, ref);
        return ref;
    }

    private void initializeRef(WorkbookRef ref, Object source) throws CoreException {
        if (ref.getCommandStack() == null) {
            ref.setCommandStack((ICommandStack)new CommandStack());
        }
        if (ref.getKey() == null) {
            ref.setKey(source);
        }
    }

    public void removeReferrer(Object source, IEditorPart referrer) {
        block8: {
            WorkbookRef ref = this.registry.get(source);
            try {
                if (ref == null) break block8;
                try {
                    ref.removeReferrer(referrer);
                }
                catch (Throwable throwable) {
                    if (!ref.isReferred()) {
                        this.registry.remove(source);
                        boolean noRelatedRef = this.findRef(ref.getWorkbook()) == null;
                        ref.dispose(noRelatedRef);
                    }
                    throw throwable;
                }
                if (!ref.isReferred()) {
                    this.registry.remove(source);
                    boolean noRelatedRef = this.findRef(ref.getWorkbook()) == null;
                    ref.dispose(noRelatedRef);
                }
            }
            finally {
                if (this.registry.isEmpty()) {
                    this.stopAutoHibernate();
                }
            }
        }
    }

    @Override
    public IWorkbookRef createRef(IEditorInput editorInput, IEditorPart editor) {
        try {
            return this.addReferrer(editorInput, editor);
        }
        catch (CoreException e) {
            Logger.log(e);
            return null;
        }
    }

    @Override
    public void disposeRef(IEditorInput editorInput, IEditorPart editor) {
        this.removeReferrer(editorInput, editor);
    }

    @Override
    public IWorkbookRef findRef(IWorkbook workbook) {
        if (workbook == null) {
            return null;
        }
        for (IWorkbookRef iWorkbookRef : this.registry.values()) {
            if (!workbook.equals(iWorkbookRef.getWorkbook())) continue;
            return iWorkbookRef;
        }
        return null;
    }

    public static WorkbookRefManager getInstance() {
        if (instance == null) {
            instance = new WorkbookRefManager();
        }
        return instance;
    }

    public void changeKey(Object oldKey, Object newKey, Object referrer) throws CoreException {
        WorkbookRef ref = this.registry.remove(oldKey);
        if (ref == null) {
            return;
        }
        ref.setKey(newKey);
        this.registry.put(newKey, ref);
        ref.setWorkbookLoader(null).setWorkbookSaver(null);
        WorkbookRefInitializer.getInstance().initialize(ref, newKey, referrer);
    }

    public long getAutoHibernateIntervals() {
        return this.autoHibernateIntervals;
    }

    public void setAutoHibernateIntervals(long autoHibernateIntervals) {
        this.autoHibernateIntervals = autoHibernateIntervals;
    }

    private void ensureAutoHibernateStarted() {
        if (this.autoHibernateThread != null) {
            return;
        }
        this.autoHibernateThread = new Thread(new AutoHibernateJob());
        this.autoHibernateThread.setDaemon(true);
        this.autoHibernateThread.setName("XMind: Auto Save Temporary Workbooks");
        this.autoHibernateThread.setPriority(1);
        this.autoHibernateThread.start();
    }

    private void hibernateAll() {
        if (this.registry.isEmpty()) {
            this.stopAutoHibernate();
            return;
        }
        XMLMemento memento = null;
        for (Map.Entry<Object, WorkbookRef> en : this.registry.entrySet()) {
            Object key;
            WorkbookRef ref = en.getValue();
            IWorkbook workbook = ref.getWorkbook();
            if (workbook != null) {
                try {
                    workbook.saveTemp();
                }
                catch (Throwable throwable) {}
            }
            if (!((key = en.getKey()) instanceof IEditorInput)) continue;
            if (memento == null) {
                memento = XMLMemento.createWriteRoot((String)TAG_OPENED_EDITORS);
            }
            this.saveMemento(memento, (IEditorInput)key, workbook.getTempLocation());
        }
        if (this.location == null) {
            this.location = new File(Core.getWorkspace().getTempFile(".opened"));
        }
        if (memento != null) {
            try {
                memento.save((Writer)new OutputStreamWriter(new FileOutputStream(this.location)));
            }
            catch (IOException e) {
                Logger.log(e, "Failed to save session log.");
            }
        } else {
            this.location.delete();
        }
    }

    private void saveMemento(XMLMemento memento, IEditorInput input, String path) {
        IMemento editorMem = memento.createChild(TAG_OPENED_EDITOR);
        IMemento inputMem = editorMem.createChild(TAG_OPENED_INPUT);
        IPersistableElement p = input.getPersistable();
        if (p != null) {
            p.saveState(inputMem);
            String id = p.getFactoryId();
            inputMem.putString(ATTR_OPENED_ID, id);
        } else {
            inputMem.putString(ATTR_OPENED_TITLE, input.getName());
        }
        IMemento pathMem = editorMem.createChild(TAG_OPENED_TEMPLOCATION);
        pathMem.putString(ATTR_OPENED_FILE, path);
    }

    private void stopAutoHibernate() {
        if (this.autoHibernateThread != null) {
            this.autoHibernateThread.interrupt();
        }
        this.autoHibernateThread = null;
    }

    public List<IEditorInput> loadLastSession() {
        File file = new File(Core.getWorkspace().getTempFile(".opened"));
        if (!file.exists()) {
            return null;
        }
        this.lastSession = null;
        return this.loadSessionFromFile(file);
    }

    /*
     * Loose catch block
     */
    private List<IEditorInput> loadSessionFromFile(File file) {
        IMemento[] elements;
        ArrayList<IEditorInput> list = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream(file));
        }
        catch (Exception e1) {
            Logger.log(e1, "Failed to read file");
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] iMementoArray = elements = memento.getChildren(TAG_OPENED_EDITOR);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento editorMem = iMementoArray[n2];
            IMemento inputMem = editorMem.getChild(TAG_OPENED_INPUT);
            IEditorInput input = null;
            if (inputMem != null) {
                String factoryId = inputMem.getString(ATTR_OPENED_ID);
                if (factoryId != null) {
                    IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryId);
                    input = (IEditorInput)factory.createElement(inputMem);
                } else {
                    String title = inputMem.getString(ATTR_OPENED_TITLE);
                    input = new WorkbookEditorInput(title);
                }
                IMemento tempMem = editorMem.getChild(TAG_OPENED_TEMPLOCATION);
                String path = tempMem.getString(ATTR_OPENED_FILE);
                if (this.lastSession == null) {
                    this.lastSession = new HashMap<IEditorInput, String>();
                }
                this.lastSession.put(input, path);
                if (list == null) {
                    list = new ArrayList<IEditorInput>();
                }
                list.add(input);
            }
            ++n2;
        }
        ArrayList<IEditorInput> arrayList = list;
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return arrayList;
        catch (Exception e) {
            try {
                Logger.log(e, "Failed to load session log.");
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public void clearLastSession() {
        this.lastSession = null;
    }

    private class AutoHibernateJob
    implements Runnable {
        private AutoHibernateJob() {
        }

        public void run() {
            try {
                Thread.sleep(WorkbookRefManager.this.getAutoHibernateIntervals());
            }
            catch (InterruptedException interruptedException) {}
            while (WorkbookRefManager.this.autoHibernateThread == Thread.currentThread()) {
                WorkbookRefManager.this.hibernateAll();
                if (WorkbookRefManager.this.autoHibernateThread != Thread.currentThread()) break;
                try {
                    Thread.sleep(WorkbookRefManager.this.getAutoHibernateIntervals());
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

