/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IMiniBar;
import org.xmind.gef.ui.editor.MiniBarContributor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.VisibleSeparator;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.SliderViewer;

public class MindMapMiniBarContributor
extends MiniBarContributor
implements IZoomListener {
    public static final String VALUE = "value";
    public static final String ACTIVE_PAGE = "activePage";
    protected static final int SLIDER_WIDTH = 88;
    public static final int PREF_HEIGHT = 12;
    private ZoomManager zoomManager = null;
    private ZoomValueItem zoomValueItem;
    private ZoomSliderItem zoomSliderItem;
    private MiniZoomInAction zoomInAction;
    private MiniZoomOutAction zoomOutAction;
    private MiniActualSizeAction actualSizeAction;

    public void init(IMiniBar bar) {
        this.zoomValueItem = new ZoomValueItem();
        this.zoomSliderItem = new ZoomSliderItem();
        this.zoomInAction = new MiniZoomInAction(this.getEditor());
        this.zoomOutAction = new MiniZoomOutAction(this.getEditor());
        this.actualSizeAction = new MiniActualSizeAction(this.getEditor());
        super.init(bar);
    }

    public void contributeToToolBar(IToolBarManager toolBar) {
        super.contributeToToolBar(toolBar);
        toolBar.add((IContributionItem)new GroupMarker("additions"));
        toolBar.add((IContributionItem)new GroupMarker("org.xmind.ui.group.zoom"));
        toolBar.add((IContributionItem)new VisibleSeparator());
        this.add((IContributionManager)toolBar, (IContributionItem)this.zoomValueItem);
        toolBar.add((IContributionItem)new Separator());
        this.add((IContributionManager)toolBar, (IAction)this.zoomOutAction);
        toolBar.add((IContributionItem)this.zoomSliderItem);
        this.add((IContributionManager)toolBar, (IAction)this.zoomInAction);
        this.add((IContributionManager)toolBar, (IAction)this.actualSizeAction);
    }

    protected void add(IContributionManager manager, IAction action) {
        if (manager == null || action == null) {
            return;
        }
        manager.add(action);
    }

    protected void add(IContributionManager manager, IContributionItem item) {
        if (manager == null || item == null) {
            return;
        }
        manager.add(item);
    }

    public void dispose() {
        super.dispose();
        this.zoomValueItem = null;
        this.zoomSliderItem = null;
        if (this.zoomInAction != null) {
            this.zoomInAction.dispose();
            this.zoomInAction = null;
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.dispose();
            this.zoomOutAction = null;
        }
        if (this.actualSizeAction != null) {
            this.actualSizeAction.dispose();
            this.actualSizeAction = null;
        }
    }

    protected void updateZoomContributionItems() {
        this.update((IContributionItem)this.zoomValueItem);
        this.update((IContributionItem)this.zoomSliderItem);
    }

    protected void update(IContributionItem item) {
        if (item != null) {
            item.update();
        }
    }

    protected void pageChanged(IGraphicalEditorPage page) {
        super.pageChanged(page);
        this.setZoomManager(this.getZoomManager(page));
    }

    private ZoomManager getZoomManager(IGraphicalEditorPage page) {
        if (page == null) {
            return null;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getZoomManager();
    }

    protected void setZoomManager(ZoomManager zoomManager) {
        if (zoomManager == this.zoomManager) {
            return;
        }
        if (this.zoomManager != null) {
            this.unhookZoomManager(this.zoomManager);
        }
        this.zoomManager = zoomManager;
        if (zoomManager != null) {
            this.hookZoomManager(zoomManager);
        }
        this.updateZoomContributionItems();
    }

    protected void hookZoomManager(ZoomManager zoomManager) {
        zoomManager.addZoomListener((IZoomListener)this);
    }

    protected void unhookZoomManager(ZoomManager zoomManager) {
        zoomManager.removeZoomListener((IZoomListener)this);
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.updateZoomContributionItems();
    }

    private static class MiniActualSizeAction
    extends EditorAction {
        public MiniActualSizeAction(IGraphicalEditor editor) {
            super(editor);
            this.setToolTipText(MindMapMessages.ActualSize_text);
            this.setImageDescriptor(MindMapUI.getImages().get("actualsize_small.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("actualsize_small.gif", false));
        }

        public void run() {
            if (this.isDisposed()) {
                return;
            }
            this.performRequest("actual size");
        }
    }

    private static class MiniZoomInAction
    extends EditorAction {
        public MiniZoomInAction(IGraphicalEditor editor) {
            super(editor);
            this.setToolTipText(MindMapMessages.ZoomIn_text);
            this.setImageDescriptor(MindMapUI.getImages().get("zoomin_small.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("zoomin_small.gif", false));
        }

        public void run() {
            if (this.isDisposed()) {
                return;
            }
            this.performRequest("zoom in");
        }
    }

    private static class MiniZoomOutAction
    extends EditorAction {
        public MiniZoomOutAction(IGraphicalEditor editor) {
            super(editor);
            this.setToolTipText(MindMapMessages.ZoomOut_text);
            this.setImageDescriptor(MindMapUI.getImages().get("zoomout_small.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("zoomout_small.gif", false));
        }

        public void run() {
            if (this.isDisposed()) {
                return;
            }
            this.performRequest("zoom out");
        }
    }

    private class ZoomSliderItem
    extends ContributionItem
    implements ISelectionChangedListener,
    IOpenListener {
        private SliderViewer slider;
        private boolean updating = false;
        private boolean sendingRequest = false;
        private IContentProvider contentProvider = new ZoomSliderContentProvider();
        private IBaseLabelProvider labelProvider = new ZoomSliderLabelProvider();

        private ZoomSliderItem() {
        }

        public void fill(ToolBar parent, int index) {
            if (this.slider == null || this.slider.getControl().isDisposed()) {
                ToolItem placeHolder = index >= 0 ? new ToolItem(parent, 2, index) : new ToolItem(parent, 2);
                this.slider = new SliderViewer((Composite)parent, 256);
                this.slider.setContentProvider(this.contentProvider);
                this.slider.setLabelProvider(this.labelProvider);
                this.slider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.slider.addOpenListener((IOpenListener)this);
                placeHolder.setControl(this.slider.getControl());
                placeHolder.setWidth(88);
                this.update();
            }
        }

        public void update() {
            this.update(null);
        }

        public void update(String id) {
            super.update(id);
            if (this.slider != null && !this.slider.getControl().isDisposed() && !this.sendingRequest) {
                boolean valueChanged;
                boolean zoomObjectChanged = id == null || MindMapMiniBarContributor.ACTIVE_PAGE.equals(id);
                boolean bl = valueChanged = id == null || MindMapMiniBarContributor.VALUE.equals(id);
                if (zoomObjectChanged) {
                    this.slider.setInput((Object)MindMapMiniBarContributor.this.zoomManager);
                    this.slider.getControl().setEnabled(MindMapMiniBarContributor.this.zoomManager != null);
                }
                if (valueChanged) {
                    double value = MindMapMiniBarContributor.this.zoomManager != null ? MindMapMiniBarContributor.this.zoomManager.getScale() : 1.0;
                    this.updating = true;
                    this.slider.setSelection((ISelection)new StructuredSelection((Object)value));
                    this.updating = false;
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            if (this.updating) {
                return;
            }
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) != null && element instanceof Double) {
                EditDomain domain;
                double value = (Double)element;
                IGraphicalEditorPage page = MindMapMiniBarContributor.this.getActivePage();
                if (page != null && (domain = page.getEditDomain()) != null) {
                    this.sendingRequest = true;
                    this.sendZoomRequest(domain, value);
                    this.sendingRequest = false;
                }
            }
        }

        private void sendZoomRequest(EditDomain domain, double value) {
            Request request = new Request("zoom");
            request.setViewer((IViewer)MindMapMiniBarContributor.this.getActivePage().getViewer());
            request.setParameter("zoomScale", (Object)value);
            domain.handleRequest(request);
        }

        public void open(OpenEvent event) {
            EditDomain domain;
            IGraphicalEditorPage page = MindMapMiniBarContributor.this.getActivePage();
            if (page != null && (domain = page.getEditDomain()) != null) {
                this.sendZoomRequest(domain, 1.0);
            }
        }

        private class ZoomSliderContentProvider
        implements ISliderContentProvider {
            private final double center = 1.0;
            private double min = 0.5;
            private double max = 2.0;

            private ZoomSliderContentProvider() {
            }

            public double getPortion(Object input, Object value) {
                if (value instanceof Double) {
                    return this.calcPortion((Double)value);
                }
                return 1.0;
            }

            private double calcPortion(double v) {
                if (v == 1.0) {
                    return 0.5;
                }
                if (v < this.min) {
                    return 0.0;
                }
                if (v > this.max) {
                    return 1.0;
                }
                if (v < 1.0) {
                    double d = 1.0 - this.min;
                    if (d == 0.0) {
                        return this.min;
                    }
                    return (v - this.min) * 0.5 / d;
                }
                double d = this.max - 1.0;
                if (d == 0.0) {
                    return this.max;
                }
                return (v - 1.0) * 0.5 / d + 0.5;
            }

            public Object getValue(Object input, double portion) {
                return this.calcValue(portion);
            }

            private double calcValue(double portion) {
                if (portion > 0.45 && portion < 0.52) {
                    return 1.0;
                }
                if (portion < 0.5) {
                    return (1.0 - this.min) * portion / 0.5 + this.min;
                }
                return (this.max - 1.0) * (portion - 0.5) / 0.5 + 1.0;
            }

            public Object[] getValues(Object input) {
                return new Double[]{this.min, 1.0, this.max};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null && newInput instanceof ZoomManager) {
                    ZoomManager zm = (ZoomManager)newInput;
                    this.min = zm.getMin();
                    this.max = zm.getMax();
                } else {
                    this.min = 0.5;
                    this.max = 2.0;
                }
            }

            public void dispose() {
            }
        }

        private class ZoomSliderLabelProvider
        extends LabelProvider {
            private ZoomSliderLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof Double) {
                    double scale = (Double)element;
                    return String.format("%.0f%%", scale * 100.0);
                }
                return super.getText(element);
            }
        }
    }

    private class ZoomValueItem
    extends ContributionItem {
        private CLabel label;

        private ZoomValueItem() {
        }

        public void fill(ToolBar parent, int index) {
            if (this.label == null || this.label.isDisposed()) {
                ToolItem placeHolder = index >= 0 ? new ToolItem(parent, 2, index) : new ToolItem(parent, 2);
                this.label = new CLabel((Composite)parent, 0);
                this.label.setText("000%");
                placeHolder.setControl((Control)this.label);
                placeHolder.setWidth(this.label.computeSize((int)-1, (int)-1, (boolean)true).x + 10);
                this.label.setText("");
                this.update();
            }
        }

        public void update() {
            super.update();
            this.update(null);
        }

        public void update(String id) {
            super.update(id);
            if (this.label != null && !this.label.isDisposed()) {
                boolean valueChanged;
                boolean bl = valueChanged = id == null || MindMapMiniBarContributor.VALUE.equals(id);
                if (valueChanged) {
                    if (MindMapMiniBarContributor.this.zoomManager != null) {
                        double scale = MindMapMiniBarContributor.this.zoomManager.getScale();
                        int s = (int)Math.round(scale * 100.0);
                        this.label.setText(String.format("%d%%", s));
                    } else {
                        this.label.setText("");
                    }
                }
            }
        }
    }
}

