/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.xmind.core.ITitled;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.findreplace.AbstractFindReplaceOperationProvider;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.texteditor.FloatingTextEditTool;
import org.xmind.ui.texteditor.FloatingTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapFindReplaceOperationProvider
extends AbstractFindReplaceOperationProvider {
    private static int parameter = 20;
    private IGraphicalEditor editor;
    private String cachedToFind = null;
    private IPart tempPart = null;

    public MindMapFindReplaceOperationProvider(IGraphicalEditor editor) {
        this.editor = editor;
    }

    protected IPart getCurrentPart() {
        IPart part;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null && (part = viewer.getFocusedPart()) != null) {
            return part;
        }
        return this.getCurrentCentralTopicPart();
    }

    private IPart getCurrentCentralTopicPart() {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            return (ITopicPart)viewer.getAdapter(ITopicPart.class);
        }
        return null;
    }

    @Override
    public boolean canFind(String toFind) {
        return this.getCurrentPart() != null;
    }

    @Override
    public boolean canReplace(String toFind, String toReplaceWith) {
        return this.canFind(toFind);
    }

    protected void saveCache(String toFind) {
        if (this.cachedToFind == null && this.cachedToFind != toFind || this.cachedToFind != null && !this.cachedToFind.equals(toFind)) {
            this.cachedToFind = toFind;
        }
    }

    @Override
    public boolean find(String toFind) {
        this.saveCache(toFind);
        if (this.cachedToFind == null) {
            return false;
        }
        return super.find(this.cachedToFind);
    }

    @Override
    protected boolean findAll(String toFind) {
        List<IPart> result = this.findAllParts(toFind);
        this.select(result);
        return !result.isEmpty();
    }

    @Override
    protected boolean findNext(String toFind) {
        SearchData current;
        SearchData next;
        int offset = this.getCurrentOffset(this.tempPart);
        if (offset < 0) {
            return false;
        }
        IPart part = this.getCurrentPart();
        if (this.tempPart instanceof ILabelPart) {
            part = this.tempPart;
        }
        if ((next = this.findNext(toFind, current = new SearchData(part, offset))) == null) {
            return false;
        }
        this.startEditing(next.host);
        this.selectText(next, toFind.length());
        this.tempPart = next.host;
        return true;
    }

    @Override
    public boolean replace(String toFind, String toReplaceWith) {
        this.saveCache(toFind);
        if (this.cachedToFind == null) {
            return false;
        }
        return super.replace(toFind, toReplaceWith);
    }

    @Override
    protected boolean replaceAll(String toFind, String toReplaceWith) {
        boolean found = this.findAll(toFind);
        if (found) {
            EditDomain domain = this.getCurrentDomain();
            if (domain == null) {
                found = false;
            } else {
                Boolean ignoreCase = (this.getParameter() & 1) == 0;
                domain.handleRequest(new Request("replace all").setParameter("text", (Object)toFind).setParameter("replacement", (Object)toReplaceWith).setParameter("ignoreCase", (Object)ignoreCase).setDomain(domain).setViewer((IViewer)this.getActiveViewer()));
            }
        }
        return found;
    }

    @Override
    protected boolean replaceNext(String toFind, String toReplaceWith) {
        FloatingTextEditor textEditor;
        IPart part = this.getCurrentPart();
        if (this.tempPart instanceof ILabelPart) {
            part = this.tempPart;
        }
        if ((textEditor = this.getTextEditor(part)) != null && this.canReplace(toFind, textEditor)) {
            StyledText textWidget = textEditor.getTextViewer().getTextWidget();
            Point selection = textWidget.getSelection();
            int caretOffset = this.isForward() ? selection.y : selection.x;
            textWidget.insert(toReplaceWith);
            textWidget.setCaretOffset(caretOffset);
        }
        return this.findNext(toFind);
    }

    private int getCurrentOffset(IPart part) {
        if (this.isEditing(part)) {
            FloatingTextEditor textEditor = this.getTextEditor(part);
            if (textEditor == null) {
                return -1;
            }
            StyledText textWidget = textEditor.getTextViewer().getTextWidget();
            Point selection = textWidget.getSelection();
            int offset = this.isForward() ? selection.y : selection.x;
            ITool editTool = this.getEditTool(part);
            editTool.handleRequest("finish", (IViewer)this.getActiveViewer());
            return offset;
        }
        this.tempPart = null;
        if (this.isForward()) {
            return 0;
        }
        String text = this.getText(this.getCurrentPart());
        return text == null ? -1 : this.getNewOffset(text);
    }

    protected void selectText(SearchData data, int length) {
        FloatingTextEditor textEditor = this.getTextEditor(data.host);
        if (textEditor != null) {
            ITextViewer textViewer = textEditor.getTextViewer();
            StyledText textWidget = textViewer.getTextWidget();
            textWidget.setSelectionRange(data.offset, length);
        }
    }

    protected boolean startEditing(IPart part) {
        if (part == null) {
            return false;
        }
        ITool selectTool = this.getDefaultTool();
        ITool editTool = this.getEditTool(part);
        if (selectTool == null || editTool == null) {
            return false;
        }
        this.startEditing(part, selectTool, editTool);
        return this.isEditing(part);
    }

    private void startEditing(IPart part, ITool selectTool, ITool editTool) {
        if (part instanceof ITopicPart || part instanceof IBoundaryPart || part instanceof IRelationshipPart) {
            ((AbstractTool)editTool).getStatus().setStatus(4096, true);
            Request request = new Request("edit");
            request.setPrimaryTarget(part);
            selectTool.handleRequest(request);
        } else if (part instanceof ILabelPart) {
            ((AbstractTool)editTool).getStatus().setStatus(4096, true);
            Request request = new Request("edit label");
            ILabelPart p = (ILabelPart)part;
            IBranchPart branch = p.getOwnedBranch();
            ITopicPart topicPart = branch.getTopicPart();
            request.setPrimaryTarget((IPart)topicPart);
            selectTool.handleRequest(request);
        }
    }

    protected SearchData findNext(String toFind, SearchData current) {
        return this.findNext(toFind, current, null);
    }

    protected SearchData findNext(String toFind, SearchData current, SearchData start) {
        if (current == null || current.equals(start)) {
            return null;
        }
        String text = this.getText(current.host);
        if (text == null) {
            return null;
        }
        int index = this.indexOf(text, toFind, current.offset);
        if (index >= 0) {
            return new SearchData(current.host, index);
        }
        if (start == null) {
            start = current;
        }
        IPart next = this.getNextPart(current);
        String nextText = this.getText(next);
        while (nextText == null) {
            if ((next = this.getNextPart(next)) == start.host) break;
            nextText = this.getText(next);
        }
        int newOffset = this.getNewOffset(nextText);
        if (next != start.host) {
            SearchData data = new SearchData(next, newOffset);
            return this.findNext(toFind, data, start);
        }
        index = this.indexOf(nextText, toFind, newOffset);
        if (index >= 0 && this.isIndexPermitted(index, start.offset)) {
            return new SearchData(next, index);
        }
        return null;
    }

    protected List<IPart> findAllParts(String toFind) {
        return this.findAllParts(toFind, this.getCurrentPart(), null, new ArrayList<IPart>());
    }

    protected List<IPart> findAllParts(String toFind, IPart current, IPart start, List<IPart> result) {
        IPart next;
        String text;
        int index;
        if (start == null) {
            start = current;
        }
        if ((index = this.indexOf(text = this.getText(current), toFind, this.getNewOffset(text))) >= 0) {
            result.add(current);
        }
        if ((next = this.getNextPart(current)) != start) {
            result = this.findAllParts(toFind, next, start, result);
        }
        return result;
    }

    protected boolean select(List<IPart> result) {
        ITool selectTool;
        if (this.isEditing(null)) {
            this.getEditTool(null).handleRequest("finish", (IViewer)this.getActiveViewer());
        }
        if ((selectTool = this.getDefaultTool()) == null) {
            return false;
        }
        selectTool.handleRequest(new Request("select").setTargets(result));
        return true;
    }

    protected boolean canReplace(String toFind, FloatingTextEditor textEditor) {
        ITextSelection selection = (ITextSelection)textEditor.getSelection();
        String selectionText = selection.getText();
        if (!this.equals(toFind, selectionText)) {
            return false;
        }
        if (this.isWholeWord()) {
            String text = textEditor.getTextContents();
            return this.isWholeWord(text, selection.getOffset(), selection.getLength());
        }
        return true;
    }

    protected String getText(IPart p) {
        if (p == null) {
            return null;
        }
        if (p instanceof ILabelPart) {
            ILabelPart labelPart = (ILabelPart)p;
            String text = labelPart.getLabelText();
            return text;
        }
        ITitled titled = (ITitled)p.getAdapter(ITitled.class);
        if (titled != null && titled.hasTitle()) {
            return titled.getTitleText();
        }
        return (String)p.getAdapter(String.class);
    }

    private IPart getNextPart(SearchData current) {
        return this.getNextPart(current.host);
    }

    private IPart getNextPart(IPart current) {
        return this.isForward() ? this.getForwardPart(current) : this.getBackwardPart(current);
    }

    private IPart getBackwardPart(IPart current) {
        IPart prev = this.findPrecedingPart(current);
        if (!this.isWorkbook()) {
            return prev;
        }
        int pageIndex = this.getActivePage().getIndex();
        int pageCount = this.editor.getPageCount();
        pageIndex = pageIndex == 0 ? pageCount - 1 : --pageIndex;
        this.editor.setActivePage(pageIndex);
        return this.getCurrentCentralTopicPart();
    }

    private IPart getForwardPart(IPart current) {
        int pageCount;
        IPart prev = this.findSucceedingPart(current);
        if (!this.isWorkbook()) {
            return prev;
        }
        int pageIndex = this.getActivePage().getIndex();
        pageIndex = pageIndex == (pageCount = this.editor.getPageCount()) - 1 ? 0 : ++pageIndex;
        this.editor.setActivePage(pageIndex);
        return this.getCurrentCentralTopicPart();
    }

    private IPart findPrecedingPart(IPart current) {
        if (current.hasRole("navigable role")) {
            IPart[] parts;
            Request navRequest = new Request("navigate previous").setPrimaryTarget(current).setViewer(current.getSite().getViewer());
            current.handleRequest(navRequest, "navigable role");
            Object result = navRequest.getResult("navigationResult");
            if (result instanceof IPart[] && (parts = (IPart[])result).length > 0) {
                return parts[0];
            }
        }
        return current;
    }

    private IPart findSucceedingPart(IPart current) {
        if (current.hasRole("navigable role")) {
            IPart[] parts;
            Request navRequest = new Request("navigate next");
            navRequest.setPrimaryTarget(current);
            IViewer viewer = current.getSite().getViewer();
            navRequest.setViewer(viewer);
            current.handleRequest(navRequest, "navigable role");
            Object result = navRequest.getResult("navigationResult");
            if (result instanceof IPart[] && (parts = (IPart[])result).length > 0) {
                IPart part = parts[0];
                return part;
            }
        }
        return current;
    }

    @Override
    public int getParameter() {
        return parameter;
    }

    @Override
    public void setParameter(int op, boolean value) {
        parameter &= ~op;
        if (value) {
            parameter |= op;
        }
    }

    public boolean canFind() {
        return this.cachedToFind != null;
    }

    public boolean findAll() {
        return this.findAll(this.cachedToFind);
    }

    public boolean findNext() {
        return this.findNext(this.cachedToFind);
    }

    public boolean replaceNext(String toReplaceWith) {
        return this.replaceNext(this.cachedToFind, toReplaceWith);
    }

    public boolean replaceAll(String toReplaceWith) {
        return this.replaceAll(this.cachedToFind, toReplaceWith);
    }

    protected FloatingTextEditor getTextEditor(IPart part) {
        ITool editTool = this.getEditTool(part);
        if (editTool instanceof FloatingTextEditTool) {
            return ((FloatingTextEditTool)editTool).getEditor();
        }
        return null;
    }

    protected boolean isEditing(IPart part) {
        ITool editTool = this.getEditTool(part);
        return editTool != null && ((AbstractTool)editTool).getStatus().isStatus(1);
    }

    protected ITool getEditTool(IPart part) {
        EditDomain domain = this.getCurrentDomain();
        if (part instanceof ILabelPart) {
            return domain == null ? null : domain.getTool("org.xmind.ui.tool.editLabel");
        }
        if (part instanceof IBoundaryPart || part instanceof IRelationshipPart) {
            return domain == null ? null : domain.getTool("edit tool");
        }
        return domain == null ? null : domain.getTool("org.xmind.ui.tool.editTopicTitle");
    }

    protected ITool getDefaultTool() {
        EditDomain domain = this.getCurrentDomain();
        return domain == null ? null : domain.getDefaultTool();
    }

    protected EditDomain getCurrentDomain() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getEditDomain();
    }

    protected IGraphicalViewer getActiveViewer() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getViewer();
    }

    private IGraphicalEditorPage getActivePage() {
        return this.editor.getActivePageInstance();
    }

    private class SearchData {
        IPart host;
        int offset;

        public SearchData(IPart host, int offset) {
            this.host = host;
            this.offset = offset;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SearchData)) {
                return false;
            }
            SearchData sd = (SearchData)obj;
            return sd.host == this.host && sd.offset == this.offset;
        }
    }
}

