/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.xmind.ui.internal.editor.FileEditorInput;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.util.Logger;

public class FileEditorInputFactory
implements IElementFactory {
    private static final String ID = "org.xmind.ui.WorkbookEditorInputFactory";
    private static final String TAG_PATH = "path";
    private static final String TAG_RESOURCE_PATH = "resourcePath";

    public IAdaptable createElement(IMemento memento) {
        String path = memento.getString(TAG_PATH);
        if (path != null) {
            try {
                return MME.createFileEditorInput(path);
            }
            catch (CoreException e) {
                Logger.log(e);
                return null;
            }
        }
        path = memento.getString(TAG_RESOURCE_PATH);
        if (path != null) {
            try {
                return this.createResourceFileEditorInput(path);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
        }
        return null;
    }

    private IEditorInput createResourceFileEditorInput(String resourcePath) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourcePath));
        return MME.createFileEditorInput(file);
    }

    public static String getFactoryId() {
        return ID;
    }

    static void saveState(IMemento memento, FileEditorInput input) {
        File file = input.getFile();
        memento.putString(TAG_PATH, file.getAbsolutePath());
    }
}

