/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.internal.dialogs.HyperlinkPageDescriptor;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkPageRegistry
extends RegistryReader {
    private static HyperlinkPageRegistry instance = null;
    private List<HyperlinkPageDescriptor> hyperlinkPageDescriptors = null;

    public static HyperlinkPageRegistry getInstance() {
        if (instance == null) {
            instance = new HyperlinkPageRegistry();
        }
        return instance;
    }

    private HyperlinkPageRegistry() {
    }

    public List<HyperlinkPageDescriptor> getHyperlinkPageDescriptors() {
        this.ensureLoaded();
        return this.hyperlinkPageDescriptors;
    }

    private void ensureLoaded() {
        if (this.hyperlinkPageDescriptors != null) {
            return;
        }
        this.lazyLoad();
        if (this.hyperlinkPageDescriptors == null) {
            this.hyperlinkPageDescriptors = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "hyperlinkPages");
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("page")) {
            this.readHyperlinkPageDescriptor(element);
            return true;
        }
        return false;
    }

    public void readHyperlinkPageDescriptor(IConfigurationElement element) {
        try {
            this.registerHyperlinkPageDescriptor(new HyperlinkPageDescriptor(element));
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private void registerHyperlinkPageDescriptor(HyperlinkPageDescriptor hyperlinkPageDescriptor) {
        if (this.hyperlinkPageDescriptors == null) {
            this.hyperlinkPageDescriptors = new ArrayList<HyperlinkPageDescriptor>();
        }
        this.hyperlinkPageDescriptors.add(hyperlinkPageDescriptor);
    }
}

