/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.util.ImageFormat;

public class DialogUtils {
    private DialogUtils() {
    }

    public static void makeDefaultImageSelectorDialog(FileDialog dialog, boolean withAllFileFilter) {
        DialogUtils.makeImageSelectorDialog(dialog, withAllFileFilter, ImageFormat.values());
    }

    public static void makeImageSelectorDialog(FileDialog dialog, boolean withAllFileFilter, ImageFormat ... imageFormats) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (withAllFileFilter) {
            extensions.add("*.*");
            names.add(NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName));
        }
        ImageFormat[] imageFormatArray = imageFormats;
        int n = imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            List exts = format.getExtensions();
            if (!exts.isEmpty()) {
                StringBuilder extBuilder = new StringBuilder(exts.size() * 5);
                StringBuilder extDescBuilder = new StringBuilder(exts.size() * 5);
                for (String ext : exts) {
                    String pattern = "*" + ext;
                    if (extBuilder.length() > 0) {
                        extBuilder.append(";");
                    }
                    extBuilder.append(pattern);
                    if (extDescBuilder.length() > 0) {
                        extDescBuilder.append(", ");
                    }
                    extDescBuilder.append(pattern);
                }
                extensions.add(extBuilder.toString());
                names.add(NLS.bind((String)"{0} ({1})", (Object)format.getDescription(), (Object)extDescBuilder.toString()));
            }
            ++n2;
        }
        dialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
        dialog.setFilterNames(names.toArray(new String[names.size()]));
    }

    public static boolean confirmOverwrite(Shell shell, String filePath) {
        return MessageDialog.openConfirm((Shell)shell, (String)DialogMessages.ConfirmOverwrite_title, (String)NLS.bind((String)DialogMessages.ConfirmOverwrite_message, (Object)filePath));
    }

    public static boolean confirmRestart(Shell shell) {
        return new MessageDialog(null, DialogMessages.ConfirmRestart_title, null, DialogMessages.ConfirmRestart_message, 3, new String[]{DialogMessages.ConfirmRestart_Restart, DialogMessages.ConfirmRestart_Continue}, 1).open() == 0;
    }
}

