/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class TopicDecorator
extends Decorator {
    private static final TopicDecorator instance = new TopicDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof TopicFigure) {
            IBranchPart branch = MindMapUtils.findBranch((IPart)part);
            if (branch != null) {
                part = branch;
            }
            this.decorateTopic(part, StyleUtils.getStyleSelector(part), (TopicFigure)figure);
        }
    }

    private void decorateTopic(IGraphicalPart part, IStyleSelector ss, TopicFigure figure) {
        String newShapeId;
        ITopicDecoration shape = figure.getDecoration();
        if (!StyleUtils.isSameDecoration((IDecoration)shape, newShapeId = StyleUtils.getString(part, ss, "shape-class", "org.xmind.topicShape.roundedRect"))) {
            shape = StyleUtils.createTopicDecoration(part, newShapeId);
            figure.setDecoration(shape);
        }
        if (shape != null) {
            String decorationId = shape.getId();
            shape.setAlpha((IFigure)figure, 255);
            shape.setFillAlpha((IFigure)figure, 255);
            shape.setLineAlpha((IFigure)figure, 255);
            shape.setFillColor((IFigure)figure, StyleUtils.getColor(part, ss, "svg:fill", decorationId, "#d0d0d0"));
            shape.setGradient((IFigure)figure, this.usesGradientColor(part));
            shape.setLeftMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-left", decorationId, 10));
            shape.setRightMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-left", decorationId, 10));
            shape.setTopMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-top", decorationId, 5));
            shape.setBottomMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-bottom", decorationId, 5));
            shape.setLineColor((IFigure)figure, StyleUtils.getColor(part, ss, "line-color", decorationId, "#808080"));
            shape.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(part, ss, decorationId, 1));
            shape.setLineWidth((IFigure)figure, StyleUtils.getInteger(part, ss, "line-width", decorationId, 1));
            shape.setVisible((IFigure)figure, true);
            if (shape instanceof ICorneredDecoration) {
                ((ICorneredDecoration)shape).setCornerSize((IFigure)figure, StyleUtils.getInteger(part, ss, "shape-corner", decorationId, 10));
            }
        }
        double angle = StyleUtils.getDouble(part, ss, "rotate-angle", 0.0);
        figure.setRotationDegrees(angle);
    }

    private boolean usesGradientColor(IGraphicalPart part) {
        boolean isGColor = MindMapUI.isGradientColor();
        return part.getSite().getViewer().getProperties().getBoolean("gradient", isGColor);
    }

    public static TopicDecorator getInstance() {
        return instance;
    }
}

