/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.figures.PlusMinusFigure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IPlusMinusPart;

public class PlusMinusDecorator
extends Decorator {
    private static final PlusMinusDecorator instance = new PlusMinusDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setMinimumSize(IMinimizable.DEFAULT_MIN_SIZE);
        figure.setPreferredSize(new Dimension(11, 11));
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof PlusMinusFigure) {
            PlusMinusFigure pmFigure = (PlusMinusFigure)figure;
            if (part instanceof IPlusMinusPart) {
                IPlusMinusPart pm = (IPlusMinusPart)part;
                this.decorate(pm, pmFigure);
            }
        }
    }

    protected void decorate(IPlusMinusPart pm, PlusMinusFigure figure) {
        IBranchPart branch = pm.getOwnerBranch();
        if (branch != null) {
            figure.setValue(branch.isFolded());
            boolean canFold = branch.isPropertyModifiable("topicFolded");
            figure.setVisible(canFold);
        } else {
            figure.setValue(false);
        }
    }

    public static PlusMinusDecorator getInstance() {
        return instance;
    }
}

