/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractRelationshipDecoration;

public class ZigzagRelationshipDecoration
extends AbstractRelationshipDecoration {
    public ZigzagRelationshipDecoration() {
    }

    public ZigzagRelationshipDecoration(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        PrecisionPoint scp = new PrecisionPoint(this.getSourceControlPoint(figure));
        PrecisionPoint tcp = new PrecisionPoint(this.getTargetControlPoint(figure));
        if (Math.abs(tcp.x - tp.x) <= Math.abs(tcp.y - tp.y)) {
            tcp.x = tp.x;
        } else {
            tcp.y = tp.y;
        }
        if (Math.abs(scp.x - sp.x) <= Math.abs(scp.y - sp.y)) {
            scp.x = sp.x;
        } else {
            scp.y = sp.y;
        }
        if (tcp.x == tp.x) {
            if (scp.x == sp.x) {
                tcp.y = scp.y = (scp.y + tcp.y) / 2.0;
            } else if (scp.y == sp.y) {
                tcp.y = scp.y = sp.y;
                scp.x = tp.x;
            }
        } else if (tcp.y == tp.y) {
            if (scp.y == sp.y) {
                tcp.x = scp.x = (tcp.x + scp.x) / 2.0;
            } else if (scp.x == sp.x) {
                tcp.x = scp.x = sp.x;
                scp.y = tp.y;
            }
        }
        shape.moveTo(sp);
        shape.lineTo(scp);
        shape.lineTo(tcp);
        shape.lineTo(tp);
    }

    protected double getSourceAnchorAngle(IFigure figure) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        PrecisionPoint scp = new PrecisionPoint(this.getSourceControlPoint(figure));
        PrecisionPoint tcp = this.getTargetControlPoint(figure);
        PrecisionPoint p1 = new PrecisionPoint(0.0, 0.0);
        PrecisionPoint p2 = new PrecisionPoint(0.0, 0.0);
        if (Math.abs(scp.x - sp.x) <= Math.abs(scp.y - sp.y)) {
            if (tp.y < sp.y) {
                p1 = new PrecisionPoint(0, 1);
                p2 = new PrecisionPoint(0, 0);
                if ((tcp.y + scp.y) / 2.0 > sp.y) {
                    p1 = new PrecisionPoint(0, -1);
                    p2 = new PrecisionPoint(0, 0);
                }
            } else if (tp.y > sp.y) {
                p1 = new PrecisionPoint(0, -1);
                p2 = new PrecisionPoint(0, 0);
                if ((tcp.y + scp.y) / 2.0 < sp.y) {
                    p1 = new PrecisionPoint(0, 1);
                    p2 = new PrecisionPoint(0, 0);
                }
            }
        } else if (tp.x < sp.x) {
            p1 = new PrecisionPoint(1, 0);
            p2 = new PrecisionPoint(0, 0);
            if ((tcp.x + scp.x) / 2.0 > sp.x) {
                p1 = new PrecisionPoint(0, 0);
                p2 = new PrecisionPoint(0, 0);
            }
        } else if (tp.x > sp.x) {
            p1 = new PrecisionPoint(0, 0);
            p2 = new PrecisionPoint(0, 0);
            if ((tcp.x + scp.x) / 2.0 < sp.x) {
                p1 = new PrecisionPoint(1, 0);
                p2 = new PrecisionPoint(0, 0);
            }
        }
        return Geometry.getAngle((PrecisionPoint)p2, (PrecisionPoint)p1);
    }

    protected double getTargetAnchorAngle(IFigure figure) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        PrecisionPoint tcp = this.getTargetControlPoint(figure);
        PrecisionPoint scp = this.getSourceControlPoint(figure);
        PrecisionPoint p1 = new PrecisionPoint(0.0, 0.0);
        PrecisionPoint p2 = new PrecisionPoint(0.0, 0.0);
        if (Math.abs(tcp.x - tp.x) <= Math.abs(tcp.y - tp.y)) {
            if (tp.y > sp.y) {
                p1 = new PrecisionPoint(0, 1);
                p2 = new PrecisionPoint(0, 0);
                if ((tcp.y + scp.y) / 2.0 > tp.y) {
                    p1 = new PrecisionPoint(0, -1);
                    p2 = new PrecisionPoint(0, 0);
                }
            } else if (tp.y < sp.y) {
                p1 = new PrecisionPoint(0, -1);
                p2 = new PrecisionPoint(0, 0);
                if ((tcp.y + scp.y) / 2.0 < tp.y) {
                    p1 = new PrecisionPoint(0, 1);
                    p2 = new PrecisionPoint(0, 0);
                }
            }
        } else if (tp.x < sp.x) {
            p1 = new PrecisionPoint(-1, 0);
            p2 = new PrecisionPoint(0, 0);
            if ((tcp.x + scp.x) / 2.0 < tp.x) {
                p1 = new PrecisionPoint(1, 0);
                p2 = new PrecisionPoint(0, 0);
            }
        } else if (tp.x > sp.x) {
            p1 = new PrecisionPoint(1, 0);
            p2 = new PrecisionPoint(0, 0);
            if ((tcp.x + scp.x) / 2.0 > tp.x) {
                p1 = new PrecisionPoint(-1, 0);
                p2 = new PrecisionPoint(0, 0);
            }
        }
        return Geometry.getAngle((PrecisionPoint)p2, (PrecisionPoint)p1);
    }

    protected void calcTitlePosition(IFigure figure, PrecisionPoint titlePos, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint sourceCP, PrecisionPoint targetCP) {
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(targetCP.x - targetPos.x) <= Math.abs(targetCP.y - targetPos.y) && Math.abs(sourceCP.x - sourcePos.x) <= Math.abs(sourceCP.y - sourcePos.y)) {
            x = (sourcePos.x + targetPos.x) / 2.0;
            y = (sourceCP.y + targetCP.y) / 2.0;
        } else if (Math.abs(targetCP.x - targetPos.x) <= Math.abs(targetCP.y - targetPos.y) && Math.abs(sourceCP.x - sourcePos.x) > Math.abs(sourceCP.y - sourcePos.y)) {
            x = targetPos.x;
            y = sourcePos.y;
        } else if (Math.abs(targetCP.x - targetPos.x) > Math.abs(targetCP.y - targetPos.y) && Math.abs(sourceCP.x - sourcePos.x) <= Math.abs(sourceCP.y - sourcePos.y)) {
            x = sourcePos.x;
            y = targetPos.y;
        } else if (Math.abs(targetCP.x - targetPos.x) > Math.abs(targetCP.y - targetPos.y) && Math.abs(sourceCP.x - sourcePos.x) > Math.abs(sourceCP.y - sourcePos.y)) {
            x = (sourceCP.x + targetCP.x) / 2.0;
            y = (sourcePos.y + targetPos.y) / 2.0;
        }
        titlePos.setLocation(x, y);
    }
}

