/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBranchConnection;

public class CurveBranchConnection
extends AbstractBranchConnection {
    private static final double CPRatio = 0.3333333333333333;
    private PrecisionPoint s1 = new PrecisionPoint();
    private PrecisionPoint s2 = new PrecisionPoint();
    private PrecisionPoint t1 = new PrecisionPoint();
    private PrecisionPoint t2 = new PrecisionPoint();
    private PrecisionPoint c1 = new PrecisionPoint();
    private PrecisionPoint c2 = new PrecisionPoint();
    private PrecisionPoint c3 = new PrecisionPoint();
    private PrecisionPoint c4 = new PrecisionPoint();
    private PrecisionPoint control = null;

    public CurveBranchConnection() {
    }

    public CurveBranchConnection(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sourcePos = this.getSourcePosition(figure);
        PrecisionPoint targetPos = this.getTargetPosition(figure);
        if (this.isTapered()) {
            shape.moveTo(this.s1);
            shape.quadTo(this.c1, this.t1);
            shape.lineTo(this.t2);
            shape.quadTo(this.c2, this.s2);
            shape.close();
        } else {
            shape.moveTo(sourcePos);
            shape.quadTo(this.control, targetPos);
        }
    }

    protected void calculateControlPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
        this.control = new PrecisionPoint();
        this.calcControlPoint(sourcePos, targetPos, this.isTargetHorizontal(), this.control);
        if (this.isTapered()) {
            this.calcTaperedPositions(sourcePos, this.control, 0.0, this.s1, this.s2);
            this.calcTaperedPositions(this.control, sourcePos, 0.0, 2.0, this.c2, this.c1);
            this.calcTaperedPositions(this.control, targetPos, 1.0, 1.0, this.t1, this.t2);
            this.calcTaperedPositions(this.control, targetPos, 0.0, 2.0, this.c3, this.c4);
            PrecisionLine l1 = new PrecisionLine(this.s1, this.c1, PrecisionLine.LineType.Ray);
            PrecisionLine l2 = new PrecisionLine(this.t1, this.c3, PrecisionLine.LineType.Ray);
            List ps = l1.getLinesIntersections(l2);
            if (!ps.isEmpty() && ps.size() == 1) {
                this.c1.setLocation((PrecisionPoint)ps.get(0));
            }
            l1.setOrigin(this.s2);
            l1.setTerminus(this.c2);
            l2.setOrigin(this.t2);
            l2.setTerminus(this.c4);
            ps = l1.getLinesIntersections(l2);
            if (!ps.isEmpty() && ps.size() == 1) {
                this.c2.setLocation((PrecisionPoint)ps.get(0));
            }
        }
    }

    protected boolean isPositionValid() {
        return super.isPositionValid() && this.control != null;
    }

    public void invalidate() {
        super.invalidate();
        this.control = null;
    }

    protected boolean isTargetHorizontal() {
        return (this.getTargetOrientation() & 0x18) != 0;
    }

    protected double getControlPointRatio() {
        return 0.3333333333333333;
    }

    protected PrecisionPoint calcControlPoint(PrecisionPoint source, PrecisionPoint target, boolean targetHorizontal, PrecisionPoint result) {
        return result.setLocation(targetHorizontal ? target.x * this.getControlPointRatio() + source.x * (1.0 - this.getControlPointRatio()) : target.x, targetHorizontal ? target.y : target.y * this.getControlPointRatio() + source.y * (1.0 - this.getControlPointRatio()));
    }
}

