/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.Set;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.IBranchStyleSelector;
import org.xmind.ui.internal.branch.ParentValueProvider;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.style.MindMapStyleSelectorBase;
import org.xmind.ui.style.StyleUtils;

public class DefaultBranchStyleSelector
extends MindMapStyleSelectorBase
implements IBranchStyleSelector {
    private static DefaultBranchStyleSelector instance = null;
    private Set<String> inheritedStyleKeys = null;

    protected DefaultBranchStyleSelector() {
        this.registerInheritedStyleKey("line-color");
        this.registerInheritedStyleKey("line-width");
        this.registerInheritedStyleKey("line-pattern");
    }

    protected void registerInheritedStyleKey(String key) {
        if (key == null) {
            return;
        }
        if (this.inheritedStyleKeys == null) {
            this.inheritedStyleKeys = new HashSet<String>();
        }
        this.inheritedStyleKeys.add(key);
    }

    protected String getThemeStyleValue(IGraphicalPart part, String familyName, String key) {
        String value;
        if ("line-color".equals(key) && "mainTopic".equals(familyName) && part instanceof IBranchPart && this.isValidValue(part, key, value = StyleUtils.getIndexedBranchLineColor((IBranchPart)part))) {
            return value;
        }
        if (this.inheritedStyleKeys != null && this.inheritedStyleKeys.contains(key) && part instanceof IBranchPart && (value = ParentValueProvider.getValueProvider((IBranchPart)part).getParentValue(key)) != null) {
            return value;
        }
        return super.getThemeStyleValue(part, familyName, key);
    }

    public void flushStyleCaches(IBranchPart branch) {
        ParentValueProvider.flush(branch);
    }

    public String getFamilyName(IGraphicalPart part) {
        if (part instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)part;
            String branchType = branch.getBranchType();
            if ("centralBranch".equals(branchType)) {
                return "centralTopic";
            }
            if ("mainBranch".equals(branchType)) {
                return "mainTopic";
            }
            if ("floatingBranch".equals(branchType)) {
                return "floatingTopic";
            }
            if ("summaryBranch".equals(branchType)) {
                return "summaryTopic";
            }
        }
        return "subTopic";
    }

    public static DefaultBranchStyleSelector getDefault() {
        if (instance == null) {
            instance = new DefaultBranchStyleSelector();
        }
        return instance;
    }
}

