/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.branch.IBranchPropertyTester;
import org.xmind.ui.internal.branch.FalsePropertyTester;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class BranchPropertyTesterProxy
implements IBranchPropertyTester {
    private IConfigurationElement element;
    private String id;
    private IBranchPropertyTester tester;

    public BranchPropertyTesterProxy(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"class") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean test(IBranchPart branch, String property, Object[] args, Object expectedValue) {
        return this.getTester().test(branch, property, args, expectedValue);
    }

    private IBranchPropertyTester getTester() {
        if (this.tester == null) {
            try {
                this.tester = (IBranchPropertyTester)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create property tester: " + this.id);
                this.tester = FalsePropertyTester.getInstance();
            }
        }
        return this.tester;
    }
}

