/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.IMindMap;

public class SaveSheetAsAction
extends Action {
    private IGraphicalEditorPage page;

    public SaveSheetAsAction() {
        this.setId("org.xmind.ui.saveSheetAs");
        this.setText(MindMapMessages.SaveSheetAs_text);
        this.setToolTipText(MindMapMessages.SaveSheetAs_toolTip);
    }

    public void setActivePage(IGraphicalEditorPage page) {
        this.page = page;
        this.setEnabled(page != null && page.getAdapter(IMindMap.class) != null);
    }

    public void run() {
        if (this.page == null) {
            return;
        }
        IMindMap mindmap = (IMindMap)this.page.getAdapter(IMindMap.class);
        if (mindmap == null) {
            return;
        }
        ISheet sheet = mindmap.getSheet();
        final IWorkbook newWorkbook = Core.getWorkbookBuilder().createWorkbook();
        String tempLocation = this.createTempLocation();
        newWorkbook.setTempLocation(tempLocation);
        try {
            newWorkbook.saveTemp();
        }
        catch (Exception exception) {}
        ICloneData clone = newWorkbook.clone((Collection)Arrays.asList(sheet));
        ISheet newSheet = (ISheet)clone.get((Object)sheet);
        this.initSheet(newSheet);
        ITopic newCentralTopic = newWorkbook.findTopic((String)clone.get((Object)mindmap.getCentralTopic().getId()));
        if (newCentralTopic == null) {
            return;
        }
        newSheet.replaceRootTopic(newCentralTopic);
        newWorkbook.addSheet(newSheet);
        newWorkbook.removeSheet(newWorkbook.getPrimarySheet());
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IEditorPart newEditor = SaveSheetAsAction.this.page.getParentEditor().getSite().getPage().openEditor(MME.createLoadedEditorInput(newWorkbook), "org.xmind.ui.MindMapEditor", true);
                if (newEditor != null && newEditor instanceof ISaveablePart) {
                    newEditor.doSaveAs();
                }
            }
        });
    }

    public String createTempLocation() {
        String tempFile = String.valueOf(Core.getIdFactory().createId()) + ".xmind.temp";
        String hiberLoc = new File(Core.getWorkspace().getTempDir("workbooks"), tempFile).getAbsolutePath();
        return hiberLoc;
    }

    private void initSheet(ISheet sheet) {
        this.initTopic(sheet.getRootTopic());
    }

    private void initTopic(ITopic topic) {
        for (ITopic child : topic.getAllChildren()) {
            this.initTopic(child);
        }
    }
}

