/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.File;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.MindMapUI;

public class OpenWorkbookAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String OPEN_DIALOG_SETTINGS_ID = "org.xmind.ui.openDialog";
    private static final String OLD_FILE_EXT = ".xmap";
    private static final String FILTER_INDEX = "filterIndex";
    private IWorkbenchWindow window;
    private IDialogSettings ds;

    public OpenWorkbookAction(IWorkbenchWindow window) {
        super(MindMapMessages.OpenWorkbook_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setId("org.xmind.ui.open");
        this.setImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", true));
        this.setDisabledImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", false));
        this.setToolTipText(MindMapMessages.OpenWorkbook_toolTip);
        this.setActionDefinitionId("org.xmind.ui.command.openWorkbook");
    }

    public void run() {
        if (this.window == null) {
            return;
        }
        FileDialog fd = new FileDialog(this.window.getShell(), 4098);
        String xmindExt = "*.xmind";
        String oldExt = "*.xmap";
        String allSupportedFileExt = String.format("%s;%s", xmindExt, oldExt);
        String allExt = "*.*";
        fd.setFilterExtensions(new String[]{xmindExt, oldExt, allSupportedFileExt, allExt});
        fd.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)DialogMessages.WorkbookFilterName, (Object)xmindExt), NLS.bind((String)"{0} ({1})", (Object)DialogMessages.OldWorkbookFilterName, (Object)oldExt), NLS.bind((String)"{0} ({1}, {2})", (Object[])new Object[]{DialogMessages.AllSupportedFilesFilterName, xmindExt, oldExt}), NLS.bind((String)"{0} ({1})", (Object)DialogMessages.AllFilesFilterName, (Object)allExt)});
        fd.setFilterIndex(this.getFilterIndex());
        if (fd.open() == null) {
            return;
        }
        String path = fd.getFilterPath();
        String[] fileNames = fd.getFileNames();
        this.setFilterIndex(fd.getFilterIndex());
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            File file = new File(path, f);
            if (file.exists()) {
                this.open(file);
            }
            ++n2;
        }
    }

    private void setFilterIndex(int index) {
        this.getDialogSettings().put(FILTER_INDEX, index);
    }

    private int getFilterIndex() {
        try {
            int filterIndex = this.getDialogSettings().getInt(FILTER_INDEX);
            if (filterIndex >= 0 && filterIndex <= 2) {
                return filterIndex;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 2;
    }

    private IDialogSettings getDialogSettings() {
        if (this.ds == null) {
            IDialogSettings global = MindMapUIPlugin.getDefault().getDialogSettings();
            this.ds = global.getSection(OPEN_DIALOG_SETTINGS_ID);
            if (this.ds == null) {
                this.ds = global.addNewSection(OPEN_DIALOG_SETTINGS_ID);
            }
        }
        return this.ds;
    }

    protected void open(final File file) {
        String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)file.getAbsolutePath());
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

            public void run() throws Exception {
                IEditorInput input = MME.createFileEditorInput(file);
                OpenWorkbookAction.this.window.getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
            }
        });
    }

    public void dispose() {
        this.window = null;
    }
}

